/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.commandline;

import de.fzi.sissy.commandline.SISSyConfigurationBuilder;
import de.fzi.sissy.gastimporter.jobs.GASTModelImporterJob;
import de.fzi.sissy.main.configurations.SISSyConfiguration;
import de.fzi.sissy.main.jobs.SISSyJob;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.utils.Debug;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingCompositeJob;
import de.uka.ipd.sdq.workflow.Workflow;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class SISSyRunner
implements IApplication {
    private static final float THOUSAND = 1000.0f;
    private static final int CONFIG_LOG_LEVEL = 7;

    public static void main(String[] args) {
        Debug.setDebugLevel((int)7);
        Debug.debug((String)("SISSYRunner main: #args: " + args.length));
        SISSyRunner runner = new SISSyRunner();
        SISSyConfigurationBuilder builder = new SISSyConfigurationBuilder();
        SISSyConfiguration sissyConfiguration = builder.convertArgsToSISSyConfig(args);
        if (sissyConfiguration.isValid()) {
            Debug.debug((String)"valid configuration!");
            runner.run(sissyConfiguration);
        } else {
            Debug.debug((String)"validity error");
            builder.getArgParserBuilder().getSISSyArgParser().printHelp();
        }
    }

    private static SISSyRunner getRunnerClassInstance(String runnerClass) {
        if (runnerClass == null) {
            return new SISSyRunner();
        }
        try {
            return (SISSyRunner)Class.forName(runnerClass).newInstance();
        }
        catch (Exception exception) {
            Debug.error((String)("unable to instanciate runner class \"" + runnerClass + "\""));
            throw new Error("Unable to instanciate runner class \"" + runnerClass + "\"");
        }
    }

    public ModelElementRepository run(SISSyConfiguration sissyConfiguration) {
        this.configureLogging();
        OrderPreservingCompositeJob compositeJob = this.createCompositeJob(sissyConfiguration);
        if (compositeJob.size() == 0) {
            throw new Error("SISSy called without parameters!");
        }
        return this.createAndRunWorkflow(compositeJob);
    }

    private OrderPreservingCompositeJob createCompositeJob(SISSyConfiguration sissyConfiguration) {
        OrderPreservingCompositeJob compositeJob = new OrderPreservingCompositeJob();
        compositeJob.setName("SISSy Main Task");
        if (sissyConfiguration.doRunSissy()) {
            compositeJob.add((IJob)new SISSyJob(sissyConfiguration));
        }
        if (sissyConfiguration.getGASTImporterConfiguration().isDoExportGAST()) {
            compositeJob.add((IJob)new GASTModelImporterJob(sissyConfiguration.getGASTImporterConfiguration()));
        }
        return compositeJob;
    }

    private ModelElementRepository createAndRunWorkflow(OrderPreservingCompositeJob compositeJob) {
        long currentMillis = System.currentTimeMillis();
        Workflow sissyWorkflowRunner = new Workflow((IJob)compositeJob);
        sissyWorkflowRunner.run();
        Debug.println((String)("Time elapsed so far " + Float.toString((float)(System.currentTimeMillis() - currentMillis) / 1000.0f) + " s"));
        ModelElementRepository.dispose();
        return null;
    }

    private void configureLogging() {
        Debug.setDebugLevel((int)7);
    }

    public Object start(IApplicationContext context) throws Exception {
        this.initializeLogger();
        String[] args = (String[])context.getArguments().get("application.args");
        System.out.println("Start SISSy Runner");
        SISSyRunner.main(args);
        return null;
    }

    private void initializeLogger() {
        Logger logger = Logger.getRootLogger();
        logger.setLevel(Level.ALL);
        SimpleLayout layout = new SimpleLayout();
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
        logger.addAppender((Appender)consoleAppender);
    }

    public void stop() {
    }
}

