/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.commandline;

import de.fzi.sissy.commandline.ArgParser;
import de.fzi.sissy.commandline.ArgParserBuilder;
import de.fzi.sissy.extractors.CloneAnalysisConfiguration;
import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.gastimporter.GASTImporterConfiguration;
import de.fzi.sissy.main.configurations.AnalysisConfiguration;
import de.fzi.sissy.main.configurations.ExpressionExportConfiguration;
import de.fzi.sissy.main.configurations.SISSyConfiguration;
import de.fzi.sissy.persistence.ExportConfiguration;
import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.persistence.config.DerbyDatabaseConfiguration;
import de.fzi.sissy.persistence.config.FileBasedDatabaseConfiguration;
import de.fzi.sissy.persistence.config.MysqlDatabaseConfiguration;
import de.fzi.sissy.persistence.config.NullDatabaseConfiguration;
import de.fzi.sissy.persistence.config.PostgresqlDatabaseConfiguration;
import de.fzi.sissy.persistence.config.SqliteDatabaseConfiguration;
import de.fzi.sissy.utils.Debug;

public class SISSyConfigurationBuilder {
    public static final String CPP = "cpp";
    public static final String JAVA = "java";
    public static final String DELPHI = "delphi";
    private ArgParserBuilder argParserBuilder;

    public SISSyConfiguration convertArgsToSISSyConfig(String[] args) {
        this.printArguments(args);
        ArgParser argParser = this.createAndInitializeArgParser(args);
        SISSyConfiguration sissyConfiguration = new SISSyConfiguration((DatabaseConfiguration)new NullDatabaseConfiguration());
        ExtractorConfiguration extractorConfig = sissyConfiguration.getExtractorConfiguration();
        AnalysisConfiguration analysisConfig = sissyConfiguration.getAnalysisConfiguration();
        ExportConfiguration exportConfig = sissyConfiguration.getExportConfiguration();
        ExpressionExportConfiguration exprExportConfig = sissyConfiguration.getExpressionExportConfiguration();
        this.extractGenericParameters(argParser, extractorConfig, analysisConfig);
        this.handleLanguageSpecificParameters(argParser, extractorConfig);
        this.setupCommentExtraction(argParser, extractorConfig);
        this.setupConfigurations(argParser, sissyConfiguration, analysisConfig, exportConfig);
        this.checkValidation(extractorConfig, analysisConfig, exportConfig, exprExportConfig);
        return sissyConfiguration;
    }

    private void setupCommentExtraction(ArgParser argParser, ExtractorConfiguration extractorConfig) {
        if (argParser.hasParameter("nocomments")) {
            extractorConfig.setExtractComments(false);
        } else {
            extractorConfig.setExtractComments(true);
        }
    }

    private ArgParser createAndInitializeArgParser(String[] args) {
        this.argParserBuilder = new ArgParserBuilder();
        ArgParser argParser = this.argParserBuilder.initializeMainArgumentParser(args);
        this.argParserBuilder.addGenericExtractorOptions(argParser);
        return argParser;
    }

    private void printArguments(String[] args) {
        Debug.info((String)"args: ");
        int i = 0;
        while (i < args.length) {
            Debug.info((String)(String.valueOf(i) + ":" + args[i]));
            ++i;
        }
    }

    private void setupConfigurations(ArgParser argParser, SISSyConfiguration sissyConfiguration, AnalysisConfiguration analysisConfig, ExportConfiguration exportConfig) {
        this.setupExportConfiguration(argParser, exportConfig);
        this.setupGASTImporterConfiguration(argParser, sissyConfiguration);
        this.setupAnalysisConfiguration(argParser, analysisConfig);
    }

    private void handleLanguageSpecificParameters(ArgParser argParser, ExtractorConfiguration extractorConfig) {
        if (argParser.hasParameter(JAVA)) {
            this.handleJAVA(argParser, extractorConfig);
        }
        if (argParser.hasParameter(CPP)) {
            this.handleCPP(argParser, extractorConfig);
        }
        if (argParser.hasParameter(DELPHI)) {
            this.handleDELPHI(argParser, extractorConfig);
        }
    }

    private void handleJAVA(ArgParser argParser, ExtractorConfiguration extractorConfig) {
        this.argParserBuilder.addJAVASpecificOptions(argParser);
        this.extractJAVASpecificParameters(argParser, extractorConfig);
        extractorConfig.setProgrammingLanguage(ExtractorConfiguration.ProgrammingLanguage.JAVA);
        if (!extractorConfig.isValid()) {
            Debug.error((String)("Java Extractor Configuration not valid: " + extractorConfig.getErrorMessage()));
            argParser.printHelp();
        }
    }

    private void handleCPP(ArgParser argParser, ExtractorConfiguration extractorConfig) {
        this.argParserBuilder.addCPPSpecificOptions(argParser);
        this.extractCPPSpecificParameters(argParser, extractorConfig);
        extractorConfig.setProgrammingLanguage(ExtractorConfiguration.ProgrammingLanguage.CPP);
        if (!extractorConfig.isValid()) {
            Debug.error((String)("CPP Extractor Configuration not valid: " + extractorConfig.getErrorMessage()));
            argParser.printHelp();
        }
    }

    private void handleDELPHI(ArgParser argParser, ExtractorConfiguration extractorConfig) {
        this.argParserBuilder.addDelphiSpecificOptions(argParser);
        this.extractDelphiSpecificParameters(argParser, extractorConfig);
        extractorConfig.setProgrammingLanguage(ExtractorConfiguration.ProgrammingLanguage.DELPHI);
        if (!extractorConfig.isValid()) {
            Debug.error((String)("CPP Extractor Configuration not valid: " + extractorConfig.getErrorMessage()));
            argParser.printHelp();
        }
    }

    private void checkValidation(ExtractorConfiguration extractorConfig, AnalysisConfiguration analysisConfig, ExportConfiguration exportConfig, ExpressionExportConfiguration exprExportConfig) {
        if (!extractorConfig.isValid()) {
            Debug.error((String)("Extractor Configuration invalid: " + extractorConfig.getErrorMessage()));
        }
        if (!analysisConfig.isValid()) {
            Debug.error((String)("Analysis Configuration invalid: " + analysisConfig.getErrorMessage()));
        }
        if (!exportConfig.isValid()) {
            Debug.error((String)("Exporter Configuration invalid: " + exportConfig.getErrorMessage()));
        }
        if (!exprExportConfig.isValid()) {
            Debug.error((String)("Expression Extractor configuration invalid: " + exprExportConfig.getErrorMessage()));
        }
    }

    private void setupGASTImporterConfiguration(ArgParser argParser, SISSyConfiguration sissyConfiguration) {
        GASTImporterConfiguration gastConfiguration = sissyConfiguration.getGASTImporterConfiguration();
        if (argParser.hasParameter("gast")) {
            String gastFilePaths = argParser.getParameter("gast");
            gastConfiguration.setDoExportGAST(true);
            gastConfiguration.setGASTFilePath(gastFilePaths);
            gastConfiguration.setExtractExpressions(false);
        } else {
            gastConfiguration.setDoExportGAST(false);
        }
    }

    private void setupAnalysisConfiguration(ArgParser argParser, AnalysisConfiguration analysisConfig) {
        if (argParser.hasParameter("problempattern")) {
            analysisConfig.setDoProblemPatternAnalysis(true);
            if (argParser.hasParameter("dashboard")) {
                analysisConfig.getDashboardGeneratorConfiguration().setGenerateDashboard(true);
                String targetPath = argParser.getParameter("dashboard");
                analysisConfig.getDashboardGeneratorConfiguration().setDashboardTargetDirectoryPath(targetPath);
            } else {
                analysisConfig.getDashboardGeneratorConfiguration().setGenerateDashboard(false);
            }
        } else {
            analysisConfig.setDoProblemPatternAnalysis(false);
        }
    }

    private void setupExportConfiguration(ArgParser argParser, ExportConfiguration exportConfig) {
        if (argParser.hasParameter("export")) {
            exportConfig.setDoExportModel(true);
            this.setupCommentExport(argParser, exportConfig);
            this.setupConfigFileAndOutputType(argParser, exportConfig);
        }
    }

    private void setupCommentExport(ArgParser argParser, ExportConfiguration exportConfig) {
        if (!argParser.hasParameter("nocomments") && argParser.hasParameter("ctext")) {
            exportConfig.setExportCommentTextsToDatabase(true);
        } else {
            exportConfig.setExportCommentTextsToDatabase(false);
        }
    }

    private void setupConfigFileAndOutputType(ArgParser argParser, ExportConfiguration exportConfig) {
        if (argParser.hasParameter("cfg")) {
            argParser.getParameter("cfg");
        }
        if (argParser.hasParameter("o")) {
            argParser.getParameter("o");
        } else if (argParser.hasParameter("db")) {
            this.setupDBParameters(argParser, exportConfig);
        } else {
            Debug.info((String)"No export option specified.");
        }
    }

    private void setupDBParameters(ArgParser argParser, ExportConfiguration exportConfig) {
        this.setupDBTypeAndDBName(argParser, exportConfig);
        this.setupUsernameAndPassword(argParser, exportConfig);
        this.setupUrlAndDir(argParser, exportConfig);
    }

    private void setupDBTypeAndDBName(ArgParser argParser, ExportConfiguration exportConfig) {
        if (argParser.hasParameter("dbtype")) {
            String dbtype = argParser.getParameter("dbtype");
            this.setupDBType(exportConfig, dbtype);
        }
        String dbname = argParser.getParameter("db");
        exportConfig.getDatabaseConfiguration().setDatabaseName(dbname);
    }

    private void setupUsernameAndPassword(ArgParser argParser, ExportConfiguration exportConfig) {
        if (argParser.hasParameter("u")) {
            String dbuser = argParser.getParameter("u");
            exportConfig.getDatabaseConfiguration().setDatabaseUsername(dbuser);
        }
        if (argParser.hasParameter("pw")) {
            String dbpassword = argParser.getParameter("pw");
            exportConfig.getDatabaseConfiguration().setDatabasePassword(dbpassword);
        }
    }

    private void setupUrlAndDir(ArgParser argParser, ExportConfiguration exportConfig) {
        exportConfig.getDatabaseConfiguration().setDatabaseServerurl("localhost");
        if (argParser.hasParameter("url")) {
            String dburl = argParser.getParameter("url");
            exportConfig.getDatabaseConfiguration().setDatabaseServerurl(dburl);
        } else if (argParser.hasParameter("dbdir")) {
            String dbdir = argParser.getParameter("dbdir");
            if (exportConfig instanceof FileBasedDatabaseConfiguration) {
                ((FileBasedDatabaseConfiguration)exportConfig.getDatabaseConfiguration()).setDirectoryPath(dbdir);
            }
        }
    }

    private void setupDBType(ExportConfiguration exportConfig, String dbtype) {
        if (dbtype.equals("derby")) {
            DerbyDatabaseConfiguration derbyConfig = new DerbyDatabaseConfiguration();
            exportConfig.setDatabaseConfiguration((DatabaseConfiguration)derbyConfig);
        } else if (dbtype.equals("sqlite")) {
            SqliteDatabaseConfiguration sqliteConfig = new SqliteDatabaseConfiguration();
            exportConfig.setDatabaseConfiguration((DatabaseConfiguration)sqliteConfig);
        } else if (dbtype.equals("mysql")) {
            MysqlDatabaseConfiguration mysqlConfig = new MysqlDatabaseConfiguration();
            exportConfig.setDatabaseConfiguration((DatabaseConfiguration)mysqlConfig);
        } else if (dbtype.equals("postgres")) {
            PostgresqlDatabaseConfiguration pgConfig = new PostgresqlDatabaseConfiguration();
            exportConfig.setDatabaseConfiguration((DatabaseConfiguration)pgConfig);
        }
    }

    private void extractGenericParameters(ArgParser argParser, ExtractorConfiguration extractorConfig, AnalysisConfiguration analysisConfig) {
        if (argParser.getParameterList().size() != 0) {
            String inputDirectoryPaths = argParser.getParameterList().get(0).getValue();
            Debug.info((String)("inputDirectoryPaths: " + ArgParserBuilder.getPathList(inputDirectoryPaths)));
            extractorConfig.setInputDirectoryPaths(ArgParserBuilder.getPathList(inputDirectoryPaths));
            String sourceLibraryFilePaths = argParser.getParameter("libsrc");
            extractorConfig.setSourceLibraryFilePaths(ArgParserBuilder.getPathList(sourceLibraryFilePaths));
            Debug.info((String)("sourceLibraryFilePaths as list: " + ArgParserBuilder.getPathList(sourceLibraryFilePaths)));
            String binaryLibraryPath = argParser.getParameter("libbin");
            extractorConfig.setBinaryLibraryFilePaths(ArgParserBuilder.getPathList(binaryLibraryPath));
            String excludePath = argParser.getParameter("exclude");
            extractorConfig.setExcludeFilePaths(ArgParserBuilder.getPathList(excludePath));
            if (argParser.hasParameter("clone")) {
                this.setupCloneAnalysisConfiguration(argParser, extractorConfig, analysisConfig);
            }
        }
    }

    private void setupCloneAnalysisConfiguration(ArgParser argParser, ExtractorConfiguration extractorConfig, AnalysisConfiguration analysisConfig) {
        analysisConfig.setDoCloneAnalysis(true);
        CloneAnalysisConfiguration cloneConfig = extractorConfig.getCloneAnalysisConfiguration();
        cloneConfig.setMinimumCloneLength(new Integer(argParser.getParameter("min")).intValue());
        cloneConfig.setFileFilter(argParser.getParameter("ff"));
        cloneConfig.setCommentPatternFilePath(argParser.getParameter("cf"));
        cloneConfig.setIgnoreWhitespace(argParser.hasParameter("iw"));
        cloneConfig.setIgnoreComments(argParser.hasParameter("ic"));
    }

    private void extractJAVASpecificParameters(ArgParser argParser, ExtractorConfiguration extractorConfig) {
        if (argParser.hasParameter("source")) {
            String sourceLevel = argParser.getParameter("source");
            if (sourceLevel.equals("1.3")) {
                extractorConfig.setJavaSourceLevel(ExtractorConfiguration.JavaCodeSourceLevel.JAVA_1_3);
            } else if (sourceLevel.equals("1.4")) {
                extractorConfig.setJavaSourceLevel(ExtractorConfiguration.JavaCodeSourceLevel.JAVA_1_4);
            } else if (sourceLevel.equals("5.0")) {
                extractorConfig.setJavaSourceLevel(ExtractorConfiguration.JavaCodeSourceLevel.JAVA_5_0);
            } else {
                extractorConfig.setJavaSourceLevel(ExtractorConfiguration.JavaCodeSourceLevel.JAVA_1_4);
            }
        } else {
            extractorConfig.setJavaSourceLevel(ExtractorConfiguration.JavaCodeSourceLevel.JAVA_1_4);
        }
    }

    private void extractCPPSpecificParameters(ArgParser argParser, ExtractorConfiguration extractorConfig) {
        this.setupCDTVersion(argParser, extractorConfig);
        this.setupIncludesAndDefines(argParser, extractorConfig);
        extractorConfig.setExtractOnlyCPPFiles(argParser.hasParameter("cpponly"));
        extractorConfig.setCreateFakesForProblemBindings(argParser.hasParameter("fakesForProblemBindings"));
        if (argParser.hasParameter("preomit")) {
            extractorConfig.setOmitExternC(true);
        } else {
            extractorConfig.setOmitExternC(false);
        }
    }

    private void setupCDTVersion(ArgParser argParser, ExtractorConfiguration extractorConfig) {
        if (argParser.hasParameter("ver")) {
            if (argParser.getParameter("ver").equals("3")) {
                extractorConfig.setCdtVersion(ExtractorConfiguration.CDTVersion.CDT_3);
            } else {
                extractorConfig.setCdtVersion(ExtractorConfiguration.CDTVersion.CDT_6);
            }
        }
    }

    private void setupIncludesAndDefines(ArgParser argParser, ExtractorConfiguration extractorConfig) {
        if (argParser.hasParameter("include")) {
            extractorConfig.setIncludeDirectoriesConfigFile(argParser.getParameter("include"));
        }
        if (argParser.hasParameter("def")) {
            extractorConfig.setPreprocessorDefinitionsConfigFile(argParser.getParameter("def"));
        }
    }

    private void extractDelphiSpecificParameters(ArgParser argParser, ExtractorConfiguration extractorConfig) {
    }

    public ArgParserBuilder getArgParserBuilder() {
        return this.argParserBuilder;
    }
}

