/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.commandline;

import de.fzi.sissy.commandline.Option;
import de.fzi.sissy.commandline.Parameter;
import de.fzi.sissy.utils.Debug;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;

public class ArgParser {
    public static final int HELP_WIDTH = 17;
    public static final int HELP_WIDTH_EXT = 4;
    public static final int DEFAULT_LENGTH = -3;
    private static final char PARAM_SWITCH = '-';
    private String title;
    private String usage;
    private String[] args;
    private ArrayList<Option> optionList = new ArrayList();
    private ArrayList<Parameter> parameterList = new ArrayList();
    private ArrayList<String> targetList = new ArrayList();

    public ArgParser(String title, String usage) {
        this.title = title;
        this.usage = usage;
    }

    public void parse(String[] arg) {
        this.args = arg;
        this.parameterList = new ArrayList();
        this.targetList = new ArrayList();
        int i = 0;
        while (i < arg.length) {
            String str = arg[i];
            System.out.println("process: " + str);
            if (str.charAt(0) == '-') {
                String optname = str.substring(1);
                i = this.findAndAddOption(arg, i, optname);
            } else {
                this.targetList.add(str);
            }
            ++i;
        }
    }

    private int findAndAddOption(String[] arg, int i, String optname) {
        ListIterator<Option> it = this.optionList.listIterator();
        while (it.hasNext()) {
            Option opt = it.next();
            if (!opt.getName().equals(optname)) continue;
            i = this.addOptionParameter(arg, i, optname, opt);
        }
        return i;
    }

    private int addOptionParameter(String[] arg, int i, String optname, Option opt) {
        if (opt.getArguments() != null && i < arg.length - 1) {
            this.parameterList.add(new Parameter(optname, arg[++i]));
            Debug.info((String)("Parameter: " + optname + "=" + arg[i]));
        } else {
            this.parameterList.add(new Parameter(optname, null));
        }
        return i;
    }

    public void reparse() {
        this.parse(this.args);
    }

    public void addOption(String name, String arguments, String help) {
        this.optionList.add(new Option(name, arguments, help));
    }

    public boolean hasParameter(String name) {
        ListIterator<Parameter> it = this.parameterList.listIterator();
        while (it.hasNext()) {
            Parameter param = it.next();
            if (!param.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getParameter(String name) {
        ListIterator<Parameter> it = this.parameterList.listIterator();
        while (it.hasNext()) {
            Parameter param = it.next();
            if (!param.getName().equals(name)) continue;
            return param.getValue();
        }
        return null;
    }

    public void printHelp() {
        Debug.info((String)("Usage: " + this.usage));
        Debug.info((String)"Parameters: ");
        ListIterator<Option> it = this.optionList.listIterator();
        while (it.hasNext()) {
            Option opt = it.next();
            if (opt.getArguments() != null) {
                Debug.info((String)("\t-" + opt.getName() + " <" + opt.getArguments() + ">" + opt.getHelpText()));
                continue;
            }
            Debug.info((String)("\t-" + opt.getName() + opt.getHelpText()));
        }
    }

    private static boolean isFileWritable(String filename) {
        try {
            FileWriter file = new FileWriter(filename);
            file.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static boolean isFileReadable(String filename) {
        try {
            File file = new File(filename);
            return file.canRead();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    protected ArrayList<Option> getOptionList() {
        return this.optionList;
    }

    protected ArrayList<Parameter> getParameterList() {
        return this.parameterList;
    }

    protected ArrayList<String> getTargetList() {
        return this.targetList;
    }

    protected void setUsage(String usage) {
        this.usage = usage;
    }

    @Deprecated
    public String[] getCommandLine() {
        return this.args;
    }
}

