/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.gast.statements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LoopStatementKind implements Enumerator
{
    FOREACH(0, "FOREACH", "FOREACH"),
    WHILE(1, "WHILE", "WHILE"),
    DOWHILE(2, "DOWHILE", "DOWHILE"),
    FOR(3, "FOR", "FOR");

    public static final int FOREACH_VALUE = 0;
    public static final int WHILE_VALUE = 1;
    public static final int DOWHILE_VALUE = 2;
    public static final int FOR_VALUE = 3;
    private static final LoopStatementKind[] VALUES_ARRAY;
    public static final List<LoopStatementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LoopStatementKind[]{FOREACH, WHILE, DOWHILE, FOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LoopStatementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoopStatementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoopStatementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoopStatementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoopStatementKind get(int value) {
        switch (value) {
            case 0: {
                return FOREACH;
            }
            case 1: {
                return WHILE;
            }
            case 2: {
                return DOWHILE;
            }
            case 3: {
                return FOR;
            }
        }
        return null;
    }

    private LoopStatementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

