/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.gast.statements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JumpStatementKind implements Enumerator
{
    JUMP(74, "JUMP", "JUMP"),
    RETURN(73, "RETURN", "RETURN"),
    THROW(72, "THROW", "THROW");

    public static final int JUMP_VALUE = 74;
    public static final int RETURN_VALUE = 73;
    public static final int THROW_VALUE = 72;
    private static final JumpStatementKind[] VALUES_ARRAY;
    public static final List<JumpStatementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JumpStatementKind[]{JUMP, RETURN, THROW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JumpStatementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JumpStatementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JumpStatementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JumpStatementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JumpStatementKind get(int value) {
        switch (value) {
            case 74: {
                return JUMP;
            }
            case 73: {
                return RETURN;
            }
            case 72: {
                return THROW;
            }
        }
        return null;
    }

    private JumpStatementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

