/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.gast.helpers;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.Package;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.core.impl.FileImpl;
import de.fzi.gast.functions.Constructor;
import de.fzi.gast.functions.Destructor;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.functions.Method;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DerivationHelper {
    public static ModelElement calculateNearestParentOfType(ModelElement element, Class<?> aclass) {
        return DerivationHelper.calculateNearestParentOfType(element, aclass, null);
    }

    public static ModelElement calculateNearestParentOfType(ModelElement element, Class<?> aclass, Class<?> breakType) {
        ModelElement returnModelElement;
        if (element.eContainer() != null && element.eContainer() instanceof ModelElement) {
            ModelElement parent = (ModelElement)element.eContainer();
            while (parent != null && !aclass.isInstance(parent)) {
                parent = breakType != null && breakType.isInstance(parent) ? null : (ModelElement)parent.eContainer();
            }
            returnModelElement = parent;
        } else {
            returnModelElement = null;
        }
        return returnModelElement;
    }

    public static EList selectElementsWithFilePosition(EList<?> elements, FileImpl fileImpl) {
        BasicInternalEList result = new BasicInternalEList(SourceEntity.class);
        if (fileImpl == null) {
            return result;
        }
        for (Object elem : elements) {
            if (!(elem instanceof SourceEntity) || ((SourceEntity)elem).getPosition() == null || ((SourceEntity)elem).getPosition().getSourceFile() != fileImpl) continue;
            result.add(elem);
        }
        return result;
    }

    public static EList<Access> selectAccessesInSubtree(EObject modelElement) {
        BasicInternalEList result = new BasicInternalEList(Access.class);
        TreeIterator itr = modelElement.eAllContents();
        while (itr.hasNext()) {
            Object element = itr.next();
            if (!(element instanceof Access) || element == null) continue;
            result.add((Object)((Access)element));
        }
        return result;
    }

    public static EList<Access> getAllAccesses(ModelElement modelElement) {
        BasicInternalEList result = new BasicInternalEList(Access.class);
        TreeIterator iter = EcoreUtil.getAllContents((EObject)modelElement, (boolean)true);
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject == null || !(eObject instanceof Access)) continue;
            result.add((Object)((Access)eObject));
        }
        return result;
    }

    public static int getLinesOfCode(Root root) {
        int LOC = 0;
        for (GASTClass gclass : DerivationHelper.getAllClasses(root, 0)) {
            LOC += DerivationHelper.getLinesOfCode(gclass);
        }
        return LOC;
    }

    public static int getLinesOfCode(Package pack) {
        int LOC = 0;
        for (GASTClass gastClass : DerivationHelper.getAllClasses(pack, 0)) {
            LOC += DerivationHelper.getLinesOfCode(gastClass);
        }
        EList<GlobalFunction> globalFunctions = pack.getGlobalFunctions();
        for (GlobalFunction globalFunction : globalFunctions) {
            LOC += globalFunction.getPosition().getEndLine() - globalFunction.getPosition().getStartLine() + 1;
        }
        return LOC;
    }

    public static int getLinesOfCode(GASTClass gastClass) {
        int LOC = 0;
        for (Method method : gastClass.getMethods()) {
            LOC += method.getPosition().getEndLine() - method.getPosition().getStartLine() + 1;
        }
        for (Constructor cons : gastClass.getConstructors()) {
            LOC += cons.getPosition().getEndLine() - cons.getPosition().getStartLine() + 1;
        }
        for (Destructor destruc : gastClass.getDestructors()) {
            LOC += destruc.getPosition().getEndLine() - destruc.getPosition().getStartLine() + 1;
        }
        return LOC;
    }

    public static EList<GASTClass> getAllClasses(EObject place, int type) {
        EObjectAndTypeTuple tuple = new EObjectAndTypeTuple();
        tuple.eObject = place;
        tuple.type = type;
        BasicInternalEList result = new BasicInternalEList(GASTClass.class);
        TreeIterator iter = EcoreUtil.getAllContents((EObject)place, (boolean)true);
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof GASTClass) || eObject == null) continue;
            if (type == 42 && ((GASTClass)eObject).isInner()) {
                result.add((Object)((GASTClass)eObject));
            }
            if (type == 29 && ((GASTClass)eObject).isLocal()) {
                result.add((Object)((GASTClass)eObject));
            }
            if (!(type != 0 || ((GASTClass)eObject).isLocal() || ((GASTClass)eObject).isInner() || ((GASTClass)eObject).isInterface())) {
                result.add((Object)((GASTClass)eObject));
            }
            if (type != 31 || !((GASTClass)eObject).isInterface()) continue;
            result.add((Object)((GASTClass)eObject));
        }
        return result;
    }

    public static EList<GASTType> getAllTypes(EObject start) {
        BasicInternalEList result = new BasicInternalEList(GASTType.class);
        TreeIterator iter = EcoreUtil.getAllContents((EObject)start, (boolean)true);
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof GASTType) || eObject == null) continue;
            result.add((Object)((GASTType)eObject));
        }
        return result;
    }

    public static boolean isInner(GASTClass gastclass) {
        return gastclass.eContainer() instanceof GASTClass;
    }

    public static boolean isLocal(GASTClass gastclass) {
        return gastclass.eContainer() instanceof Function;
    }

    public static EList<ModelElement> getAllModelElements(Root root) {
        BasicInternalEList result = new BasicInternalEList(ModelElement.class);
        TreeIterator iter = EcoreUtil.getAllContents((EObject)root, (boolean)true);
        while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            if (object == null || !(object instanceof ModelElement)) continue;
            result.add((Object)((ModelElement)object));
        }
        return result;
    }

    public static EList<GASTClass> getAllAccessedClasses(GASTClass gastclass) {
        BasicInternalEList result = new BasicInternalEList(GASTClass.class);
        for (Access access : gastclass.getAllAccesses()) {
            GASTClass tempClass = access.getAccessedClass();
            if (result.contains((Object)tempClass) || tempClass == null) continue;
            result.add((Object)tempClass);
        }
        return result;
    }

    public static EList<Package> getAllAccessedPackages(Package pack) {
        BasicInternalEList result = new BasicInternalEList(Package.class);
        for (Access access : pack.getAllAccesses()) {
            Package tempPack;
            GASTClass gastclass = access.getAccessedClass();
            if (gastclass == null || (tempPack = access.getAccessedClass().getSurroundingPackage()) == null || result.contains((Object)tempPack)) continue;
            result.add((Object)tempPack);
        }
        return result;
    }

    public static EList<Statement> getAllStatements(Function function) {
        BasicInternalEList result = new BasicInternalEList(Statement.class);
        TreeIterator iter = EcoreUtil.getAllContents((EObject)function, (boolean)true);
        while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            if (!(object instanceof Statement) || object == null) continue;
            result.add((Object)((Statement)object));
        }
        return result;
    }

    public static int getLinesOfComments(Package pack) {
        int LOComments = 0;
        for (GASTClass gastclass : pack.getAllNormalClasses()) {
            LOComments += DerivationHelper.getLinesOfComments(gastclass);
        }
        for (GlobalFunction gfunc : pack.getGlobalFunctions()) {
            LOComments += gfunc.getLinesOfComments();
        }
        return LOComments;
    }

    public static int getLinesOfComments(Root root) {
        int LOComments = 0;
        for (Package pack : root.getPackages()) {
            LOComments += DerivationHelper.getLinesOfComments(pack);
        }
        return LOComments;
    }

    public static int getLinesOfComments(GASTClass gastClass) {
        int LOComments = 0;
        for (Method method : gastClass.getMethods()) {
            LOComments += method.getLinesOfComments();
        }
        for (Constructor cons : gastClass.getConstructors()) {
            LOComments += cons.getLinesOfComments();
        }
        for (Destructor destruc : gastClass.getDestructors()) {
            LOComments += destruc.getLinesOfComments();
        }
        return LOComments;
    }

    public static GASTClass getClassByQualifiedName(Root root, String name) {
        TreeIterator iter = EcoreUtil.getAllContents((EObject)root, (boolean)true);
        while (iter.hasNext()) {
            EObject gclass = (EObject)iter.next();
            if (!(gclass instanceof GASTClass) || gclass == null || !((Package)gclass).getQualifiedName().equals(name)) continue;
            return (GASTClass)gclass;
        }
        return null;
    }

    public static Package getPackageByQualifiedName(Root root, String qualifiedName) {
        TreeIterator iter = EcoreUtil.getAllContents((EObject)root, (boolean)true);
        while (iter.hasNext()) {
            EObject pack = (EObject)iter.next();
            if (!(pack instanceof Package) || pack == null || !((Package)pack).getQualifiedName().equals(qualifiedName)) continue;
            return (Package)pack;
        }
        return null;
    }

    public static Package getPackageByName(Root root, String name) {
        TreeIterator iter = EcoreUtil.getAllContents((EObject)root, (boolean)true);
        while (iter.hasNext()) {
            EObject pack = (EObject)iter.next();
            if (!(pack instanceof Package) || pack == null || !((Package)pack).getSimpleName().equals(name)) continue;
            return (Package)pack;
        }
        return null;
    }

    public static Statement basicGetSurroundingStatement(Statement statement) {
        if (statement.eContainer() instanceof Statement) {
            return (Statement)statement.eContainer();
        }
        return null;
    }

    public static EList<GASTClass> getImplementedInterfacesOfGASTClass(GASTClass gastclass) {
        if (gastclass != null) {
            BasicEList implementedInterfaces = new BasicEList();
            BasicEList superTypes = gastclass.getSuperTypes();
            BasicEList nextSuperTypes = new BasicEList();
            do {
                nextSuperTypes = new BasicEList();
                for (GASTClass superType : superTypes) {
                    if (superType.isInterface()) {
                        implementedInterfaces.add((Object)superType);
                        continue;
                    }
                    EList<GASTClass> nextSuperTypeList = superType.getSuperTypes();
                    for (GASTClass nextSuperType : nextSuperTypeList) {
                        if (nextSuperTypes.contains((Object)nextSuperType)) continue;
                        nextSuperTypes.add((Object)nextSuperType);
                    }
                }
                superTypes = nextSuperTypes;
            } while (!nextSuperTypes.isEmpty());
            return implementedInterfaces;
        }
        return null;
    }

    public static EList<GASTClass> getInheritedAbstractClassesOfGASTClass(GASTClass gastclass) {
        return null;
    }

    private static class EObjectAndTypeTuple {
        public EObject eObject;
        public int type;

        private EObjectAndTypeTuple() {
        }

        public int hashCode() {
            return this.eObject.hashCode() + this.type;
        }
    }
}

