/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.gast.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GlobalFunctionKind implements Enumerator
{
    NORMAL(50, "NORMAL", "NORMAL"),
    UNITINITIALIZER(58, "UNITINITIALIZER", "UNITINITIALIZER"),
    UNITFINALIZER(59, "UNITFINALIZER", "UNITFINALIZER");

    public static final int NORMAL_VALUE = 50;
    public static final int UNITINITIALIZER_VALUE = 58;
    public static final int UNITFINALIZER_VALUE = 59;
    private static final GlobalFunctionKind[] VALUES_ARRAY;
    public static final List<GlobalFunctionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GlobalFunctionKind[]{NORMAL, UNITINITIALIZER, UNITFINALIZER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GlobalFunctionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GlobalFunctionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GlobalFunctionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GlobalFunctionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GlobalFunctionKind get(int value) {
        switch (value) {
            case 50: {
                return NORMAL;
            }
            case 58: {
                return UNITINITIALIZER;
            }
            case 59: {
                return UNITFINALIZER;
            }
        }
        return null;
    }

    private GlobalFunctionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

