/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.gast.core.impl;

import de.fzi.gast.core.Directory;
import de.fzi.gast.core.File;
import de.fzi.gast.core.Package;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.core.impl.ModelElementImpl;
import de.fzi.gast.functions.GlobalFunction;
import de.fzi.gast.helpers.DerivationHelper;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.variables.GlobalVariable;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FileImpl
extends ModelElementImpl
implements File {
    protected static final boolean SOURCE_FILE_EDEFAULT = false;
    protected boolean sourceFile = false;
    protected static final boolean ASSEMBLY_FILE_EDEFAULT = false;
    protected EList<GASTType> importedTypes;
    protected static final int LINES_OF_CODE_EDEFAULT = 0;
    protected int linesOfCode = 0;
    protected static final String PATH_NAME_EDEFAULT = null;
    protected String pathName = PATH_NAME_EDEFAULT;
    protected EList<GlobalFunction> importedGlobalFunctions;
    protected EList<GlobalVariable> importedGlobalVariables;
    protected EList<Package> importedPackages;
    protected EList<File> includedFiles;

    protected FileImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return corePackage.Literals.FILE;
    }

    @Override
    public Directory getDirectory() {
        if (this.eContainerFeatureID() != 4) {
            return null;
        }
        return (Directory)this.eContainer();
    }

    public NotificationChain basicSetDirectory(Directory newDirectory, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newDirectory, 4, msgs);
        return msgs;
    }

    @Override
    public void setDirectory(Directory newDirectory) {
        if (newDirectory != this.eInternalContainer() || this.eContainerFeatureID() != 4 && newDirectory != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newDirectory)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newDirectory != null) {
                msgs = ((InternalEObject)newDirectory).eInverseAdd((InternalEObject)this, 8, Directory.class, msgs);
            }
            if ((msgs = this.basicSetDirectory(newDirectory, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newDirectory, (Object)newDirectory));
        }
    }

    @Override
    public Root getRoot() {
        Root root = this.basicGetRoot();
        return root != null && root.eIsProxy() ? (Root)this.eResolveProxy((InternalEObject)root) : root;
    }

    public Root basicGetRoot() {
        return (Root)DerivationHelper.calculateNearestParentOfType(this, Root.class);
    }

    public void setRoot(Root newRoot) {
    }

    @Override
    public EList<GASTType> getImportedTypes() {
        if (this.importedTypes == null) {
            this.importedTypes = new EObjectResolvingEList(GASTType.class, (InternalEObject)this, 8);
        }
        return this.importedTypes;
    }

    @Override
    public EList<GASTType> getTypes() {
        Root root = this.getRoot();
        if (root != null) {
            return DerivationHelper.selectElementsWithFilePosition(DerivationHelper.getAllTypes(this.getRoot()), this);
        }
        return new BasicInternalEList(GASTType.class);
    }

    @Override
    public EList<GlobalVariable> getGlobalVariables() {
        return DerivationHelper.selectElementsWithFilePosition(this.getRoot().getGlobalVariables(), this);
    }

    @Override
    public EList<GlobalFunction> getGlobalFunctions() {
        return DerivationHelper.selectElementsWithFilePosition(this.getRoot().getGlobalFunctions(), this);
    }

    @Override
    public boolean isSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(boolean newSourceFile) {
        boolean oldSourceFile = this.sourceFile;
        this.sourceFile = newSourceFile;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldSourceFile, this.sourceFile));
        }
    }

    @Override
    public boolean isAssemblyFile() {
        return !this.isSourceFile();
    }

    public boolean isSetAssemblyFile() {
        return true;
    }

    @Override
    public int getLinesOfCode() {
        return this.linesOfCode;
    }

    @Override
    public void setLinesOfCode(int newLinesOfCode) {
        int oldLinesOfCode = this.linesOfCode;
        this.linesOfCode = newLinesOfCode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldLinesOfCode, this.linesOfCode));
        }
    }

    @Override
    public String getPathName() {
        return this.pathName;
    }

    @Override
    public void setPathName(String newPathName) {
        String oldPathName = this.pathName;
        this.pathName = newPathName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldPathName, (Object)this.pathName));
        }
    }

    @Override
    public EList<GlobalFunction> getImportedGlobalFunctions() {
        if (this.importedGlobalFunctions == null) {
            this.importedGlobalFunctions = new EObjectResolvingEList(GlobalFunction.class, (InternalEObject)this, 14);
        }
        return this.importedGlobalFunctions;
    }

    @Override
    public EList<GlobalVariable> getImportedGlobalVariables() {
        if (this.importedGlobalVariables == null) {
            this.importedGlobalVariables = new EObjectResolvingEList(GlobalVariable.class, (InternalEObject)this, 15);
        }
        return this.importedGlobalVariables;
    }

    @Override
    public EList<Package> getImportedPackages() {
        if (this.importedPackages == null) {
            this.importedPackages = new EObjectResolvingEList(Package.class, (InternalEObject)this, 16);
        }
        return this.importedPackages;
    }

    @Override
    public EList<File> getIncludedFiles() {
        if (this.includedFiles == null) {
            this.includedFiles = new EObjectResolvingEList(File.class, (InternalEObject)this, 17);
        }
        return this.includedFiles;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetDirectory((Directory)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return this.basicSetDirectory(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 4: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 8, Directory.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getDirectory();
            }
            case 5: {
                if (resolve) {
                    return this.getRoot();
                }
                return this.basicGetRoot();
            }
            case 6: {
                return this.isSourceFile();
            }
            case 7: {
                return this.isAssemblyFile();
            }
            case 8: {
                return this.getImportedTypes();
            }
            case 9: {
                return this.getTypes();
            }
            case 10: {
                return this.getGlobalVariables();
            }
            case 11: {
                return this.getGlobalFunctions();
            }
            case 12: {
                return this.getLinesOfCode();
            }
            case 13: {
                return this.getPathName();
            }
            case 14: {
                return this.getImportedGlobalFunctions();
            }
            case 15: {
                return this.getImportedGlobalVariables();
            }
            case 16: {
                return this.getImportedPackages();
            }
            case 17: {
                return this.getIncludedFiles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setDirectory((Directory)newValue);
                return;
            }
            case 6: {
                this.setSourceFile((Boolean)newValue);
                return;
            }
            case 8: {
                this.getImportedTypes().clear();
                this.getImportedTypes().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setLinesOfCode((Integer)newValue);
                return;
            }
            case 13: {
                this.setPathName((String)newValue);
                return;
            }
            case 14: {
                this.getImportedGlobalFunctions().clear();
                this.getImportedGlobalFunctions().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getImportedGlobalVariables().clear();
                this.getImportedGlobalVariables().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.getImportedPackages().clear();
                this.getImportedPackages().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getIncludedFiles().clear();
                this.getIncludedFiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setDirectory(null);
                return;
            }
            case 6: {
                this.setSourceFile(false);
                return;
            }
            case 8: {
                this.getImportedTypes().clear();
                return;
            }
            case 12: {
                this.setLinesOfCode(0);
                return;
            }
            case 13: {
                this.setPathName(PATH_NAME_EDEFAULT);
                return;
            }
            case 14: {
                this.getImportedGlobalFunctions().clear();
                return;
            }
            case 15: {
                this.getImportedGlobalVariables().clear();
                return;
            }
            case 16: {
                this.getImportedPackages().clear();
                return;
            }
            case 17: {
                this.getIncludedFiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return this.getDirectory() != null;
            }
            case 5: {
                return this.basicGetRoot() != null;
            }
            case 6: {
                return this.sourceFile;
            }
            case 7: {
                return this.isAssemblyFile();
            }
            case 8: {
                return this.importedTypes != null && !this.importedTypes.isEmpty();
            }
            case 9: {
                return !this.getTypes().isEmpty();
            }
            case 10: {
                return !this.getGlobalVariables().isEmpty();
            }
            case 11: {
                return !this.getGlobalFunctions().isEmpty();
            }
            case 12: {
                return this.linesOfCode != 0;
            }
            case 13: {
                return PATH_NAME_EDEFAULT == null ? this.pathName != null : !PATH_NAME_EDEFAULT.equals(this.pathName);
            }
            case 14: {
                return this.importedGlobalFunctions != null && !this.importedGlobalFunctions.isEmpty();
            }
            case 15: {
                return this.importedGlobalVariables != null && !this.importedGlobalVariables.isEmpty();
            }
            case 16: {
                return this.importedPackages != null && !this.importedPackages.isEmpty();
            }
            case 17: {
                return this.includedFiles != null && !this.includedFiles.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sourceFile: ");
        result.append(this.sourceFile);
        result.append(", linesOfCode: ");
        result.append(this.linesOfCode);
        result.append(", pathName: ");
        result.append(this.pathName);
        result.append(')');
        return result.toString();
    }
}

