/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.gast.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Status implements Enumerator
{
    NORMAL(161, "NORMAL", "NORMAL"),
    LIBRARY(162, "LIBRARY", "LIBRARY"),
    IMPLICIT(163, "IMPLICIT", "IMPLICIT"),
    FAILEDDEP(164, "FAILEDDEP", "FAILEDDEP");

    public static final int NORMAL_VALUE = 161;
    public static final int LIBRARY_VALUE = 162;
    public static final int IMPLICIT_VALUE = 163;
    public static final int FAILEDDEP_VALUE = 164;
    private static final Status[] VALUES_ARRAY;
    public static final List<Status> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Status[]{NORMAL, LIBRARY, IMPLICIT, FAILEDDEP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Status get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Status result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Status getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Status result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Status get(int value) {
        switch (value) {
            case 161: {
                return NORMAL;
            }
            case 162: {
                return LIBRARY;
            }
            case 163: {
                return IMPLICIT;
            }
            case 164: {
                return FAILEDDEP;
            }
        }
        return null;
    }

    private Status(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

