/*
 * Decompiled with CFR 0.152.
 */
package org.somox.configuration;

import de.uka.ipd.sdq.workflow.AbstractComposedJobConfiguration;
import de.uka.ipd.sdq.workflow.IJobConfiguration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.somox.configuration.ClusteringConfiguration;
import org.somox.configuration.FileLocationConfiguration;
import org.somox.filter.BlacklistFilter;

public class SoMoXConfiguration
extends AbstractComposedJobConfiguration
implements IJobConfiguration {
    public static final String SOMOX_WILDCARD_DELIMITER = "\u00a7";
    private double weightPackageMapping;
    private double weightDirectoryMapping;
    private double weightDMS;
    private double weightLowCoupling;
    private double weightHighCoupling;
    private double weightLowNameResemblance;
    private double weightMidNameResemblance;
    private double weightHighNameResemblance;
    private double weightHighestNameResemblance;
    private double weightInterfaceViolationRelevant;
    private double weightInterfaceViolationIrrelevant;
    private double weightHighSLAQ;
    private double weightLowSLAQ;
    private String rawBlacklist;
    private String excludedPrefixesForNameResemblance;
    private String excludedSuffixesForNameResemblance;
    private BlacklistFilter blacklistFilter = null;
    private boolean reverseEngineerInterfacesNotAssignedToComponent;
    private final ClusteringConfiguration clusteringConfig = new ClusteringConfiguration();
    private final FileLocationConfiguration locations = new FileLocationConfiguration();

    public String getErrorMessage() {
        return "An error in SoMoX occured";
    }

    private Set<String> getBlacklist() {
        String wildcardString = this.rawBlacklist;
        StringTokenizer tokenizer = new StringTokenizer(wildcardString, SOMOX_WILDCARD_DELIMITER);
        HashSet<String> blacklist = new HashSet<String>();
        while (tokenizer.hasMoreElements()) {
            blacklist.add(tokenizer.nextToken());
        }
        return blacklist;
    }

    public void setWildcardKey(String wildcardKey, String additionalWildcards) {
        this.rawBlacklist = wildcardKey;
        Set<String> wildCardList = this.getBlacklist();
        if (additionalWildcards != null && additionalWildcards.length() > 0) {
            wildCardList.add(additionalWildcards);
        }
        this.blacklistFilter = new BlacklistFilter(wildCardList);
    }

    public BlacklistFilter getBlacklistFilter() {
        if (this.blacklistFilter == null) {
            throw new IllegalArgumentException("Must set blacklist pattern first.");
        }
        return this.blacklistFilter;
    }

    public String getExcludedPrefixesForNameResemblance() {
        return this.excludedPrefixesForNameResemblance;
    }

    public void setExcludedPrefixesForNameResemblance(String excludedPrefixesForNameResemblance) {
        this.excludedPrefixesForNameResemblance = excludedPrefixesForNameResemblance;
    }

    public String getExcludedSuffixesForNameResemblance() {
        return this.excludedSuffixesForNameResemblance;
    }

    public void setExcludedSuffixesForNameResemblance(String excludedSuffixesForNameResemblance) {
        this.excludedSuffixesForNameResemblance = excludedSuffixesForNameResemblance;
    }

    public double getWeightPackageMapping() {
        return this.weightPackageMapping;
    }

    public void setWeightPackageMapping(double weightPackageMapping) {
        this.weightPackageMapping = weightPackageMapping;
    }

    public double getWeightDirectoryMapping() {
        return this.weightDirectoryMapping;
    }

    public void setWeightDirectoryMapping(double weightDirectoryMapping) {
        this.weightDirectoryMapping = weightDirectoryMapping;
    }

    public double getWeightDMS() {
        return this.weightDMS;
    }

    public void setWeightDMS(double weightDMS) {
        this.weightDMS = weightDMS;
    }

    public double getWeightLowCoupling() {
        return this.weightLowCoupling;
    }

    public void setWeightLowCoupling(double weightLowCoupling) {
        this.weightLowCoupling = weightLowCoupling;
    }

    public double getWeightHighCoupling() {
        return this.weightHighCoupling;
    }

    public void setWeightHighCoupling(double weightHighCoupling) {
        this.weightHighCoupling = weightHighCoupling;
    }

    public double getWeightLowNameResemblance() {
        return this.weightLowNameResemblance;
    }

    public void setWeightLowNameResemblance(double weightLowNameResemblance) {
        this.weightLowNameResemblance = weightLowNameResemblance;
    }

    public double getWeightMidNameResemblance() {
        return this.weightMidNameResemblance;
    }

    public void setWeightMidNameResemblance(double weightMidNameResemblance) {
        this.weightMidNameResemblance = weightMidNameResemblance;
    }

    public double getWeightHighNameResemblance() {
        return this.weightHighNameResemblance;
    }

    public void setWeightHighNameResemblance(double weightHighNameResemblance) {
        this.weightHighNameResemblance = weightHighNameResemblance;
    }

    public double getWeightHighestNameResemblance() {
        return this.weightHighestNameResemblance;
    }

    public void setWeightHighestNameResemblance(double weightHighestNameResemblance) {
        this.weightHighestNameResemblance = weightHighestNameResemblance;
    }

    public double getWeightInterfaceViolationRelevant() {
        return this.weightInterfaceViolationRelevant;
    }

    public void setWeightInterfaceViolationRelevant(double weightInterfaceViolationRelevant) {
        this.weightInterfaceViolationRelevant = weightInterfaceViolationRelevant;
    }

    public double getWeightInterfaceViolationIrrelevant() {
        return this.weightInterfaceViolationIrrelevant;
    }

    public void setWeightInterfaceViolationIrrelevant(double weightInterfaceViolationIrrelevant) {
        this.weightInterfaceViolationIrrelevant = weightInterfaceViolationIrrelevant;
    }

    public double getWeightHighSLAQ() {
        return this.weightHighSLAQ;
    }

    public void setWeightHighSLAQ(double weightHighSLAQ) {
        this.weightHighSLAQ = weightHighSLAQ;
    }

    public double getWeightLowSLAQ() {
        return this.weightLowSLAQ;
    }

    public void setWeightLowSLAQ(double weightLowSLAQ) {
        this.weightLowSLAQ = weightLowSLAQ;
    }

    public ClusteringConfiguration getClusteringConfig() {
        return this.clusteringConfig;
    }

    public FileLocationConfiguration getFileLocations() {
        return this.locations;
    }

    public boolean isReverseEngineerInterfacesNotAssignedToComponent() {
        return this.reverseEngineerInterfacesNotAssignedToComponent;
    }

    public void setReverseEngineerInterfacesNotAssignedToComponent(boolean reverseEngineerInterfacesNotAssignedToComponent) {
        this.reverseEngineerInterfacesNotAssignedToComponent = reverseEngineerInterfacesNotAssignedToComponent;
    }
}

