/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.metrics.tabs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.somox.analyzer.simplemodelanalyzer.Activator;
import org.somox.metrics.tabs.MetricTab;

public class WeightsTab
extends MetricTab {
    private static final String CONFIG_SIMPLE_ANALYZER_PROPERTIES_FILE = "/config/SimpleAnalyzer.properties";
    protected Composite control;
    private static Logger logger = Logger.getLogger(WeightsTab.class);
    private ArrayList<Label> keyLabels;
    private ArrayList<Slider> valueSliders;
    private ArrayList<Label> valueLabels;
    private ArrayList<String> weights;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public boolean canSave() {
        return true;
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 2048);
        this.control.setLayout((Layout)new GridLayout(3, false));
        this.keyLabels = new ArrayList();
        this.valueSliders = new ArrayList();
        this.valueLabels = new ArrayList();
        HashMap<String, String> keyToLabelMap = new HashMap<String, String>();
        this.fillKeyToLabelMap(keyToLabelMap);
        this.weights = new ArrayList();
        this.fillWeightsList(this.weights);
        int weightCounter = 0;
        for (String weightName : this.weights) {
            Label keyLabel = new Label(this.control, 0);
            keyLabel.setText(keyToLabelMap.get(weightName));
            this.keyLabels.add(keyLabel);
            final Label valueLabel = new Label(this.control, 2048);
            GridData gd = new GridData();
            gd.minimumWidth = 100;
            gd.widthHint = 30;
            valueLabel.setAlignment(0x1000000);
            valueLabel.setLayoutData((Object)gd);
            this.valueLabels.add(valueLabel);
            final Slider slider = new Slider(this.control, 256);
            slider.setMinimum(0);
            slider.setMaximum(110);
            slider.setIncrement(1);
            slider.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    valueLabel.setText(String.valueOf(slider.getSelection()));
                    WeightsTab.this.setDirty(true);
                    WeightsTab.this.updateLaunchConfigurationDialog();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.valueSliders.add(slider);
            ++weightCounter;
        }
    }

    private void fillKeyToLabelMap(HashMap<String, String> keyToLabelMap) {
        keyToLabelMap.put("org.somox.clusteringThresholdMax.Merge", "Clustering Merge Threshold Max (End Value)");
        keyToLabelMap.put("org.somox.clusteringThresholdMin.Merge", "Clustering Merge Threshold Min (Start Value)");
        keyToLabelMap.put("org.somox.clusteringThresholdDecrement.Merge", "Clustering Merge Threshold Increment");
        keyToLabelMap.put("org.somox.interfaceViolation.weightInterfaceViolationIrrelevant", "Merge: Interface Violation");
        keyToLabelMap.put("org.somox.clusteringThresholdMax.Compose", "Clustering Composition Threshold Max (Start Value)");
        keyToLabelMap.put("org.somox.clusteringThresholdMin.Compose", "Clustering Composition Threshold Min (End Value)");
        keyToLabelMap.put("org.somox.clusteringThresholdDecrement.Compose", "Clustering Composition Threshold Decrement");
        keyToLabelMap.put("org.somox.interfaceViolation.weightInterfaceViolationRelevant", "Composition: Interface Adherence");
        keyToLabelMap.put("org.somox.directoryMapping.weightDirectoryMapping", "Directory Mapping");
        keyToLabelMap.put("org.somox.dms.weightDMS", "DMS (Distance from the Main Sequence)");
        keyToLabelMap.put("org.somox.nameResemblance.weightHighCoupling", "High Coupling");
        keyToLabelMap.put("org.somox.nameResemblance.weightHighNameResemblance", "High Name Resemblance");
        keyToLabelMap.put("org.somox.subsystemComponent.weightHighSLAQ", "High SLAQ (Slice Layer Architecture Quality)");
        keyToLabelMap.put("org.somox.nameResemblance.weightHighestNameResemblance", "Highest Name Resemblance");
        keyToLabelMap.put("org.somox.nameResemblance.weightLowCoupling", "Low Coupling");
        keyToLabelMap.put("org.somox.nameResemblance.weightLowNameResemblance", "Low Name Resemblance");
        keyToLabelMap.put("org.somox.subsystemComponent.weightLowSLAQ", "Low SLAQ");
        keyToLabelMap.put("org.somox.nameResemblance.weightMidNameResemblance", "Mid Name Resemblance");
        keyToLabelMap.put("org.somox.packageMapping.weightPackageMapping", "Package Mapping");
    }

    private void fillWeightsList(ArrayList<String> weights) {
        weights.add("org.somox.packageMapping.weightPackageMapping");
        weights.add("org.somox.directoryMapping.weightDirectoryMapping");
        weights.add("org.somox.dms.weightDMS");
        weights.add("org.somox.nameResemblance.weightLowCoupling");
        weights.add("org.somox.nameResemblance.weightHighCoupling");
        weights.add("org.somox.nameResemblance.weightLowNameResemblance");
        weights.add("org.somox.nameResemblance.weightMidNameResemblance");
        weights.add("org.somox.nameResemblance.weightHighNameResemblance");
        weights.add("org.somox.nameResemblance.weightHighestNameResemblance");
        weights.add("org.somox.subsystemComponent.weightLowSLAQ");
        weights.add("org.somox.subsystemComponent.weightHighSLAQ");
        weights.add("org.somox.interfaceViolation.weightInterfaceViolationRelevant");
        weights.add("org.somox.clusteringThresholdMax.Compose");
        weights.add("org.somox.clusteringThresholdMin.Compose");
        weights.add("org.somox.clusteringThresholdDecrement.Compose");
        weights.add("org.somox.interfaceViolation.weightInterfaceViolationIrrelevant");
        weights.add("org.somox.clusteringThresholdMax.Merge");
        weights.add("org.somox.clusteringThresholdMin.Merge");
        weights.add("org.somox.clusteringThresholdDecrement.Merge");
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.control;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public String getName() {
        return "Weights";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            int i = 0;
            while (i < this.valueSliders.size()) {
                String value = configuration.getAttribute(this.weights.get(i), "");
                this.valueSliders.get(i).setSelection(Integer.valueOf(value).intValue());
                this.valueLabels.get(i).setText(String.valueOf(value));
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    public void launched(ILaunch launch) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int i = 0;
        while (i < this.valueSliders.size()) {
            int value = this.valueSliders.get(i).getSelection();
            configuration.setAttribute(this.weights.get(i), String.valueOf(value));
            ++i;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        WeightsTab.setDefault(configuration);
    }

    public static void setDefault(ILaunchConfigurationWorkingCopy configuration) {
        Properties properties = new Properties();
        try {
            InputStream inStream = Activator.getDefault().getBundle().getEntry(CONFIG_SIMPLE_ANALYZER_PROPERTIES_FILE).openStream();
            properties.load(inStream);
            configuration.setAttribute("org.somox.clusteringThresholdMax.Merge", properties.getProperty("org.somox.clusteringThresholdMax.Merge"));
            configuration.setAttribute("org.somox.clusteringThresholdMin.Merge", properties.getProperty("org.somox.clusteringThresholdMin.Merge"));
            configuration.setAttribute("org.somox.clusteringThresholdDecrement.Merge", properties.getProperty("org.somox.clusteringThresholdDecrement.Merge"));
            configuration.setAttribute("org.somox.clusteringThresholdMax.Compose", properties.getProperty("org.somox.clusteringThresholdMax.Compose"));
            configuration.setAttribute("org.somox.clusteringThresholdMin.Compose", properties.getProperty("org.somox.clusteringThresholdMin.Compose"));
            configuration.setAttribute("org.somox.clusteringThresholdDecrement.Compose", properties.getProperty("org.somox.clusteringThresholdDecrement.Compose"));
            configuration.setAttribute("org.somox.directoryMapping.weightDirectoryMapping", properties.getProperty("org.somox.directoryMapping.weightDirectoryMapping"));
            configuration.setAttribute("org.somox.dms.weightDMS", properties.getProperty("org.somox.dms.weightDMS"));
            configuration.setAttribute("org.somox.nameResemblance.weightHighCoupling", properties.getProperty("org.somox.nameResemblance.weightHighCoupling"));
            configuration.setAttribute("org.somox.nameResemblance.weightHighNameResemblance", properties.getProperty("org.somox.nameResemblance.weightHighNameResemblance"));
            configuration.setAttribute("org.somox.subsystemComponent.weightHighSLAQ", properties.getProperty("org.somox.subsystemComponent.weightHighSLAQ"));
            configuration.setAttribute("org.somox.nameResemblance.weightHighestNameResemblance", properties.getProperty("org.somox.nameResemblance.weightHighestNameResemblance"));
            configuration.setAttribute("org.somox.interfaceViolation.weightInterfaceViolationIrrelevant", properties.getProperty("org.somox.interfaceViolation.weightInterfaceViolationIrrelevant"));
            configuration.setAttribute("org.somox.interfaceViolation.weightInterfaceViolationRelevant", properties.getProperty("org.somox.interfaceViolation.weightInterfaceViolationRelevant"));
            configuration.setAttribute("org.somox.nameResemblance.weightLowCoupling", properties.getProperty("org.somox.nameResemblance.weightLowCoupling"));
            configuration.setAttribute("org.somox.nameResemblance.weightLowNameResemblance", properties.getProperty("org.somox.nameResemblance.weightLowNameResemblance"));
            configuration.setAttribute("org.somox.subsystemComponent.weightLowSLAQ", properties.getProperty("org.somox.subsystemComponent.weightLowSLAQ"));
            configuration.setAttribute("org.somox.nameResemblance.weightMidNameResemblance", properties.getProperty("org.somox.nameResemblance.weightMidNameResemblance"));
            configuration.setAttribute("org.somox.packageMapping.weightPackageMapping", properties.getProperty("org.somox.packageMapping.weightPackageMapping"));
            for (Map.Entry o : configuration.getAttributes().entrySet()) {
                if (o != null) continue;
                logger.error((Object)"At least one metric weight was not defined in the properties file");
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not read property file /config/SimpleAnalyzer.properties with metric defaults", (Throwable)e);
            e.printStackTrace();
        }
        catch (CoreException e) {
            logger.error((Object)"Could not read property file with metric defaults", (Throwable)e);
            e.printStackTrace();
        }
    }
}

