/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.metrics;

import java.util.Map;
import org.apache.log4j.Logger;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.AbstractMetric;
import org.somox.metrics.ICompositionFunction;
import org.somox.metrics.MetricID;
import org.somox.metrics.hierarchy.DirectoryMapping;
import org.somox.metrics.hierarchy.PackageMapping;
import org.somox.metrics.naming.NameResemblance;
import org.somox.metrics.ratio.AdherenceToInterfaceCommunication;
import org.somox.metrics.ratio.Coupling;
import org.somox.metrics.ratio.DMS;
import org.somox.metrics.structure.SliceLayerArchitectureQuality;
import org.somox.metrics.structure.SubsystemComponent;

public class CompositionIndicationFunction
implements ICompositionFunction {
    private SoMoXConfiguration somoxConfig;
    private static Logger logger = Logger.getLogger(CompositionIndicationFunction.class);
    private double packageMappingWeight;
    private double directoryMappingWeight;
    private double DMSWeight;

    public CompositionIndicationFunction(SoMoXConfiguration somoxConfiguration) {
        this.somoxConfig = somoxConfiguration;
        this.getWeightsFromConfiguration();
    }

    public double computeOverallDirectedMetricValue(Map<MetricID, Double> metricValues) {
        if (metricValues == null || metricValues.size() == 0) {
            throw new IllegalArgumentException("Metric not set");
        }
        double nameResemblance = metricValues.get(NameResemblance.METRIC_ID);
        double subsystemComponent = metricValues.get(SubsystemComponent.METRIC_ID);
        double packageMapping = metricValues.get(PackageMapping.METRIC_ID);
        double directoryMapping = metricValues.get(DirectoryMapping.METRIC_ID);
        double dms = metricValues.get(DMS.METRIC_ID);
        double slaq = metricValues.get(SliceLayerArchitectureQuality.METRIC_ID);
        double coupling = metricValues.get(Coupling.METRIC_ID);
        double interfaceAdherence = metricValues.get(AdherenceToInterfaceCommunication.METRIC_ID);
        double nameResemblanceAfterCoupling = this.getNameResemblance(nameResemblance, coupling);
        double interfaceAdherenceWeight = this.getInterfaceAdherenceWeight(coupling, interfaceAdherence);
        double subsystemComponentWeight = this.getSubsystemComponentWeight(slaq);
        double sum = this.getMaxNameResemblanceWeigth() + interfaceAdherenceWeight + subsystemComponentWeight + this.packageMappingWeight + this.DMSWeight + this.directoryMappingWeight;
        if (sum == 0.0) {
            throw new RuntimeException("The weight of all metrics must not be 0!");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Name resemblance = " + nameResemblance + " * " + nameResemblanceAfterCoupling + " = " + nameResemblance * nameResemblanceAfterCoupling));
            logger.trace((Object)("Interface violation = " + interfaceAdherence + " * " + interfaceAdherenceWeight + " = " + interfaceAdherence * interfaceAdherenceWeight));
            logger.trace((Object)("Subsystem component = " + subsystemComponent + " * " + subsystemComponentWeight + " = " + subsystemComponent * subsystemComponentWeight));
            logger.trace((Object)("Package mapping = " + packageMapping + " * " + this.packageMappingWeight + " = " + packageMapping * this.packageMappingWeight));
            logger.trace((Object)("DMS = " + dms + " * " + this.DMSWeight + " = " + dms * this.DMSWeight));
            logger.trace((Object)("Directory mapping = " + directoryMapping + " * " + this.directoryMappingWeight + " = " + directoryMapping * this.directoryMappingWeight));
        }
        double score = nameResemblanceAfterCoupling + interfaceAdherence * interfaceAdherenceWeight + subsystemComponent * subsystemComponentWeight + packageMapping * this.packageMappingWeight - dms * this.DMSWeight + directoryMapping * this.directoryMappingWeight;
        logger.trace((Object)("Overall computed metric: " + (score /= sum)));
        return score;
    }

    private double getMaxNameResemblanceWeigth() {
        double result = Math.max(this.somoxConfig.getWeightLowCoupling(), this.somoxConfig.getWeightHighCoupling());
        result = Math.max(result, this.somoxConfig.getWeightLowNameResemblance());
        result = Math.max(result, this.somoxConfig.getWeightMidNameResemblance());
        result = Math.max(result, this.somoxConfig.getWeightHighNameResemblance());
        result = Math.max(result, this.somoxConfig.getWeightHighestNameResemblance());
        return result;
    }

    private double getNameResemblance(double nameResemblance, double coupling) {
        if (coupling >= 0.0 && coupling < 0.2) {
            return this.somoxConfig.getWeightLowNameResemblance() * nameResemblance;
        }
        if (coupling >= 0.2 && coupling < 0.7) {
            return this.somoxConfig.getWeightMidNameResemblance() * nameResemblance;
        }
        if (coupling >= 0.7 && coupling < 0.9) {
            return this.somoxConfig.getWeightHighNameResemblance() * nameResemblance;
        }
        return this.somoxConfig.getWeightHighestNameResemblance() * nameResemblance;
    }

    private double getInterfaceAdherenceWeight(double coupling, double interfaceAdherence) {
        if (coupling >= 0.5 && interfaceAdherence > 0.0) {
            return this.somoxConfig.getWeightInterfaceViolationRelevant();
        }
        return 0.0;
    }

    private double getSubsystemComponentWeight(double slaq) {
        if (slaq >= 0.5) {
            return this.somoxConfig.getWeightHighSLAQ();
        }
        return this.somoxConfig.getWeightLowSLAQ();
    }

    private void getWeightsFromConfiguration() {
        this.packageMappingWeight = this.somoxConfig.getWeightPackageMapping();
        this.directoryMappingWeight = this.somoxConfig.getWeightDirectoryMapping();
        this.DMSWeight = this.somoxConfig.getWeightDMS();
    }

    protected AbstractMetric getMetric(Map<String, AbstractMetric> allMetrics, String metricId) {
        AbstractMetric result = allMetrics.get(metricId);
        if (result == null) {
            throw new RuntimeException("Configuration error, Metric " + metricId + " needed but not available");
        }
        return result;
    }
}

