/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.somox.analyzer.simplemodelanalyzer.detection.IComponentInterfaceStrategy;

public class ComponentInterfaceStrategy
implements IComponentInterfaceStrategy {
    private SourceCodeDecoratorRepository sourceCodeDecorator;

    public ComponentInterfaceStrategy(SourceCodeDecoratorRepository sourceCodeDecorator) {
        this.sourceCodeDecorator = sourceCodeDecorator;
    }

    @Override
    public boolean isComponentInterface(GASTClass classToCheck) {
        return this.isRegularInterface(classToCheck) || this.isPureVirtualClass(classToCheck) || this.isClassifiedAsInterfaceViaSourceCodeDecorator(classToCheck);
    }

    private boolean isRegularInterface(GASTClass classToCheck) {
        return classToCheck.isInterface();
    }

    private boolean isClassifiedAsInterfaceViaSourceCodeDecorator(GASTClass classToCheck) {
        for (InterfaceSourceCodeLink ifLink : this.sourceCodeDecorator.getInterfaceSourceCodeLink()) {
            if (!ifLink.getGastClass().equals(classToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean isPureVirtualClass(GASTClass classToCheck) {
        if (classToCheck.getMethods().size() == 0) {
            return false;
        }
        for (Method method : classToCheck.getMethods()) {
            if (!method.isVirtual()) {
                return false;
            }
            if (method.getBody() == null) continue;
            return false;
        }
        return true;
    }
}

