/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTStruct;
import org.somox.analyzer.simplemodelanalyzer.detection.IInitializationStrategy;
import org.somox.filter.BaseFilter;
import org.somox.filter.DataObjectFilter;

public abstract class AbstractInitializationStrategy
implements IInitializationStrategy {
    protected static final BaseFilter<GASTClass> primitiveClassesFilter = new BaseFilter<GASTClass>(){

        public boolean passes(GASTClass object) {
            return !object.isPrimitive();
        }
    };
    protected static final BaseFilter<GASTClass> unknownClassTypeFilter = new BaseFilter<GASTClass>(){

        public boolean passes(GASTClass object) {
            return !object.getSimpleName().equals("<unknownClassType>");
        }
    };
    protected static final BaseFilter<GASTClass> improperStructFilter = new BaseFilter<GASTClass>(){

        public boolean passes(GASTClass object) {
            return !(object instanceof GASTStruct) || !this.hasVirtualMethod(object);
        }

        private boolean hasVirtualMethod(GASTClass clazz) {
            boolean hasVirtualMethod = false;
            for (Method method : clazz.getMethods()) {
                if (!method.isVirtual()) continue;
                hasVirtualMethod = true;
                break;
            }
            return hasVirtualMethod;
        }
    };
    protected static final BaseFilter<GASTClass> dataObjectFilter = new DataObjectFilter();
}

