/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder.util;

import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.EndPoint;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SammSystemImplementatingClassesLink;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.somox.analyzer.simplemodelanalyzer.builder.InterfacesBoundInConnectorFilter;
import org.somox.analyzer.simplemodelanalyzer.builder.util.SubComponentInformation;

public class InterfacePortBuilderHelper {
    private static final Logger logger = Logger.getLogger(InterfacePortBuilderHelper.class);
    private static final boolean EXHIBIT_ALL_INNER_PROVIDED_INTERFACES = true;

    public static Iterable<SubComponentInformation> collectInformationOnNonBoundInterfaces(ComponentImplementingClassesLink componentLink, CompositeStructure outerComponentToCheck, boolean isProvided) {
        Iterable<SubComponentInformation> interfaceLinksNotUsedInConnectors;
        Collection<SubComponentInformation> allSubComponentInterfaceLinks = InterfacePortBuilderHelper.collectInterfaceLinksOfSubComponents(componentLink, isProvided);
        Collection<EndPoint> connectorEndpoints = InterfacePortBuilderHelper.collectConnectorEndpoints(outerComponentToCheck);
        if (isProvided) {
            interfaceLinksNotUsedInConnectors = allSubComponentInterfaceLinks;
        } else {
            InterfacesBoundInConnectorFilter filter = new InterfacesBoundInConnectorFilter(connectorEndpoints);
            interfaceLinksNotUsedInConnectors = filter.filter(allSubComponentInterfaceLinks);
        }
        return interfaceLinksNotUsedInConnectors;
    }

    private static Collection<EndPoint> collectConnectorEndpoints(CompositeStructure compositeComponent) {
        ArrayList<EndPoint> connectorEndpoints = new ArrayList<EndPoint>();
        for (Connector currentConnector : compositeComponent.getConnector()) {
            if (currentConnector.getEndpoints().size() > 2) {
                throw new RuntimeException("n to m connectors (n/m > 2) not supported!");
            }
            for (EndPoint currentEndPoint : currentConnector.getEndpoints()) {
                connectorEndpoints.add(currentEndPoint);
            }
        }
        return connectorEndpoints;
    }

    private static Collection<SubComponentInformation> collectInterfaceLinksOfSubComponents(ComponentImplementingClassesLink componentLink, boolean collectProvided) {
        ArrayList<SubComponentInformation> allInterfaceLinks = new ArrayList<SubComponentInformation>();
        for (ComponentImplementingClassesLink currentSubComponentLink : componentLink.getSubComponents()) {
            EList interfaceLinkSubList = collectProvided ? currentSubComponentLink.getProvidedInterfaces() : currentSubComponentLink.getRequiredInterfaces();
            for (InterfaceSourceCodeLink currentInterfaceLinkSub : interfaceLinkSubList) {
                SubcomponentInstance matchingSubComponentInstance = null;
                if (componentLink.getComponent() != null) {
                    matchingSubComponentInstance = InterfacePortBuilderHelper.getSubComponentInstance((CompositeStructure)((CompositeComponent)componentLink.getComponent()), currentSubComponentLink);
                } else if (componentLink instanceof SammSystemImplementatingClassesLink) {
                    matchingSubComponentInstance = InterfacePortBuilderHelper.getSubComponentInstance((CompositeStructure)((SammSystemImplementatingClassesLink)componentLink).getServiceArchitectureModel(), currentSubComponentLink);
                }
                InterfacePort interfacePort = InterfacePortBuilderHelper.getInterfacePort(currentSubComponentLink, currentInterfaceLinkSub, collectProvided);
                allInterfaceLinks.add(new SubComponentInformation(currentInterfaceLinkSub, interfacePort, matchingSubComponentInstance));
            }
        }
        return allInterfaceLinks;
    }

    public static InterfacePort getInterfacePort(ComponentImplementingClassesLink subComponentLink, InterfaceSourceCodeLink interfaceLinkSub, boolean searchProvidedPort) {
        EList interfacePorts = searchProvidedPort ? subComponentLink.getComponent().getProvided() : subComponentLink.getComponent().getRequired();
        for (InterfacePort currentInterfacePort : interfacePorts) {
            if (!interfaceLinkSub.getInterface().equals(currentInterfacePort.getInterfaceType())) continue;
            return currentInterfacePort;
        }
        logger.warn((Object)"should find an interface port");
        return null;
    }

    private static SubcomponentInstance getSubComponentInstance(CompositeStructure outerCompositeComponent, ComponentImplementingClassesLink subComponentLink) {
        for (SubcomponentInstance currentComponentInstance : outerCompositeComponent.getSubcomponents()) {
            if (!currentComponentInstance.getRealizedBy().equals(subComponentLink.getComponent())) continue;
            return currentComponentInstance;
        }
        logger.warn((Object)"no subcomponent instance found");
        return null;
    }
}

