/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import eu.qimpress.samm.deployment.allocation.AllocationFactory;
import eu.qimpress.samm.deployment.allocation.Service;
import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.PortEnabledEntity;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SammSystemImplementatingClassesLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.DummyComponentBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.util.InterfacePortBuilderHelper;
import org.somox.analyzer.simplemodelanalyzer.builder.util.SubComponentInformation;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.resources.defaultmodels.DefaultModelLoader;

public class SammSystemBuilder
extends AbstractBuilder {
    private static Logger logger = Logger.getLogger(SammSystemBuilder.class);
    private DefaultModelLoader defaultModelLoader;
    private ComponentAndTypeNaming namingStrategy;
    private ComponentBuilder componentBuilder;

    public SammSystemBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult, ComponentBuilder componentBuilder) {
        super(gastModel, somoxConfiguration, analysisResult);
        logger.debug((Object)"Initialising SAMM system builder");
        this.componentBuilder = componentBuilder;
        this.namingStrategy = componentBuilder.getComponentAndTypeNamingStrategy();
        this.defaultModelLoader = new DefaultModelLoader();
    }

    public void buildServiceArchitectureModel() {
        this.buildServiceArchitectureModel(this.getNonContainedComponents());
    }

    private List<ComponentImplementingClassesLink> getNonContainedComponents() {
        ArrayList<ComponentImplementingClassesLink> nonContainedComponents = new ArrayList<ComponentImplementingClassesLink>();
        for (ComponentImplementingClassesLink compLinkToCheckWhetherContained : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
            boolean isComponentLinkToCheckContained = false;
            for (ComponentImplementingClassesLink potentialOuterCompLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
                if (!potentialOuterCompLink.getSubComponents().contains((Object)compLinkToCheckWhetherContained)) continue;
                isComponentLinkToCheckContained = true;
                break;
            }
            if (isComponentLinkToCheckContained) continue;
            nonContainedComponents.add(compLinkToCheckWhetherContained);
            logger.debug((Object)("non-contained component: " + compLinkToCheckWhetherContained.getComponent().getName() + " used for the system level"));
        }
        return nonContainedComponents;
    }

    private void buildServiceArchitectureModel(List<ComponentImplementingClassesLink> innerComponents) {
        ServiceArchitectureModel sammSystem = this.analysisResult.getServiceArchitectureModel();
        sammSystem.setName("SoMoX Reverse Engineered System");
        SammSystemImplementatingClassesLink sammLink = SourceCodeDecoratorFactory.eINSTANCE.createSammSystemImplementatingClassesLink();
        sammLink.setServiceArchitectureModel(sammSystem);
        HashSet<SubComponentInformation> subComponentInformationSet = new HashSet<SubComponentInformation>();
        for (ComponentImplementingClassesLink compLink : innerComponents) {
            SubcomponentInstance subComponentInstance = StaticstructureFactory.eINSTANCE.createSubcomponentInstance();
            subComponentInstance.setRealizedBy(compLink.getComponent());
            subComponentInstance.setName(compLink.getComponent().getName());
            sammSystem.getSubcomponents().add((Object)subComponentInstance);
            sammLink.getSubComponents().add((Object)compLink);
            Service service = AllocationFactory.eINSTANCE.createService();
            sammSystem.getService().add((Object)service);
            service.setSubcomponentInstance(subComponentInstance);
            service.setName(compLink.getComponent().getName());
            service.setContainer(this.defaultModelLoader.getDefaultContainer());
            for (InterfaceSourceCodeLink provIfLink : compLink.getProvidedInterfaces()) {
                this.createPortAndDelegationConnector(sammSystem, compLink, subComponentInstance, provIfLink, true);
            }
        }
        this.componentBuilder.getInsideCompositeComponentAssemblyConnectorStrategy().buildAssemblyConnectors((CompositeStructure)sammSystem, innerComponents);
        Iterable<SubComponentInformation> subComponentInformation = InterfacePortBuilderHelper.collectInformationOnNonBoundInterfaces((ComponentImplementingClassesLink)sammLink, (CompositeStructure)sammSystem, false);
        Iterator<SubComponentInformation> iterator = subComponentInformation.iterator();
        while (iterator.hasNext()) {
            subComponentInformationSet.add(iterator.next());
        }
        PrimitiveComponent dummyComponent = DummyComponentBuilder.createDummyComponent(subComponentInformationSet, sammSystem, this.defaultModelLoader.getDefaultContainer());
        this.analysisResult.getInternalArchitectureModel().getComponenttype().add((Object)dummyComponent);
    }

    private Set<ComponentImplementingClassesLink> listToSet(List<ComponentImplementingClassesLink> list) {
        HashSet<ComponentImplementingClassesLink> set = new HashSet<ComponentImplementingClassesLink>();
        for (ComponentImplementingClassesLink link : list) {
            boolean success = set.add(link);
            assert (success);
        }
        return set;
    }

    private void createPortAndDelegationConnector(ServiceArchitectureModel sammSystem, ComponentImplementingClassesLink compLink, SubcomponentInstance subComponentInstance, InterfaceSourceCodeLink ifLink, boolean isProvided) {
        InterfacePort outerIfPort = StaticstructureFactory.eINSTANCE.createInterfacePort();
        outerIfPort.setProvidingComponentType((PortEnabledEntity)sammSystem);
        outerIfPort.setInterfaceType(ifLink.getInterface());
        if (isProvided) {
            outerIfPort.setName(this.namingStrategy.createProvidedSystemPortName(ifLink.getInterface(), compLink.getComponent()));
        } else {
            outerIfPort.setName(this.namingStrategy.createRequiredSystemPortName(ifLink.getInterface(), compLink.getComponent()));
        }
        SubcomponentEndpoint subComponentEndpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint();
        subComponentEndpoint.setSubcomponent(subComponentInstance);
        if (isProvided) {
            subComponentEndpoint.setPort(this.getMatchingPort((EList<InterfacePort>)compLink.getComponent().getProvided(), ifLink.getInterface()));
        } else {
            subComponentEndpoint.setPort(this.getMatchingPort((EList<InterfacePort>)compLink.getComponent().getRequired(), ifLink.getInterface()));
        }
        ComponentEndpoint componentEndpoint = StaticstructureFactory.eINSTANCE.createComponentEndpoint();
        componentEndpoint.setPort((Port)outerIfPort);
        Connector connector = StaticstructureFactory.eINSTANCE.createConnector();
        connector.getEndpoints().add((Object)subComponentEndpoint);
        connector.getEndpoints().add((Object)componentEndpoint);
        sammSystem.getConnector().add((Object)connector);
    }

    private Port getMatchingPort(EList<InterfacePort> interfacePorts, Interface theInterface) {
        for (InterfacePort currentIfPort : interfacePorts) {
            if (!currentIfPort.getInterfaceType().equals(theInterface)) continue;
            return currentIfPort;
        }
        logger.warn((Object)("no interface port found for " + theInterface.getName()));
        return null;
    }
}

