/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.Visibilities;
import de.fzi.gast.variables.FormalParameter;
import eu.qimpress.samm.datatypes.CollectionDataType;
import eu.qimpress.samm.datatypes.ComplexDataType;
import eu.qimpress.samm.datatypes.DatatypesFactory;
import eu.qimpress.samm.datatypes.InnerElement;
import eu.qimpress.samm.datatypes.PrimitiveDataType;
import eu.qimpress.samm.datatypes.Type;
import eu.qimpress.samm.datatypes.XSDPrimitiveDataTypes;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.Parameter;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.sourcecodedecorator.MethodLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.configuration.SoMoXConfiguration;

public class OperationBuilder
extends AbstractBuilder {
    public static final String voidType = "void";
    private static Logger logger = Logger.getLogger(OperationBuilder.class);

    public OperationBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
    }

    public void createOperations(GASTClass implementationClass, GASTClass interfaceClass, Interface interf) {
        for (Method method : interfaceClass.getMethods()) {
            if (!method.getVisibility().equals((Object)Visibilities.VISIBILITYPACKAGE) && !method.getVisibility().equals((Object)Visibilities.VISIBILITYPUBLIC)) continue;
            Method realMethod = method;
            if (implementationClass != null) {
                realMethod = this.getRealMethod(implementationClass, method);
                if (realMethod == null) {
                    realMethod = method;
                    logger.error((Object)("GAST Model misses a method " + method.getSimpleName()));
                }
            } else {
                logger.warn((Object)("no implementation class for method " + method.getSimpleName() + " of interface " + interfaceClass.getSimpleName()));
            }
            Operation op = this.createOperationParametersAndMessageType(realMethod);
            interf.getSignatures().add((Object)op);
        }
    }

    private Method getRealMethod(GASTClass implementationClass, Method method) {
        assert (implementationClass != null);
        for (Method m : implementationClass.getMethods()) {
            if (m == method) {
                return m;
            }
            if (!m.getSimpleName().equals(method.getSimpleName())) continue;
            Method overrideMethod = (Method)m.getOverriddenMember();
            while (overrideMethod != null) {
                if (overrideMethod == method) {
                    return m;
                }
                overrideMethod = (Method)overrideMethod.getOverriddenMember();
            }
        }
        for (GASTClass superClass : implementationClass.getSuperTypes()) {
            Method real;
            if (superClass.isAbstract() || superClass.isInterface() || (real = this.getRealMethod(superClass, method)) == null) continue;
            return real;
        }
        return null;
    }

    private Operation createOperationParametersAndMessageType(Method method) {
        Operation operation = StaticstructureFactory.eINSTANCE.createOperation();
        operation.setName(method.getSimpleName());
        this.updateSourceCodeDecorator(operation, method);
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<GASTClass> paramTypes = new ArrayList<GASTClass>();
        for (FormalParameter inputParameter : method.getFormalParameters()) {
            paramNames.add(inputParameter.getSimpleName());
            if (inputParameter.getTypeDeclaration() != null && inputParameter.getType() != null) {
                paramTypes.add(inputParameter.getTypeDeclaration().getAccessedClass());
                continue;
            }
            logger.error((Object)("Input parameter type was null. Could not set the parameter type \"" + inputParameter.getSimpleName() + "\" of method \"" + method.getSimpleName() + "\""));
        }
        if (paramNames.size() > 0) {
            MessageType messageType = this.findMessageTypeInRepository(paramNames, paramTypes);
            if (messageType == null) {
                messageType = this.createMessageType(paramNames, paramTypes);
            }
            if (messageType != null) {
                operation.setInput(messageType);
            }
        }
        return operation;
    }

    private void updateSourceCodeDecorator(Operation operation, Method method) {
        MethodLevelSourceCodeLink link = SourceCodeDecoratorFactory.eINSTANCE.createMethodLevelSourceCodeLink();
        link.setFunction((Function)method);
        link.setOperation(operation);
        if (method.getPosition() != null && method.getPosition().getSourceFile() != null) {
            link.setFile(method.getPosition().getSourceFile());
        }
        this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink().add((Object)link);
    }

    private MessageType findMessageTypeInRepository(List<String> parameterNames, List<GASTClass> parameterTypes) {
        if (parameterNames == null) {
            parameterNames = new ArrayList<String>();
        }
        if (parameterTypes == null) {
            parameterTypes = new ArrayList<GASTClass>();
        }
        if (parameterNames.size() != parameterTypes.size()) {
            return null;
        }
        for (MessageType messageType : this.analysisResult.getInternalArchitectureModel().getMessagetype()) {
            if (messageType.getParameters().size() != parameterNames.size()) continue;
            boolean parametersMatch = true;
            int i = 0;
            while (i < messageType.getParameters().size()) {
                Parameter param = (Parameter)messageType.getParameters().get(i);
                if (!param.getName().equals(parameterNames.get(i))) {
                    parametersMatch = false;
                    break;
                }
                if (param.getType() != null && param.getType().getName() != null && parameterTypes.get(i).getSimpleName() != null && !param.getType().getName().toLowerCase().equals(parameterTypes.get(i).getSimpleName().toLowerCase())) {
                    parametersMatch = false;
                    break;
                }
                ++i;
            }
            if (!parametersMatch) continue;
            return messageType;
        }
        return null;
    }

    private MessageType createMessageType(List<String> parameterNames, List<GASTClass> parameterTypes) {
        if (parameterNames == null) {
            parameterNames = new ArrayList<String>();
        }
        if (parameterTypes == null) {
            parameterTypes = new ArrayList<GASTClass>();
        }
        if (parameterNames.size() != parameterTypes.size()) {
            return null;
        }
        MessageType messageType = StaticstructureFactory.eINSTANCE.createMessageType();
        String messageTypeName = "";
        if (parameterTypes.size() > 0) {
            int i = 0;
            while (i < parameterTypes.size()) {
                if (!parameterTypes.get(i).getSimpleName().equals(voidType)) {
                    if (messageTypeName.length() > 0) {
                        messageTypeName = String.valueOf(messageTypeName) + "_";
                    }
                    messageTypeName = String.valueOf(messageTypeName) + parameterTypes.get(i).getSimpleName();
                    Parameter param = StaticstructureFactory.eINSTANCE.createParameter();
                    param.setName(parameterNames.get(i));
                    param.setType(this.getType(parameterTypes.get(i), this.analysisResult.getInternalArchitectureModel()));
                    messageType.getParameters().add((Object)param);
                }
                ++i;
            }
        }
        if (messageType.getParameters().size() > 0) {
            messageType.setName(messageTypeName);
            this.analysisResult.getInternalArchitectureModel().getMessagetype().add((Object)messageType);
            return messageType;
        }
        return null;
    }

    private Type getType(GASTClass gastType, Repository repository) {
        Type type = this.getExistingType(gastType, repository);
        if (type == null) {
            type = this.createDataType(repository, gastType);
        }
        return type;
    }

    private Type createDataType(Repository repository, GASTClass gastType) {
        String typeName = gastType.getSimpleName();
        typeName = this.getUnifiedTypeName(typeName);
        PrimitiveDataType newType = null;
        if (!typeName.toLowerCase().equals(voidType)) {
            if (typeName.toLowerCase().equals("integer")) {
                newType = DatatypesFactory.eINSTANCE.createPrimitiveDataType();
                newType.setName("INTEGER");
                newType.setType(XSDPrimitiveDataTypes.INT);
                repository.getType().add((Object)newType);
            } else if (typeName.toLowerCase().equals("float")) {
                newType = DatatypesFactory.eINSTANCE.createPrimitiveDataType();
                newType.setName("FLOAT");
                newType.setType(XSDPrimitiveDataTypes.FLOAT);
                repository.getType().add((Object)newType);
            } else if (typeName.toLowerCase().equals("string")) {
                newType = DatatypesFactory.eINSTANCE.createPrimitiveDataType();
                newType.setName("STRING");
                newType.setType(XSDPrimitiveDataTypes.STRING);
                repository.getType().add((Object)newType);
            } else if (typeName.toLowerCase().equals("boolean")) {
                newType = DatatypesFactory.eINSTANCE.createPrimitiveDataType();
                newType.setName("BOOLEAN");
                newType.setType(XSDPrimitiveDataTypes.BOOLEAN);
                repository.getType().add((Object)newType);
            } else if (typeName.endsWith("[]")) {
                newType = DatatypesFactory.eINSTANCE.createCollectionDataType();
                newType.setName(typeName);
                repository.getType().add((Object)newType);
                logger.debug((Object)("found collection type " + typeName));
                String tmpInnerTypeName = typeName.substring(0, typeName.length() - 2);
                ((CollectionDataType)newType).setInnertype(this.getExistingTypeByName(tmpInnerTypeName, repository));
            } else if (gastType.getAllAccessedClasses().size() > 1) {
                newType = DatatypesFactory.eINSTANCE.createComplexDataType();
                newType.setName(typeName);
                repository.getType().add((Object)newType);
                for (GASTClass currentClass : gastType.getAllAccessedClasses()) {
                    if (currentClass.equals(gastType) || currentClass.getSimpleName().equals(voidType)) continue;
                    String tmpInnerTypeName = currentClass.getSimpleName();
                    InnerElement innerElement = DatatypesFactory.eINSTANCE.createInnerElement();
                    innerElement.setType(this.getType(currentClass, repository));
                    innerElement.setName(tmpInnerTypeName);
                    ((ComplexDataType)newType).getElements().add((Object)innerElement);
                }
            } else {
                newType = DatatypesFactory.eINSTANCE.createPrimitiveDataType();
                newType.setName(typeName);
                repository.getType().add((Object)newType);
            }
        }
        return newType;
    }

    private String getUnifiedTypeName(String typeName) {
        if (typeName.toLowerCase().equals("int") || typeName.toLowerCase().equals("long")) {
            typeName = "integer";
        } else if (typeName.toLowerCase().equals("bool")) {
            typeName = "boolean";
        } else if (typeName.toLowerCase().equals("char")) {
            typeName = "string";
        } else if (typeName.toLowerCase().equals("double")) {
            typeName = "float";
        }
        return typeName;
    }

    private Type getExistingType(GASTClass gastType, Repository repository) {
        return this.getExistingTypeByName(gastType.getSimpleName(), repository);
    }

    private Type getExistingTypeByName(String gastTypeName, Repository repository) {
        gastTypeName = this.getUnifiedTypeName(gastTypeName);
        for (Type currentType : repository.getType()) {
            if (!currentType.getName().toLowerCase().equals(gastTypeName.toLowerCase())) continue;
            return currentType;
        }
        logger.info((Object)("no type found for " + gastTypeName));
        return null;
    }
}

