/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.PortEnabledEntity;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorFactory;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.IInterfacePortBuilderStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.util.InterfacePortBuilderHelper;
import org.somox.analyzer.simplemodelanalyzer.builder.util.SubComponentInformation;
import org.somox.configuration.SoMoXConfiguration;

public class NonDuplicatingInterfacePortBuilder
extends AbstractBuilder
implements IInterfacePortBuilderStrategy {
    private static final Logger logger = Logger.getLogger(NonDuplicatingInterfacePortBuilder.class);
    private ComponentAndTypeNaming componentTypeNaming;
    private boolean isProvidedBuilder;

    public NonDuplicatingInterfacePortBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult, boolean isProvidedBuilder, ComponentAndTypeNaming componentTypeNaming) {
        super(gastModel, somoxConfiguration, analysisResult);
        this.isProvidedBuilder = isProvidedBuilder;
        this.componentTypeNaming = componentTypeNaming;
    }

    @Override
    public void buildInterfacePort(ComponentImplementingClassesLink componentLink) {
        assert (componentLink.isCompositeComponent());
        if (componentLink.getComponent() instanceof CompositeStructure) {
            CompositeStructure resultCompositeComponent = (CompositeStructure)componentLink.getComponent();
            Iterable<SubComponentInformation> interfaceLinksNotUsedInConnectors = InterfacePortBuilderHelper.collectInformationOnNonBoundInterfaces(componentLink, resultCompositeComponent, this.isProvidedBuilder);
            for (SubComponentInformation currentInterfaceLink : interfaceLinksNotUsedInConnectors) {
                if (this.isProvidedBuilder) {
                    this.createProvidedInterfacePortAndConnector(componentLink, currentInterfaceLink);
                    continue;
                }
                this.createRequiredInterfacePortAndConnector(componentLink, currentInterfaceLink);
            }
        } else {
            logger.warn((Object)"Only composite components should use this builder.");
        }
    }

    private void createProvidedInterfacePortAndConnector(ComponentImplementingClassesLink compositeComponentLink, SubComponentInformation subComponentInformation) {
        if (!(compositeComponentLink.getComponent() instanceof CompositeComponent)) {
            throw new RuntimeException("must be a composite component");
        }
        Set<Interface> allRequiredInterfaces = this.collectInterfacesForComponent(compositeComponentLink, true);
        if (!allRequiredInterfaces.contains(subComponentInformation.getInterfaceSourceCodeLink().getInterface())) {
            InterfacePort newProvidedPort = StaticstructureFactory.eINSTANCE.createInterfacePort();
            newProvidedPort.setInterfaceType(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
            newProvidedPort.setName(this.componentTypeNaming.createProvidedPortName(subComponentInformation.getInterfaceSourceCodeLink().getInterface(), compositeComponentLink.getComponent()));
            newProvidedPort.setDocumentation(subComponentInformation.getInterfaceSourceCodeLink().getInterface().getName());
            newProvidedPort.setProvidingComponentType((PortEnabledEntity)compositeComponentLink.getComponent());
            compositeComponentLink.getComponent().getProvided().add((Object)newProvidedPort);
            this.createDelegationConnector(compositeComponentLink, newProvidedPort, subComponentInformation, true);
            if (subComponentInformation.getInterfaceSourceCodeLink().getInterface() != null && subComponentInformation.getInterfaceSourceCodeLink().getInterface() != null) {
                InterfaceSourceCodeLink newInterfaceLink = SourceCodeDecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
                newInterfaceLink.setInterface(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
                newInterfaceLink.setGastClass(subComponentInformation.getInterfaceSourceCodeLink().getGastClass());
                compositeComponentLink.getProvidedInterfaces().add((Object)newInterfaceLink);
                SourceCodeDecoratorRepository parentRepository = (SourceCodeDecoratorRepository)compositeComponentLink.eContainer();
                parentRepository.getInterfaceSourceCodeLink().add((Object)newInterfaceLink);
            } else {
                logger.warn((Object)"Source code decorator: InterfaceLink had no interface or class set.");
            }
        }
    }

    private void createRequiredInterfacePortAndConnector(ComponentImplementingClassesLink compositeComponentLink, SubComponentInformation subComponentInformation) {
        InterfacePort requiredPort = null;
        Set<Interface> allRequiredInterfaces = this.collectInterfacesForComponent(compositeComponentLink, false);
        if (!allRequiredInterfaces.contains(subComponentInformation.getInterfaceSourceCodeLink().getInterface())) {
            requiredPort = StaticstructureFactory.eINSTANCE.createInterfacePort();
            requiredPort.setInterfaceType(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
            requiredPort.setName(this.componentTypeNaming.createRequiredPortName(subComponentInformation.getInterfaceSourceCodeLink().getInterface(), compositeComponentLink.getComponent()));
            requiredPort.setDocumentation(subComponentInformation.getInterfaceSourceCodeLink().getInterface().getName());
            requiredPort.setRequiringComponentType((PortEnabledEntity)compositeComponentLink.getComponent());
            compositeComponentLink.getComponent().getRequired().add((Object)requiredPort);
            if (subComponentInformation.getInterfaceSourceCodeLink().getInterface() != null && subComponentInformation.getInterfaceSourceCodeLink().getInterface() != null) {
                InterfaceSourceCodeLink newInterfaceLink = SourceCodeDecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
                newInterfaceLink.setInterface(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
                newInterfaceLink.setGastClass(subComponentInformation.getInterfaceSourceCodeLink().getGastClass());
                compositeComponentLink.getRequiredInterfaces().add((Object)newInterfaceLink);
                SourceCodeDecoratorRepository parentRepository = (SourceCodeDecoratorRepository)compositeComponentLink.eContainer();
                parentRepository.getInterfaceSourceCodeLink().add((Object)newInterfaceLink);
            } else {
                logger.warn((Object)"Source code decorator: InterfaceLink had no interface or class set.");
            }
        } else {
            for (InterfacePort currentRequiredInterfacePort : compositeComponentLink.getComponent().getRequired()) {
                if (!currentRequiredInterfacePort.getInterfaceType().equals(subComponentInformation.getInterfaceSourceCodeLink().getInterface())) continue;
                requiredPort = currentRequiredInterfacePort;
            }
        }
        if (requiredPort != null) {
            this.createDelegationConnector(compositeComponentLink, requiredPort, subComponentInformation, false);
        } else {
            logger.warn((Object)"Could not find a required interface port which should have existed.");
        }
    }

    private void createDelegationConnector(ComponentImplementingClassesLink compositeComponentLink, InterfacePort newOuterPort, SubComponentInformation subComponentInformation, boolean isProvidedDelegationConnector) {
        Connector delegationConnector = StaticstructureFactory.eINSTANCE.createConnector();
        ((CompositeComponent)compositeComponentLink.getComponent()).getConnector().add((Object)delegationConnector);
        String documentation = "";
        documentation = isProvidedDelegationConnector ? String.valueOf(documentation) + "provided" : String.valueOf(documentation) + "required";
        documentation = String.valueOf(documentation) + " delegation connector " + compositeComponentLink.getComponent().getName() + " to " + subComponentInformation.getSubComponentInstance().getRealizedBy().getName();
        delegationConnector.setDocumentation(documentation);
        ComponentEndpoint componentEndpoint = StaticstructureFactory.eINSTANCE.createComponentEndpoint();
        componentEndpoint.setPort((Port)newOuterPort);
        delegationConnector.getEndpoints().add((Object)componentEndpoint);
        SubcomponentEndpoint subcomponentEndpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint();
        subcomponentEndpoint.setPort((Port)subComponentInformation.getInterfacePort());
        subcomponentEndpoint.setSubcomponent(subComponentInformation.getSubComponentInstance());
        delegationConnector.getEndpoints().add((Object)subcomponentEndpoint);
    }

    private Set<Interface> collectInterfacesForComponent(ComponentImplementingClassesLink compositeComponentLink, boolean collectProvided) {
        HashSet<Interface> returnInterfaces = new HashSet<Interface>();
        EList ifLinks = collectProvided ? compositeComponentLink.getProvidedInterfaces() : compositeComponentLink.getRequiredInterfaces();
        for (InterfaceSourceCodeLink currentIfLink : ifLinks) {
            returnInterfaces.add(currentIfLink.getInterface());
        }
        return returnInterfaces;
    }
}

