/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.types.GASTClass;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ComponentAndTypeNaming {
    private Logger logger = Logger.getLogger(ComponentAndTypeNaming.class);
    private int compositeComponentNumber = 0;
    private int primitiveComponentNumber = 0;
    private int requiredPortNumber = 0;
    private int providedPortNumber;
    private final int MAXIMUM_NAME_LENGTH = 55;
    private final int MAX_NUMBER_OF_PATH_SEGMENTS_IN_INTERFACE_NAME = 3;

    @Deprecated
    public String createSimpleComponentName(int i, GASTClass gastClass) {
        return "Comp. " + i + ": " + gastClass.getSimpleName();
    }

    public String createSimpleComponentName(List<GASTClass> gastClasses, boolean shorten) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(" <PC No. " + this.primitiveComponentNumber++);
        StringBuilder subComponentNames = new StringBuilder();
        for (GASTClass currentGASTclass : gastClasses) {
            subComponentNames.append(" " + currentGASTclass.getSimpleName());
        }
        if (shorten) {
            nameBuilder.append(this.shorten(subComponentNames.toString()));
        } else {
            nameBuilder.append((CharSequence)subComponentNames);
        }
        nameBuilder.append(">");
        return nameBuilder.toString();
    }

    public String createSimpleComponentName(GASTClass gastClass) {
        return String.valueOf(gastClass.getQualifiedName()) + " <PC No. " + this.primitiveComponentNumber++ + ">";
    }

    public String createSimpleComponentName(int i, List<ComponentImplementingClassesLink> currentList) {
        StringBuilder sb = new StringBuilder();
        for (ComponentImplementingClassesLink currentClassesLinkList : currentList) {
            for (GASTClass currentClass : currentClassesLinkList.getImplementingClasses()) {
                sb.append(String.valueOf(currentClass.getSimpleName()) + " ");
            }
        }
        String name = "Comp No. " + i + " " + sb.toString();
        return this.shorten(name);
    }

    public String createCompositeComponentName(Collection<ComponentImplementingClassesLink> innerComponents) {
        return this.createCompositeComponentName(innerComponents, true);
    }

    public String createCompositeComponentName(Collection<ComponentImplementingClassesLink> innerComponents, boolean shorten) {
        ++this.compositeComponentNumber;
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("CC No. ");
        nameBuilder.append(String.valueOf(this.compositeComponentNumber) + " ");
        nameBuilder.append(this.createComponentNameBasedOnPackageName(this.compositeComponentNumber, innerComponents));
        nameBuilder.append(" <");
        StringBuilder subComponentName = new StringBuilder();
        for (ComponentImplementingClassesLink subcomponent : innerComponents) {
            if (subcomponent.getComponent() != null) {
                subComponentName.append(String.valueOf(subcomponent.getComponent().getName()) + " ");
                continue;
            }
            subComponentName.append(String.valueOf(this.createSimpleComponentName(0, (List<ComponentImplementingClassesLink>)subcomponent.getSubComponents())) + " ");
        }
        subComponentName.deleteCharAt(subComponentName.length() - 1);
        if (shorten) {
            nameBuilder.append(this.shorten(subComponentName.toString(), true));
        } else {
            nameBuilder.append(subComponentName.toString());
        }
        nameBuilder.append(">");
        return nameBuilder.toString();
    }

    private String createComponentNameBasedOnPackageName(int i, Collection<ComponentImplementingClassesLink> currentList) {
        String compName;
        String returnComponentName = "";
        HashMap<String, Integer> numberOfPackageNames = new HashMap<String, Integer>();
        HashMap<String, String> packageNames = new HashMap<String, String>();
        String maxNumberPackageId = null;
        String directoryName = "";
        int maxNumber = 0;
        for (ComponentImplementingClassesLink currentClassesLink : currentList) {
            for (GASTClass currentClass : currentClassesLink.getImplementingClasses()) {
                if (currentClass.getSurroundingPackage() != null) {
                    Integer tmpNumber = (Integer)numberOfPackageNames.get(currentClass.getSurroundingPackage().getId());
                    if (tmpNumber != null) {
                        tmpNumber = tmpNumber + 1;
                        numberOfPackageNames.put(currentClass.getSurroundingPackage().getId(), tmpNumber);
                        if (tmpNumber <= maxNumber) continue;
                        maxNumber = tmpNumber;
                        maxNumberPackageId = currentClass.getSurroundingPackage().getId();
                        continue;
                    }
                    numberOfPackageNames.put(currentClass.getSurroundingPackage().getId(), 1);
                    packageNames.put(currentClass.getSurroundingPackage().getId(), currentClass.getSurroundingPackage().getQualifiedName());
                    if (1 <= maxNumber) continue;
                    maxNumber = 1;
                    maxNumberPackageId = currentClass.getSurroundingPackage().getId();
                    continue;
                }
                if (currentClass.getPosition() != null && currentClass.getPosition().getSourceFile() != null) {
                    directoryName = currentClass.getPosition().getSourceFile().getPathName();
                    continue;
                }
                this.logger.warn((Object)("found neither packages nor directories for GAST class " + currentClass.getQualifiedName()));
            }
        }
        returnComponentName = "";
        if (maxNumber > 0 && (compName = (String)packageNames.get(maxNumberPackageId)) != null) {
            returnComponentName = String.valueOf(returnComponentName) + compName;
        }
        if (!directoryName.equals("")) {
            returnComponentName = String.valueOf(returnComponentName) + "(dir: " + directoryName + ")";
        }
        return this.shorten(returnComponentName);
    }

    public String createComponentInstanceName(ComponentType componentType) {
        if (componentType != null) {
            return String.valueOf(componentType.getName()) + "-instance";
        }
        return "class-level-instance";
    }

    public String createProvidedPortName(Interface provInterface, ComponentType component) {
        String ifName = provInterface.getName();
        if (ifName.contains(".")) {
            String[] subStrings = ifName.split("\\.", 0);
            ifName = subStrings[subStrings.length - 1];
        }
        ifName = String.valueOf(ifName) + " " + this.providedPortNumber++;
        return String.valueOf(this.shorten(ifName)) + " (prov)";
    }

    public String createProvidedSystemPortName(Interface provInterface, ComponentType component) {
        return String.valueOf(this.createProvidedPortName(provInterface, component)) + "(sys)";
    }

    public String createRequiredPortName(Interface reqInterface, ComponentType component) {
        String ifName = reqInterface.getName();
        if (ifName.contains(".")) {
            String[] subStrings = ifName.split("\\.", 0);
            ifName = subStrings[subStrings.length - 1];
        }
        ifName = String.valueOf(ifName) + " " + this.requiredPortNumber++;
        return String.valueOf(this.shorten(ifName)) + " (req)";
    }

    public String createRequiredSystemPortName(Interface reqInterface, ComponentType component) {
        return String.valueOf(this.createRequiredPortName(reqInterface, component)) + "(sys)";
    }

    public String createInterfaceName(GASTClass interfaceClass) {
        String interfaceName = this.segmentBasedInterfaceName(interfaceClass.getQualifiedName());
        return this.shorten(interfaceName, true);
    }

    public String createInterfaceNameForClass(GASTClass interfaceClass) {
        String interfaceName = this.segmentBasedInterfaceName(interfaceClass.getQualifiedName());
        return "I" + this.shorten(interfaceName, true);
    }

    private String segmentBasedInterfaceName(String qualifiedName) {
        String[] segments = qualifiedName.split("\\.");
        String interfaceName = "";
        boolean first = true;
        int i = 3;
        while (i > 0) {
            if (segments.length >= i) {
                if (!first) {
                    interfaceName = String.valueOf(interfaceName) + ".";
                }
                interfaceName = String.valueOf(interfaceName) + segments[segments.length - i];
                first = false;
            }
            --i;
        }
        return interfaceName;
    }

    private String shorten(String theString, boolean removeStartOfString) {
        String name = theString;
        if (theString.length() > 55) {
            name = removeStartOfString ? "..." + theString.substring(theString.length() - 55 + 3, theString.length()) : String.valueOf(theString.substring(0, 52)) + "...";
        }
        return name;
    }

    private String shorten(String theString) {
        return this.shorten(theString, false);
    }
}

