/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.Graph;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.IAssemblyConnectorStrategy;
import org.somox.metrics.ClusteringRelation;

public class AssemblyConnectorDeFactoStrategy
implements IAssemblyConnectorStrategy {
    public AssemblyConnectorDeFactoStrategy(AssemblyConnectorBuilder connectorBuilder) {
    }

    @Override
    public void buildAssemblyConnectors(ComponentImplementingClassesLink compositeComponentCandidate, Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        if (!compositeComponentCandidate.isCompositeComponent()) {
            throw new IllegalArgumentException("Add assembly connectors not allowed for primitive components");
        }
        for (ClusteringRelation edge : compositeComponentSubgraph.edgeSet()) {
            this.probeAssemblyConnector((CompositeComponent)compositeComponentCandidate.getComponent(), (ComponentImplementingClassesLink)compositeComponentSubgraph.getEdgeSource((Object)edge), (ComponentImplementingClassesLink)compositeComponentSubgraph.getEdgeTarget((Object)edge));
        }
    }

    private void probeAssemblyConnector(CompositeComponent component, ComponentImplementingClassesLink edgeSource, ComponentImplementingClassesLink edgeTarget) {
        EList requiredRoles = edgeSource.getComponent().getRequired();
        EList providedRoles = edgeTarget.getComponent().getProvided();
        for (InterfacePort requiredRole : requiredRoles) {
            for (InterfacePort providedRole : providedRoles) {
                if (requiredRole.getInterfaceType() != providedRole.getInterfaceType()) continue;
                AssemblyConnectorBuilder.createAssemblyConnector((CompositeStructure)component, (Port)requiredRole, (Port)providedRole, edgeSource.getComponent(), edgeTarget.getComponent());
            }
        }
    }

    @Override
    public void buildAssemblyConnectors(CompositeStructure compositeStructure, List<ComponentImplementingClassesLink> subComponents) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }
}

