/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.common.oaw;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowContextDefaultImpl;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;

public abstract class LazyAbstractOAWWorkflowJobBridge<T extends AbstractExpressionsUsingWorkflowComponent>
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private Logger logger = Logger.getLogger(LazyAbstractOAWWorkflowJobBridge.class);
    protected T oawJob = null;
    private HashMap<String, ModelLocation> slotContents;
    private MDSDBlackboard blackboard;

    public LazyAbstractOAWWorkflowJobBridge(T job) {
        this(job, new HashMap<String, ModelLocation>());
    }

    public LazyAbstractOAWWorkflowJobBridge(T job, HashMap<String, ModelLocation> slotContents) {
        this.oawJob = job;
        this.slotContents = slotContents;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        IssuesImpl issues = new IssuesImpl();
        WorkflowContextDefaultImpl ctx = new WorkflowContextDefaultImpl();
        this.setupContext((WorkflowContext)ctx);
        try {
            this.setupOAWJob(this.oawJob);
            this.logger.info((Object)"Validating oAW configuration settings...");
            this.oawJob.checkConfiguration((Issues)issues);
            if (issues.hasErrors()) {
                String message = issues.toString();
                throw new JobFailedException("oAW Job configuration is invalid: " + message);
            }
            this.logger.info((Object)"Running oAW task....");
            this.oawJob.invoke((WorkflowContext)ctx, (ProgressMonitor)new ProgressMonitorAdapter(monitor), (Issues)issues);
            if (issues.hasErrors()) {
                throw new JobFailedException("oAW Job failed");
            }
        }
        catch (Exception e) {
            throw new JobFailedException("oAW Failed", (Throwable)e);
        }
    }

    protected void setupContext(WorkflowContext ctx) {
        for (String slot : this.slotContents.keySet()) {
            ModelLocation ml = this.slotContents.get(slot);
            EObject eobj = (EObject)this.blackboard.getContents(ml).get(0);
            ctx.set(slot, (Object)eobj);
        }
    }

    protected abstract void setupOAWJob(T var1);

    public String getName() {
        return this.oawJob.getId() == null ? "oAW Job" : this.oawJob.getId();
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

