/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.common.jobs;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import eu.qimpress.transformations.common.jobs.LoadSAMMIntoBlackboardJob;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrepareSAMMBlackboardPartionJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger logger = Logger.getLogger(PrepareSAMMBlackboardPartionJob.class);
    private MDSDBlackboard blackboard;

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        logger.debug((Object)"Creating SAMM Model Partition");
        ResourceSetPartition myPartion = new ResourceSetPartition();
        this.blackboard.addPartition("eu.qimpress.samm.partition", (Object)myPartion);
        logger.debug((Object)"Initialising SAMM EPackages");
        myPartion.initialiseResourceSetEPackages(LoadSAMMIntoBlackboardJob.SAMM_EPACKAGES);
    }

    public String getName() {
        return "Prepare SAMM Blackboard Partions";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
        this.blackboard.removePartition("eu.qimpress.samm.partition");
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

