/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.project.repository.actions;

import eu.qimpress.ide.backbone.project.adapters.IConcreteSyntaxFile;
import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.qosannotation.Annotation;
import eu.qimpress.samm.qosannotation.QosAnnotations;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OpenEdificeEditorAction
implements IObjectActionDelegate {
    private static final String EDITOR_ID = "eu.qimpress.ide.editors.text.Edifice";
    private Shell shell = null;
    private NamedEntity entity = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        IConcreteSyntaxFile lazyDSLFile = null;
        try {
            lazyDSLFile = (IConcreteSyntaxFile)Platform.getAdapterManager().getAdapter((Object)this.entity, IConcreteSyntaxFile.class);
            if (lazyDSLFile != null) {
                lazyDSLFile.generate();
                lazyDSLFile.openInEditor(EDITOR_ID);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (lazyDSLFile != null) {
                lazyDSLFile.dispose();
            }
            MessageDialog.openError((Shell)this.shell, (String)"Error occured during opening editor", (String)("Cannot open editor for the entity " + this.entity.getName()));
        }
    }

    protected boolean deniedNamedEntity(NamedEntity namedEntity) {
        return namedEntity instanceof QosAnnotations || namedEntity instanceof Annotation;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sselection;
        if (selection != null && selection instanceof IStructuredSelection && !(sselection = (IStructuredSelection)selection).isEmpty()) {
            this.entity = (NamedEntity)sselection.getFirstElement();
            if (this.deniedNamedEntity(this.entity)) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
            }
        }
    }
}

