/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.wizards;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorContentProvider;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractQAlternativePage
extends WizardPage {
    TreeViewer alternativeViewer;
    private IQAlternative parentAlternative;
    private SELECT_ALTERNATIVES selectAlternatives = SELECT_ALTERNATIVES.NONE;
    private List<IQAlternative> selectedAlternatives = null;

    protected AbstractQAlternativePage(IQAlternative parentAlternative, String pageName, SELECT_ALTERNATIVES selectAlternatives) {
        super(pageName);
        this.parentAlternative = parentAlternative;
        this.selectAlternatives = selectAlternatives;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.setControl((Control)composite);
        Label parentAlternativeLabel = new Label(composite, 0);
        parentAlternativeLabel.setText("Parent alternative");
        GridDataFactory.generate((Control)parentAlternativeLabel, (int)1, (int)1);
        if (this.selectAlternatives == SELECT_ALTERNATIVES.NONE) {
            this.alternativeViewer = new TreeViewer(composite, 268438276);
        } else {
            this.alternativeViewer = new CheckboxTreeViewer(composite, 268438276);
            ((CheckboxTreeViewer)this.alternativeViewer).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (AbstractQAlternativePage.this.selectAlternatives == SELECT_ALTERNATIVES.SELECT_MULTIPLE) {
                        if (event.getChecked()) {
                            ((CheckboxTreeViewer)AbstractQAlternativePage.this.alternativeViewer).setSubtreeChecked(event.getElement(), true);
                        }
                        AbstractQAlternativePage.this.selectedAlternatives = new ArrayList();
                        Object[] checkedElements = ((CheckboxTreeViewer)AbstractQAlternativePage.this.alternativeViewer).getCheckedElements();
                        int i = 0;
                        while (i < ((CheckboxTreeViewer)AbstractQAlternativePage.this.alternativeViewer).getCheckedElements().length) {
                            if (checkedElements[i] instanceof IQAlternative) {
                                AbstractQAlternativePage.this.selectedAlternatives.add((IQAlternative)checkedElements[i]);
                            }
                            ++i;
                        }
                    }
                    if (AbstractQAlternativePage.this.selectAlternatives == SELECT_ALTERNATIVES.SELECT_ONE) {
                        if (!(event.getElement() instanceof IQAlternative)) {
                            if (event.getChecked()) {
                                ((CheckboxTreeViewer)AbstractQAlternativePage.this.alternativeViewer).setChecked(event.getElement(), false);
                            }
                        } else if (!event.getChecked()) {
                            ((CheckboxTreeViewer)AbstractQAlternativePage.this.alternativeViewer).setCheckedElements(new Object[0]);
                            AbstractQAlternativePage.this.selectedAlternatives = new ArrayList();
                        } else {
                            ((CheckboxTreeViewer)AbstractQAlternativePage.this.alternativeViewer).setCheckedElements(new Object[]{event.getElement()});
                            AbstractQAlternativePage.this.selectedAlternatives = new ArrayList();
                            AbstractQAlternativePage.this.selectedAlternatives.add((IQAlternative)event.getElement());
                        }
                    }
                }
            });
        }
        this.alternativeViewer.setContentProvider((IContentProvider)new QAppNavigatorContentProvider(QAppNavigatorContentProvider.ContentFilterEnum.FILTER_DEFAULT_ALTERNATIVE.val()));
        this.alternativeViewer.setLabelProvider((IBaseLabelProvider)new QAppNavigatorLabelProvider());
        this.alternativeViewer.setInput((Object)QImpressApplicationModelManager.getManager().getQAppModel());
        if (this.parentAlternative != null) {
            this.alternativeViewer.setSelection((ISelection)new StructuredSelection((Object)this.parentAlternative), true);
            this.alternativeViewer.expandToLevel((Object)this.parentAlternative, -1);
            this.alternativeViewer.expandAll();
        }
        GridDataFactory.generate((Control)this.alternativeViewer.getControl(), (int)3, (int)1);
    }

    public IStructuredSelection getAlternativeParentSelection() {
        ISelection selection = this.alternativeViewer.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public abstract String getAlternativeName();

    protected boolean validatePage() {
        String altName = this.getAlternativeName();
        if (altName == null || altName.equals("")) {
            this.setErrorMessage("Alternative name cannot be null!");
            return false;
        }
        if (this.getAlternativeParentSelection() == null) {
            this.setErrorMessage("Parent alternative or alternative repository/project has to be selected!");
        }
        return true;
    }

    public static enum SELECT_ALTERNATIVES {
        NONE,
        SELECT_ONE,
        SELECT_MULTIPLE;

    }
}

