/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.widgets.Composite;

public class QAlternativesCheckBoxTreeViewer
extends CheckboxTreeViewer {
    private List<IQAlternative> selectedAlternatives = null;
    private boolean canSelectRepository = false;

    protected QAlternativesCheckBoxTreeViewer(Composite parent, int style) {
        this(parent, style, true);
    }

    public IQAlternative getFirstSelectedAlternative() {
        if (this.selectedAlternatives == null || this.selectedAlternatives.size() == 0) {
            return null;
        }
        return this.selectedAlternatives.get(0);
    }

    protected QAlternativesCheckBoxTreeViewer(Composite parent, int style, final boolean singleSelection) {
        super(parent, style);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!singleSelection) {
                    if (event.getChecked()) {
                        QAlternativesCheckBoxTreeViewer.this.setSubtreeChecked(event.getElement(), true);
                    }
                    QAlternativesCheckBoxTreeViewer.this.selectedAlternatives = new ArrayList();
                    Object[] checkedElements = QAlternativesCheckBoxTreeViewer.this.getCheckedElements();
                    int i = 0;
                    while (i < QAlternativesCheckBoxTreeViewer.this.getCheckedElements().length) {
                        if (checkedElements[i] instanceof IQAlternative) {
                            QAlternativesCheckBoxTreeViewer.this.selectedAlternatives.add((IQAlternative)checkedElements[i]);
                        }
                        ++i;
                    }
                }
                if (singleSelection) {
                    if (!(event.getElement() instanceof IQAlternative)) {
                        if (event.getElement() instanceof IQRepository) {
                            if (event.getChecked()) {
                                QAlternativesCheckBoxTreeViewer.this.setChecked(event.getElement(), true);
                            }
                        } else if (event.getChecked()) {
                            QAlternativesCheckBoxTreeViewer.this.setChecked(event.getElement(), false);
                        }
                    } else if (!event.getChecked()) {
                        QAlternativesCheckBoxTreeViewer.this.setCheckedElements(new Object[0]);
                        QAlternativesCheckBoxTreeViewer.this.selectedAlternatives = new ArrayList();
                    } else {
                        QAlternativesCheckBoxTreeViewer.this.setCheckedElements(new Object[]{event.getElement()});
                        QAlternativesCheckBoxTreeViewer.this.selectedAlternatives = new ArrayList();
                        QAlternativesCheckBoxTreeViewer.this.selectedAlternatives.add((IQAlternative)event.getElement());
                    }
                }
            }
        });
    }

    public void selectElement(IQAlternative alternative) {
        this.expandToLevel(alternative, -1);
        this.setCheckedElements(new Object[]{alternative});
        this.selectedAlternatives = new ArrayList<IQAlternative>();
        this.selectedAlternatives.add(alternative);
    }

    public void setCanSelectRepository(boolean canSelectRepository) {
        this.canSelectRepository = canSelectRepository;
    }

    public boolean isCanSelectRepository() {
        return this.canSelectRepository;
    }

    public List<IQAlternative> getSelectedAlternatives() {
        if (this.selectedAlternatives == null) {
            return Collections.emptyList();
        }
        return this.selectedAlternatives;
    }
}

