/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.internal;

import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.IQWorkspaceController;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.UIJob;

public class QInitializationAfterStartJob
extends UIJob {
    private static final String JOB_NAME = "Q-ImPrESS Backbone Initialization Job";
    private static final Logger logger = Logger.getLogger(QInitializationAfterStartJob.class);

    public QInitializationAfterStartJob() {
        super(JOB_NAME);
        this.setSystem(true);
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        RealJob job = new RealJob(JOB_NAME);
        job.setPriority(20);
        job.schedule();
        return new Status(0, "eu.qimpress.ide.backbone.core", 0, "", null);
    }

    private class RealJob
    extends Job {
        public RealJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            logger.trace((Object)"Q-ImPrESS Backbone Initialization Job has started.");
            IQProject[] qProjects = QImpressApplicationModelManager.getManager().getQAppModel().getQProjects();
            try {
                monitor.beginTask(QInitializationAfterStartJob.JOB_NAME, qProjects.length);
                IQProject[] iQProjectArray = qProjects;
                int n = qProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IQProject qProject = iQProjectArray[n2];
                    try {
                        IQRepository repository = qProject.getRepository();
                        IQWorkspaceController repositoryController = (IQWorkspaceController)repository.getAdapter(IQWorkspaceController.class);
                        if (repositoryController != null) {
                            repositoryController.init(false, true);
                        }
                        monitor.worked(1);
                    }
                    catch (RepositoryException e) {
                        logger.warn((Object)("Cannot initialize Q-ImPrESS project: " + qProject), (Throwable)e);
                    }
                    ++n2;
                }
            }
            finally {
                monitor.done();
                QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
                logger.trace((Object)"Q-ImPrESS Backbone Initialization Job has finished.");
            }
            return new Status(0, "eu.qimpress.ide.backbone.core", 0, "", null);
        }

        public boolean belongsTo(Object family) {
            return "eu.qimpress.ide.backbone.core".equals(family);
        }
    }
}

