/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.QImpressNature;
import eu.qimpress.ide.backbone.core.operations.InitializeQImpressProjectOperation;
import eu.qimpress.ide.backbone.core.utils.ProjectUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleQImpressNatureAction
implements IObjectActionDelegate {
    private static final Logger logger = Logger.getLogger(ToggleQImpressNatureAction.class);
    private IProject project;

    public void run(IAction action) {
        if (this.project != null) {
            try {
                logger.trace((Object)("Toggle Q-ImPrESS nature for project: " + this.project));
                IWorkspaceRunnable op = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            try {
                                monitor.beginTask("", 2);
                                if (!QImpressNature.hasThisNature((IProject)ToggleQImpressNatureAction.this.project)) {
                                    new InitializeQImpressProjectOperation(ToggleQImpressNatureAction.this.project).run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                monitor.worked(1);
                                ProjectUtils.toggleNature((IProject)ToggleQImpressNatureAction.this.project);
                            }
                            catch (Exception e) {
                                throw new CoreException((IStatus)new Status(4, "eu.qimpress.ide.backbone.core", e.getMessage()));
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, null);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot toggle Q-ImPrESS nature for project: " + this.project), (Throwable)e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Toggle Q-ImPrESS nature", (String)"Cannot toggle Q-ImPrESS nature! See error log for details.");
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.project = null;
        if (selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty()) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IProject) {
                this.project = (IProject)element;
            } else if (element instanceof IAdaptable) {
                this.project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
            }
        }
        if (this.project != null) {
            try {
                if (this.project.hasNature("eu.qimpress.ide.backbone.core.ui.QImpressNature")) {
                    action.setText("Disable Q-ImPrESS nature");
                } else {
                    action.setText("Enable Q-ImPrESS nature");
                }
            }
            catch (CoreException coreException) {
                action.setText("Enable/Disable Q-ImPrESS nature");
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

