/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.QImpressNature;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQApplicationModelChangeListener;
import eu.qimpress.ide.backbone.core.model.IQInitializer;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.internal.DefaultAlternativeWrapper;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class QAppNavigatorContentProvider
extends WorkbenchContentProvider
implements IQApplicationModelChangeListener {
    private static final Logger logger = Logger.getLogger(QAppNavigatorContentProvider.class);
    private Viewer viewer;
    private int contentFilter;
    private static final Object[] NO_CHILDREN = new Object[0];

    public QAppNavigatorContentProvider() {
        this(ContentFilterEnum.NO_FILTER.val);
    }

    public QAppNavigatorContentProvider(int staticContentFilter) {
        this.contentFilter = staticContentFilter;
    }

    private void runViewerUpdate(final Runnable run) {
        Control ctrl;
        Control control = ctrl = this.viewer != null ? this.viewer.getControl() : null;
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            run.run();
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Control ctrl = QAppNavigatorContentProvider.this.viewer.getControl();
                    if (ctrl == null || ctrl.isDisposed()) {
                        return;
                    }
                    run.run();
                }
            });
        }
    }

    public void refresh() {
        this.runViewerUpdate(new Runnable(){

            @Override
            public void run() {
                if (QAppNavigatorContentProvider.this.viewer != null) {
                    QAppNavigatorContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    public void alternativeCreated(final IQAlternative alternative) {
        this.runViewerUpdate(new Runnable(){

            @Override
            public void run() {
                if (QAppNavigatorContentProvider.this.viewer != null) {
                    QAppNavigatorContentProvider.this.viewer.refresh();
                    QAppNavigatorContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection((Object)alternative), true);
                }
            }
        });
    }

    public void modelCreated(IQModel[] model) {
        this.runViewerUpdate(new Runnable(){

            @Override
            public void run() {
                if (QAppNavigatorContentProvider.this.viewer != null) {
                    QAppNavigatorContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    public void modelModified(IQModel[] models) {
        this.runViewerUpdate(new Runnable(){

            @Override
            public void run() {
                if (QAppNavigatorContentProvider.this.viewer != null) {
                    QAppNavigatorContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    public void modelDeleted(IQModel[] models) {
    }

    public void inputChanged(Viewer vwr, Object oldInput, Object newInput) {
        super.inputChanged(vwr, oldInput, newInput);
        this.viewer = vwr;
        IQApplicationModel appModel = QImpressApplicationModelManager.getManager().getQAppModel();
        if (oldInput != null) {
            appModel.removeChangeListener((IQApplicationModelChangeListener)this);
        }
        if (newInput != null) {
            appModel.addChangeListener((IQApplicationModelChangeListener)this);
        }
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IProject && QImpressNature.hasThisNature((IProject)((IProject)element))) {
            return this.getChildren(QImpressCore.create((IProject)((IProject)element)));
        }
        if (element instanceof IQApplicationModel) {
            return this.getQAppProjects((IQApplicationModel)element);
        }
        if (element instanceof IQProject) {
            if (!ContentFilterEnum.FILTER_PROJECTS_ONLY.isSet(this.contentFilter)) {
                return this.getDefAltAndRepository((IQProject)element);
            }
            return NO_CHILDREN;
        }
        if (element instanceof IQRepository) {
            return this.getAlternatives((IQRepository)element);
        }
        if (element instanceof IQAlternative) {
            IQAlternative alternative = (IQAlternative)element;
            if (QImpressCore.isGlobalAlternative((IQAlternative)alternative)) {
                return this.getModels(alternative);
            }
            return this.getChildrenAlternatives(alternative);
        }
        if (element instanceof DefaultAlternativeWrapper) {
            return this.getModels(((DefaultAlternativeWrapper)((Object)element)).getDefaultAlternative());
        }
        return super.getChildren(element);
    }

    public Object[] getElements(Object element) {
        if (element instanceof IQApplicationModel) {
            IProject[] projects = ((IQApplicationModel)element).getWorkspace().getRoot().getProjects();
            LinkedList<IProject> result = new LinkedList<IProject>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    if (project.isAccessible() && project.hasNature("eu.qimpress.ide.backbone.core.ui.QImpressNature")) {
                        result.add(project);
                    }
                }
                catch (CoreException e) {
                    logger.error((Object)"Cannot get elements from IQ app model.", (Throwable)e);
                }
                ++n2;
            }
            return result.toArray();
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            try {
                if (project.hasNature("eu.qimpress.ide.backbone.core.ui.QImpressNature")) {
                    return super.getElements((Object)QImpressCore.create((IProject)((IProject)element)));
                }
            }
            catch (CoreException e) {
                logger.error((Object)"Cannot get element from project", (Throwable)e);
            }
        }
        return super.getElements(element);
    }

    private Object[] getAlternatives(IQRepository repository) {
        if (!this.isRepositoryReady(repository)) {
            return NO_CHILDREN;
        }
        try {
            return repository.listTopLevelAlternatives();
        }
        catch (RepositoryException e) {
            logger.error((Object)"Cannot get alternatives from IQRepository", (Throwable)e);
            return NO_CHILDREN;
        }
    }

    private Object[] getDefAltAndRepository(IQProject project) {
        Object o;
        if (!this.isRepositoryReady(project)) {
            return NO_CHILDREN;
        }
        Object[] defaultAlternative = this.getDefaultAlternative(project);
        Object[] alternativeRepository = this.getRepository(project);
        Object[] resultModel = this.getResultModel(project);
        Object[] result = new Object[defaultAlternative.length + alternativeRepository.length + resultModel.length];
        int i = 0;
        Object[] objectArray = defaultAlternative;
        int n = defaultAlternative.length;
        int n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            result[i++] = o;
            ++n2;
        }
        objectArray = alternativeRepository;
        n = alternativeRepository.length;
        n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            result[i++] = o;
            ++n2;
        }
        objectArray = resultModel;
        n = resultModel.length;
        n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            result[i++] = o;
            ++n2;
        }
        return result;
    }

    private Object[] getQAppProjects(IQApplicationModel model) {
        return model.getQProjects();
    }

    private Object[] getDefaultAlternative(IQProject project) {
        Object[] result = null;
        if (ContentFilterEnum.FILTER_DEFAULT_ALTERNATIVE.isSet(this.contentFilter)) {
            return NO_CHILDREN;
        }
        try {
            IQRepository repo = project.getRepository();
            IQAlternative defaultAlternative = repo.getDefaultAlternative();
            result = defaultAlternative != null ? new Object[]{new DefaultAlternativeWrapper(defaultAlternative)} : NO_CHILDREN;
        }
        catch (RepositoryException e) {
            logger.error((Object)"Cannot get default alternative for project!", (Throwable)e);
            result = NO_CHILDREN;
        }
        return result;
    }

    private Object[] getRepository(IQProject project) {
        Object[] result = NO_CHILDREN;
        if (ContentFilterEnum.FILTER_REPOSITORY.isSet(this.contentFilter)) {
            return NO_CHILDREN;
        }
        try {
            IQRepository repo = project.getRepository();
            result = repo != null ? new Object[]{repo} : NO_CHILDREN;
        }
        catch (RepositoryException e) {
            logger.error((Object)"Cannot get repository for project", (Throwable)e);
            result = NO_CHILDREN;
        }
        return result;
    }

    private Object[] getModels(IQAlternative modelAlternative) {
        return modelAlternative.getModels();
    }

    private Object[] getResultModel(IQProject project) {
        Object[] result = null;
        try {
            IQModel resultModel = project.getRepository().getResultModel();
            result = resultModel != null ? new Object[]{resultModel} : NO_CHILDREN;
        }
        catch (RepositoryException e) {
            logger.error((Object)"Cannot get result model for this project project!", (Throwable)e);
            result = NO_CHILDREN;
        }
        return result;
    }

    private Object[] getChildrenAlternatives(IQAlternative alternativa) {
        try {
            return alternativa.getRepository().getChildren(alternativa);
        }
        catch (RepositoryException e) {
            logger.error((Object)"Cannot get children alternative for alternative", (Throwable)e);
            return NO_CHILDREN;
        }
    }

    private boolean isRepositoryReady(IQRepository repository) {
        IQInitializer initializer = (IQInitializer)repository.getAdapter(IQInitializer.class);
        if (initializer != null) {
            return initializer.isReady();
        }
        return true;
    }

    private boolean isRepositoryReady(IQProject project) {
        try {
            IQRepository repository = project.getRepository();
            return this.isRepositoryReady(repository);
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    public static enum ContentFilterEnum {
        NO_FILTER(0),
        FILTER_REPOSITORY(1),
        FILTER_ALTERNATIVES(2),
        FILTER_DEFAULT_ALTERNATIVE(4),
        FILTER_PROJECTS_ONLY(8);

        private int val;

        private ContentFilterEnum(int val) {
            this.val = val;
        }

        public boolean isSet(int filter) {
            return (this.val & filter) == this.val;
        }

        public int val() {
            return this.val;
        }
    }
}

