/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ItemListener;
import java.awt.event.TextListener;
import java.awt.event.WindowListener;
import org.nfunk.jep.JEP;

public class Evaluator
extends Applet {
    private static final long serialVersionUID = 4592714713689369505L;
    private JEP myParser;
    private double xValue;
    private TextField exprField;
    private TextField xField;
    private TextArea errorTextArea;
    private Label resultLabel;
    private Checkbox implicitCheckbox;
    private Checkbox undeclaredCheckbox;

    public static void main(String[] args) {
        Evaluator a = new Evaluator();
        a.init();
        a.start();
        Frame f = new Frame("Evaluator");
        f.add("Center", (Component)a);
        f.setSize(400, 200);
        f.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        f.setVisible(true);
    }

    public void init() {
        this.xValue = 10.0;
        this.addGUIComponents();
        this.myParser = new JEP();
        this.myParser.initFunTab();
        this.myParser.addStandardFunctions();
        this.myParser.setTraverse(true);
        this.optionsChanged();
    }

    private void addGUIComponents() {
        this.setBackground(Color.white);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout((LayoutManager)gridbag);
        c.fill = 2;
        c.weightx = 0.0;
        Label exprFieldp = new Label("Expression: ", 2);
        gridbag.setConstraints(exprFieldp, c);
        this.add((Component)exprFieldp);
        c.weightx = 0.8;
        this.exprField = new TextField(27);
        gridbag.setConstraints(this.exprField, c);
        this.add((Component)this.exprField);
        c.weightx = 0.0;
        Label xFieldp = new Label("x: ", 2);
        gridbag.setConstraints(xFieldp, c);
        this.add((Component)xFieldp);
        c.weightx = 0.2;
        c.gridwidth = 0;
        this.xField = new TextField("" + this.xValue, 4);
        gridbag.setConstraints(this.xField, c);
        this.add((Component)this.xField);
        c.weightx = 0.0;
        c.gridwidth = 1;
        Label resultLabelText = new Label("Result: ", 2);
        gridbag.setConstraints(resultLabelText, c);
        this.add((Component)resultLabelText);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.resultLabel = new Label("", 0);
        gridbag.setConstraints(this.resultLabel, c);
        this.add((Component)this.resultLabel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        Label optionsLabelText = new Label("Options: ", 2);
        gridbag.setConstraints(optionsLabelText, c);
        this.add((Component)optionsLabelText);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.implicitCheckbox = new Checkbox("Implicit multiplication", true);
        gridbag.setConstraints(this.implicitCheckbox, c);
        this.add((Component)this.implicitCheckbox);
        c.weightx = 0.0;
        c.gridwidth = 1;
        Label spaceLabelText = new Label(" ", 2);
        gridbag.setConstraints(spaceLabelText, c);
        this.add((Component)spaceLabelText);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.undeclaredCheckbox = new Checkbox("Allow undeclared identifiers");
        gridbag.setConstraints(this.undeclaredCheckbox, c);
        this.add((Component)this.undeclaredCheckbox);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.anchor = 11;
        Label errorLabel = new Label("Errors: ", 2);
        gridbag.setConstraints(errorLabel, c);
        this.add((Component)errorLabel);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        this.errorTextArea = new TextArea("");
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setBackground(Color.white);
        gridbag.setConstraints(this.errorTextArea, c);
        this.add((Component)this.errorTextArea);
        this.exprField.addTextListener((TextListener)new /* Unavailable Anonymous Inner Class!! */);
        this.xField.addTextListener((TextListener)new /* Unavailable Anonymous Inner Class!! */);
        this.implicitCheckbox.addItemListener((ItemListener)new /* Unavailable Anonymous Inner Class!! */);
        this.undeclaredCheckbox.addItemListener((ItemListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void parseExpression() {
        this.myParser.initSymTab();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.addVariable("x", this.xValue);
        this.myParser.parseExpression(this.exprField.getText());
    }

    private void exprFieldTextValueChanged() {
        this.parseExpression();
        this.updateResult();
    }

    private void xFieldTextValueChanged() {
        try {
            this.xValue = Double.valueOf(this.xField.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid format in xField");
            this.xValue = 0.0;
        }
        this.myParser.addVariable("x", this.xValue);
        this.updateResult();
    }

    private void optionsChanged() {
        this.myParser.setImplicitMul(this.implicitCheckbox.getState());
        this.myParser.setAllowUndeclared(this.undeclaredCheckbox.getState());
        this.parseExpression();
        this.updateResult();
    }

    private void updateResult() {
        Object result = this.myParser.getValueAsObject();
        if (result != null) {
            this.resultLabel.setText(result.toString());
        } else {
            this.resultLabel.setText("");
        }
        String errorInfo = this.myParser.getErrorInfo();
        if (errorInfo != null) {
            this.errorTextArea.setText(errorInfo);
        } else {
            this.errorTextArea.setText("");
        }
    }

    static /* synthetic */ void access$0(Evaluator evaluator) {
        evaluator.exprFieldTextValueChanged();
    }

    static /* synthetic */ void access$1(Evaluator evaluator) {
        evaluator.xFieldTextValueChanged();
    }

    static /* synthetic */ void access$2(Evaluator evaluator) {
        evaluator.optionsChanged();
    }
}

