/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import java.text.NumberFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.Node;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

/*
 * Exception performing whole class analysis ignored.
 */
public class SJepTest
extends TestCase {
    DJep j;
    PolynomialCreator pc;
    public static final boolean SHOW_BAD = false;
    static /* synthetic */ Class class$0;

    public SJepTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.SJepTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite((Class)clazz);
        suite.run(new TestResult());
    }

    protected void setUp() {
        this.j = new DJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
        this.j.addStandardDiffRules();
        this.pc = new PolynomialCreator((XJep)this.j);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.SJepTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void myAssertEquals(String msg, String actual, String expected) {
        if (!actual.equals(expected)) {
            System.out.println("Error \"" + msg + "\" is \"" + actual + " should be " + expected + "\"");
        }
        SJepTest.assertEquals((String)("<" + msg + ">"), (Object)expected, (Object)actual);
        System.out.println("Success: Value of \"" + msg + "\" is \"" + actual + "\"");
    }

    public void assertPolynomialEquals(String s1, String s2) throws ParseException {
        Node n2;
        PNodeI p2;
        PNodeI e2;
        Node n1 = this.j.parse(s1);
        PNodeI p1 = this.pc.createPoly(n1);
        PNodeI e1 = p1.expand();
        if (e1.equals(e2 = (p2 = this.pc.createPoly(n2 = this.j.parse(s2))).expand())) {
            System.out.println("Sucess: \"" + s1 + "\" equals \"" + s2 + "\"");
        } else {
            System.out.println("Error: \"" + s1 + "\" is not equal to \"" + s2 + "\"");
            SJepTest.assertTrue((String)("<" + s1 + "> should be equal to <" + s2 + "> it is not"), (boolean)false);
        }
    }

    public void testGood() {
        SJepTest.assertEquals((int)1, (int)1);
    }

    public void valueTest(String expr, double dub) throws Exception {
        this.valueTest(expr, (Object)new Double(dub));
    }

    public void valueTest(String expr, Object expected) throws Exception {
        Node node = this.j.parse(expr);
        Node n2 = this.j.preprocess(node);
        Object res = this.j.evaluate(n2);
        SJepTest.assertEquals((String)("<" + expr + ">"), (Object)expected, (Object)res);
        System.out.println("Success value of <" + expr + "> is " + res);
    }

    public void complexValueTest(String expr, Complex expected, double tol) throws Exception {
        Node node = this.j.parse(expr);
        Node n2 = this.j.preprocess(node);
        Object res = this.j.evaluate(n2);
        SJepTest.assertTrue((String)("<" + expr + "> expected: <" + expected + "> but was <" + res + ">"), (boolean)expected.equals((Complex)res, tol));
        System.out.println("Success value of <" + expr + "> is " + res);
    }

    public Object calcValue(String expr) throws ParseException {
        Node node = this.j.parse(expr);
        Node n2 = this.j.preprocess(node);
        Object res = this.j.evaluate(n2);
        return res;
    }

    public void simplifyTest(String expr, String expected) throws ParseException {
        Node node = this.j.parse(expr);
        Node processed = this.j.preprocess(node);
        PNodeI poly = this.pc.createPoly(processed);
        String res = poly.toString();
        Node node2 = this.j.parse(expected);
        Node processed2 = this.j.preprocess(node2);
        PNodeI poly2 = this.pc.createPoly(processed2);
        String res2 = poly2.toString();
        if (!res2.equals(res)) {
            System.out.println("Error: Value of \"" + expr + "\" is \"" + res + "\" should be \"" + res2 + "\"");
        }
        SJepTest.assertEquals((String)("<" + expr + ">"), (Object)res2, (Object)res);
        System.out.println("Sucess: Value of \"" + expr + "\" is \"" + res + "\"");
    }

    public void simplifyTestString(String expr, String expected) throws ParseException {
        Node node = this.j.parse(expr);
        Node processed = this.j.preprocess(node);
        PNodeI poly = this.pc.createPoly(processed);
        String res = poly.toString();
        if (!expected.equals(res)) {
            System.out.println("Error: Value of \"" + expr + "\" is \"" + res + "\" should be \"" + expected + "\"");
        }
        SJepTest.assertEquals((String)("<" + expr + ">"), (Object)expected, (Object)res);
        System.out.println("Sucess: Value of \"" + expr + "\" is \"" + res + "\"");
    }

    public void expandTestString(String expr, String expected) throws ParseException {
        Node node = this.j.parse(expr);
        Node processed = this.j.preprocess(node);
        PNodeI poly = this.pc.createPoly(processed);
        PNodeI expand = poly.expand();
        String res = expand.toString();
        if (!expected.equals(res)) {
            System.out.println("Error: Value of \"" + expr + "\" is \"" + res + "\" should be \"" + expected + "\"");
        }
        SJepTest.assertEquals((String)("<" + expr + ">"), (Object)expected, (Object)res);
        System.out.println("Sucess: Value of \"" + expr + "\" is \"" + res + "\"");
    }

    public void testSimpleSum() throws Exception {
        this.valueTest("1+2", 3.0);
        this.valueTest("2*6+3", 15.0);
        this.valueTest("2*(6+3)", 18.0);
    }

    public void testOperators() throws Exception {
        OperatorSet opSet = this.j.getOperatorSet();
        if (!((XOperator)opSet.getMultiply()).isDistributiveOver(opSet.getAdd())) {
            SJepTest.fail((String)"* should be distrib over +");
        }
        if (((XOperator)opSet.getMultiply()).isDistributiveOver(opSet.getDivide())) {
            SJepTest.fail((String)"* should not be distrib over /");
        }
        if (((XOperator)opSet.getMultiply()).getPrecedence() > ((XOperator)opSet.getAdd()).getPrecedence()) {
            SJepTest.fail((String)"* should have a lower precedence than +");
        }
        this.valueTest("T=1", 1.0);
        this.valueTest("F=0", 0.0);
        this.calcValue("a=F");
        this.calcValue("b=F");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=F");
        this.calcValue("b=F");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=F");
        this.calcValue("b=T");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=F");
        this.calcValue("b=T");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=F");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=F");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=T");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=T");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
    }

    public void testPrint() throws ParseException {
        this.simplifyTestString("(a+b)+c", "a+b+c");
        this.simplifyTestString("(a-b)+c", "a-b+c");
        this.simplifyTestString("(a+b)-c", "a+b-c");
        this.simplifyTestString("(a-b)-c", "a-b-c");
        this.simplifyTestString("a+(b+c)", "a+b+c");
        this.simplifyTestString("a-(b+c)", "a-b-c");
        this.simplifyTestString("a+(b-c)", "a+b-c");
        this.simplifyTestString("a-(b-c)", "a-b+c");
        this.simplifyTestString("(a*b)*c", "a*b*c");
        this.simplifyTestString("(a/b)*c", "a*c/b");
        this.simplifyTestString("(a*b)/c", "a*b/c");
        this.simplifyTestString("(a/b)/c", "a/(b*c)");
        this.simplifyTestString("a*(b*c)", "a*b*c");
        this.simplifyTestString("a/(b*c)", "a/(b*c)");
        this.simplifyTestString("a*(b/c)", "a*b/c");
        this.simplifyTestString("a/(b/c)", "a*c/b");
        this.simplifyTestString("(a*b)+c", "a*b+c");
        this.simplifyTestString("(a+b)*c", "(a+b)*c");
        this.simplifyTestString("a*(b+c)", "a*(b+c)");
        this.simplifyTestString("a+(b*c)", "a+b*c");
    }

    public void testSimp() throws ParseException {
        this.simplifyTest("2+3", "5");
        this.simplifyTest("2*3", "6");
        this.simplifyTest("2^3", "8");
        this.simplifyTest("3/2", "1.5");
        this.simplifyTest("2*3+4", "10");
        this.simplifyTest("2*(3+4)", "14");
        this.simplifyTest("0+x", "x");
        this.simplifyTest("x+0", "x");
        this.simplifyTest("0-x", "0-x");
        this.simplifyTest("x-0", "x");
        this.simplifyTest("0*x", "0");
        this.simplifyTest("x*0", "0");
        this.simplifyTest("1*x", "x");
        this.simplifyTest("x*1", "x");
        this.simplifyTest("-1*x", "-x");
        this.simplifyTest("x*-1", "-x");
        this.simplifyTest("-(-x)", "x");
        this.simplifyTest("-(-(-x))", "-x");
        this.simplifyTest("(-1)*(-1)*x", "x");
        this.simplifyTest("(-1)*(-1)*(-1)*x", "-x");
        this.simplifyTest("0/x", "0");
        this.simplifyTest("x/0", "1/0");
        this.simplifyTest("x^0", "1");
        this.simplifyTest("x^1", "x");
        this.simplifyTest("0^x", "0");
        this.simplifyTest("1^x", "1");
        this.simplifyTest("(2+3)+x", "5+x");
        this.simplifyTest("(2+x)+3", "5+x");
        this.simplifyTest("(x+2)+3", "5+x");
        this.simplifyTest("x+(2+3)", "5+x");
        this.simplifyTest("2+(x+3)", "5+x");
        this.simplifyTest("2+(3+x)", "5+x");
        this.simplifyTest("(2+3)-x", "5-x");
        this.simplifyTest("(2+x)-3", "x-1");
        this.simplifyTest("(x+2)-3", "x-1");
        this.simplifyTest("(2-3)+x", "-1+x");
        this.simplifyTest("(2-x)+3", "5-x");
        this.simplifyTest("(x-2)+3", "1+x");
        this.simplifyTest("x-(2+3)", "x-5");
        this.simplifyTest("2-(x+3)", "-1-x");
        this.simplifyTest("2-(3+x)", "-1-x");
        this.simplifyTest("x+(2-3)", "x-1");
        this.simplifyTest("2+(x-3)", "-1+x");
        this.simplifyTest("2+(3-x)", "5-x");
        this.simplifyTest("x-(2-3)", "1+x");
        this.simplifyTest("2-(x-3)", "5-x");
        this.simplifyTest("2-(3-x)", "-1+x");
        this.simplifyTest("(2-3)-x", "-1-x");
        this.simplifyTest("(2-x)-3", "-1-x");
        this.simplifyTest("(x-2)-3", "x-5");
        this.simplifyTest("(2*3)*x", "6*x");
        this.simplifyTest("(2*x)*3", "6*x");
        this.simplifyTest("(x*2)*3", "6*x");
        this.simplifyTest("x*(2*3)", "6*x");
        this.simplifyTest("2*(x*3)", "6*x");
        this.simplifyTest("2*(3*x)", "6*x");
        this.simplifyTest("(2*3)/x", "6/x");
        this.simplifyTest("(3*x)/2", "1.5*x");
        this.simplifyTest("(x*3)/2", "1.5*x");
        this.simplifyTest("(3/2)*x", "1.5*x");
        this.simplifyTest("(3/x)*2", "6/x");
        this.simplifyTest("(x/2)*3", "1.5*x");
        this.simplifyTest("x/(2*3)", "x/6");
        this.simplifyTest("3/(x*2)", "1.5/x");
        this.simplifyTest("3/(2*x)", "1.5/x");
        this.simplifyTest("x*(3/2)", "1.5*x");
        this.simplifyTest("3*(x/2)", "1.5*x");
        this.simplifyTest("3*(2/x)", "6/x");
        this.simplifyTest("x/(3/2)", "x/1.5");
        this.simplifyTest("2/(x/3)", "6/x");
        this.simplifyTest("3/(2/x)", "1.5*x");
        this.simplifyTest("(3/2)/x", "1.5/x");
        this.simplifyTest("(3/x)/2", "1.5/x");
        this.simplifyTest("(x/3)/2", "x/6");
        this.simplifyTest("x*(3+2)", "5*x");
        this.simplifyTest("x*(3-2)", "x");
        this.simplifyTest("(3-2)*x", "x");
        this.simplifyTest("x*x", "x^2");
        this.simplifyTest("x*x*x", "x^3");
        this.simplifyTest("(x^3)*(x^4)", "x^7");
        this.simplifyTest("(x^4)/(x^3)", "x");
        this.simplifyTest("(x^3)/(x^4)", "1/x");
        this.simplifyTest("(x^2)/(x^4)", "1/x^2");
        this.simplifyTestString("1/x", "1/x");
        this.simplifyTestString("-1/x", "-1/x");
        this.simplifyTestString("2/x", "2/x");
        this.simplifyTestString("-2/x", "-2/x");
        this.simplifyTestString("(1+x)*(1+x)", "(1+x)^2");
        this.simplifyTestString("(1+x)/(1+x)", "1");
        this.simplifyTest("2*x+x", "3*x");
        this.simplifyTest("2*x+3*x", "5*x");
        this.simplifyTest("5*x-3*x", "2*x");
        this.simplifyTest("3*x-5*x", "-2*x");
        this.simplifyTest("3*x-x", "2*x");
        this.simplifyTest("(2*x+x)^3", "27*x^3");
    }

    public void testPolySimp() throws ParseException, Exception {
        Node n1 = this.j.parse("(1.0+2.0*x+x^2.0)*(1.0+2.0*x+x^2.0)");
        this.pc.createPoly(n1);
        this.expandTestString("(a+b)*(c+d)", "a*c+a*d+b*c+b*d");
        this.expandTestString("a*c+a*d+b*c+b*d", "a*c+a*d+b*c+b*d");
        this.expandTestString("(a+b)*(a+b)", "2*a*b+a^2+b^2");
        this.expandTestString("(a-b)*(a-b)", "-2*a*b+a^2+b^2");
        this.expandTestString("(x+7.6)*(x+5.8832)*(x-55.12)", "-2464.5430784-698.4816639999999*x-41.636799999999994*x^2+x^3");
        this.simplifyTestString("(a+b)^0", "1");
        this.simplifyTestString("(a-b)^0", "1");
        this.simplifyTestString("(a+b)^1", "a+b");
        this.simplifyTestString("(a-b)^1", "a-b");
        this.expandTestString("(a+b)^2", "2*a*b+a^2+b^2");
        this.expandTestString("(a-b)^2", "-2*a*b+a^2+b^2");
        this.expandTestString("(a+b)^3", "3*a*b^2+3*a^2*b+a^3+b^3");
        this.expandTestString("(a-b)^3", "3*a*b^2-3*a^2*b+a^3-b^3");
        this.expandTestString("1+x+x^2+x*y+y^2", "1+x+x*y+x^2+y^2");
        this.expandTestString("(5*x+3*y)^2", "30*x*y+25*x^2+9*y^2");
        this.j.getPrintVisitor().setMaxLen(80);
        Node Q8node = this.j.parse("(xx^2+yy^2+zz^2+ww^2)^4");
        Node Q8expand = this.pc.expand(Q8node);
        this.j.println(Q8expand);
        this.expandTestString("(xx^2+yy^2+zz^2+ww^2)^4", "24*ww^2*xx^2*yy^2*zz^2+12*ww^2*xx^2*yy^4+12*ww^2*xx^2*zz^4+12*ww^2*xx^4*yy^2+12*ww^2*xx^4*zz^2+4*ww^2*xx^6+12*ww^2*yy^2*zz^4+12*ww^2*yy^4*zz^2+4*ww^2*yy^6+4*ww^2*zz^6+12*ww^4*xx^2*yy^2+12*ww^4*xx^2*zz^2+6*ww^4*xx^4+12*ww^4*yy^2*zz^2+6*ww^4*yy^4+6*ww^4*zz^4+4*ww^6*xx^2+4*ww^6*yy^2+4*ww^6*zz^2+ww^8+12*xx^2*yy^2*zz^4+12*xx^2*yy^4*zz^2+4*xx^2*yy^6+4*xx^2*zz^6+12*xx^4*yy^2*zz^2+6*xx^4*yy^4+6*xx^4*zz^4+4*xx^6*yy^2+4*xx^6*zz^2+xx^8+4*yy^2*zz^6+6*yy^4*zz^4+4*yy^6*zz^2+yy^8+zz^8");
        Node n = this.j.parse("ln(x+1)");
        Node diff = this.j.differentiate(n, "x");
        Node simp = this.pc.simplify(diff);
        this.myAssertEquals("diff(ln(x+1))", this.j.toString(simp), "1.0/(1.0+x)");
        diff = this.j.differentiate(simp, "x");
        this.j.println(diff);
        simp = this.pc.simplify(diff);
        this.myAssertEquals("d^2(ln(x+1))", this.j.toString(simp), "-1.0/(1.0+x)^2.0");
        diff = this.j.differentiate(simp, "x");
        this.j.println(diff);
        simp = this.pc.simplify(diff);
        this.myAssertEquals("d^3(ln(x+1))", this.j.toString(simp), "2.0/(1.0+x)^3.0");
        diff = this.j.differentiate(simp, "x");
        this.j.println(diff);
        simp = this.pc.simplify(diff);
        System.out.println("D^4\t" + this.j.toString(simp));
        this.j.getPrintVisitor().setMaxLen(80);
        diff = this.j.differentiate(simp, "x");
        simp = this.pc.simplify(diff);
        System.out.print("D^5\t");
        this.j.println(simp);
        diff = this.j.differentiate(simp, "x");
        simp = this.pc.simplify(diff);
        System.out.print("D^6\t");
        this.j.println(simp);
        diff = this.j.differentiate(simp, "x");
        simp = this.pc.simplify(diff);
        System.out.print("D^7\t");
        this.j.println(simp);
        diff = this.j.differentiate(simp, "x");
        simp = this.pc.simplify(diff);
        System.out.print("D^8\t");
        this.j.println(simp);
    }

    public void testTotalOrder() throws ParseException, Exception {
        this.expandTestString("y+x", "x+y");
        this.expandTestString("x^2+x", "x+x^2");
        this.expandTestString("x^3+x^2", "x^2+x^3");
        this.expandTestString("x*y+x", "x+x*y");
        this.expandTestString("x^2+x*y", "x*y+x^2");
        this.expandTestString("x+1/x", "1/x+x");
        this.expandTestString("1/x^2+1/x", "1/x^2+1/x");
        this.simplifyTestString("y+x", "x+y");
        this.simplifyTestString("x^2+x", "x+x^2");
        this.simplifyTestString("x^3+x^2", "x^2+x^3");
        this.simplifyTestString("x*y+x", "x+x*y");
        this.simplifyTestString("x^2+x*y", "x*y+x^2");
        this.simplifyTestString("x+1/x", "1/x+x");
        this.simplifyTestString("1/x^2+1/x", "1/x^2+1/x");
    }

    public void testPolySimp2() throws ParseException, Exception {
        this.expandTestString("1+2*(1+x)", "3+2*x");
        this.expandTestString("6x+3y+4x+3(15x+7y)+40", "40+55*x+24*y");
        this.expandTestString("x*y+2*x", "2*x+x*y");
        this.expandTestString("(1+x+y)^2", "1+2*x+2*x*y+x^2+2*y+y^2");
    }

    public void testFormat() throws ParseException {
        NumberFormat format = NumberFormat.getInstance();
        this.j.getPrintVisitor().setNumberFormat(format);
        format.setMaximumFractionDigits(3);
        format.setMinimumFractionDigits(0);
        String s1 = "[10,0,0.1,0.11,0.111,0.1111]";
        String r1 = this.j.toString(this.j.parse(s1));
        String s2 = "[0.9,0.99,0.999,0.9999]";
        String r2 = this.j.toString(this.j.parse(s2));
        this.myAssertEquals(s1, r1, "[10,0,0.1,0.11,0.111,0.111]");
        this.myAssertEquals(s2, r2, "[0.9,0.99,0.999,1]");
        this.j.println(this.j.parse("[0,1,i,1+i]"));
        this.j.getPrintVisitor().setMode(2, true);
        this.j.println(this.j.simplify(this.j.parse("(2+i)+(1+i)")));
        this.j.parseExpression("(2+i)+(1+i)");
        Complex c = this.j.getComplexValue();
        System.out.println(c.toString(format, true));
    }

    public void testSimpleEquals() throws ParseException {
        this.assertPolynomialEquals("a+b-(c+d)", "(a+b)-c-d");
    }

    public void testBad() throws ParseException {
    }
}

