/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.util.Stack;
import org.lsmp.djepExamples.Console;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class BlockStatments
extends Console {
    private static final long serialVersionUID = 9035584745289937584L;
    protected Stack states = new Stack();
    protected Stack conds = new Stack();

    public static void main(String[] args) {
        BlockStatments c = new BlockStatments();
        c.run(args);
    }

    public boolean testSpecialCommands(String command) {
        String trim = command.trim();
        if (trim.startsWith("IF ")) {
            String tail = trim.substring(3);
            try {
                Node n = this.j.parse(tail);
                Object res = this.j.evaluate(n);
                if (res instanceof Boolean && ((Boolean)res).booleanValue() || res instanceof Number && ((Number)res).intValue() != 0) {
                    this.conds.push(Boolean.TRUE);
                } else {
                    this.conds.push(Boolean.FALSE);
                }
                this.states.push(Boolean.TRUE);
                return false;
            }
            catch (ParseException e) {
                this.handleError((Exception)((Object)e));
            }
        }
        if (command.equals("ELSE")) {
            this.states.pop();
            this.states.push(Boolean.FALSE);
            return false;
        }
        if (command.equals("ENDIF")) {
            if (this.states.isEmpty()) {
                this.println((Object)"ERROR: Too many ENDIF statements");
            }
            this.states.pop();
            this.conds.pop();
            return false;
        }
        if (command.equals("states")) {
            this.print((Object)"STATES: ");
            int i = 0;
            while (i < this.states.size()) {
                if (((Boolean)this.states.elementAt(i)).booleanValue()) {
                    this.print((Object)"T");
                } else {
                    this.print((Object)"F");
                }
                ++i;
            }
            this.println((Object)"");
            this.print((Object)"CONDS:  ");
            i = 0;
            while (i < this.conds.size()) {
                if (((Boolean)this.conds.elementAt(i)).booleanValue()) {
                    this.print((Object)"T");
                } else {
                    this.print((Object)"F");
                }
                ++i;
            }
            this.println((Object)"");
            return false;
        }
        return true;
    }

    public void processEquation(Node node) throws ParseException {
        int i = 0;
        while (i < this.states.size()) {
            if (!this.states.elementAt(i).equals(this.conds.elementAt(i))) {
                this.println((Object)"skipped");
                return;
            }
            ++i;
        }
        Object res = this.j.evaluate(node);
        this.println(res);
    }

    public void printIntroText() {
        this.println((Object)"JEP Console with basic IF ELSE ENDIF nested block structure.");
        this.printStdHelp();
    }

    public String getPrompt() {
        StringBuffer sb = new StringBuffer("JEP ");
        int i = 0;
        while (i < this.states.size()) {
            sb.append(' ');
            ++i;
        }
        sb.append("> ");
        return sb.toString();
    }

    public void printHelp() {
        super.printHelp();
        this.println((Object)"'IF condition' begins a (true) block");
        this.println((Object)"'ELSE' begins a false block");
        this.println((Object)"'ENDIF' ends a block");
        this.println((Object)"'states' shows the current states and conditions");
    }
}

