/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.VMap;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.PostfixMathCommand;

public class GenMat
extends PostfixMathCommand
implements CallbackEvaluationI {
    public GenMat() {
        this.numberOfParameters = -1;
    }

    public boolean checkNumberOfParameters(int n) {
        return n == 2 || n == 3;
    }

    public Object evaluate(Node node, EvaluatorI pv) throws ParseException {
        int i;
        Object sizeObj = pv.eval(node.jjtGetChild(0));
        int[] sizes = null;
        if (sizeObj instanceof Scaler) {
            sizes = new int[]{((Number)sizeObj).intValue()};
        } else if (sizeObj instanceof MVector) {
            MVector vec = (MVector)sizeObj;
            int n = vec.getNumEles();
            sizes = new int[n];
            i = 0;
            while (i < n) {
                sizes[i] = ((Number)vec.getEle(i)).intValue();
                ++i;
            }
        } else {
            if (sizeObj instanceof MatrixValueI) {
                throw new ParseException("GenMat: First arg should be scaler or vector");
            }
            sizes = new int[]{((Number)sizeObj).intValue()};
        }
        Dimensions dim = Dimensions.valueOf((int[])sizes);
        MatrixValueI res = Tensor.getInstance((Dimensions)dim);
        if (node.jjtGetNumChildren() == 2) {
            i = 0;
            while (i < res.getNumEles()) {
                Object val = pv.eval(node.jjtGetChild(1));
                res.setEle(i, val);
                ++i;
            }
            return res;
        }
        Variable[] vars = VMap.getVars((Node)node.jjtGetChild(2));
        if (vars.length != sizes.length) {
            throw new ParseException("GenMat: number of variables must match number of dimensions");
        }
        if (vars.length == 1) {
            int i2 = 0;
            while (i2 < sizes[0]) {
                vars[0].setValue((Object)new Integer(i2 + 1));
                Object val = pv.eval(node.jjtGetChild(1));
                res.setEle(i2, val);
                ++i2;
            }
            return res;
        }
        if (vars.length == 2) {
            Matrix mat = (Matrix)res;
            int i3 = 0;
            while (i3 < sizes[0]) {
                vars[0].setValue((Object)new Integer(i3 + 1));
                int j = 0;
                while (j < sizes[1]) {
                    vars[1].setValue((Object)new Integer(j + 1));
                    Object val = pv.eval(node.jjtGetChild(1));
                    mat.setEle(i3, j, val);
                    ++j;
                }
                ++i3;
            }
            return res;
        }
        throw new ParseException("GenMat: can currently only generate vectors and matrices");
    }
}

