/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class PConstant
extends AbstractPNode {
    Object value;

    public PConstant(PolynomialCreator pc, Object o) {
        super(pc);
        this.value = o;
    }

    public PNodeI negate() throws ParseException {
        return new PConstant(this.pc, this.pc.neg(this.value));
    }

    public PNodeI add(PNodeI c) throws ParseException {
        if (this.isZero()) {
            return c;
        }
        if (c instanceof PConstant) {
            return new PConstant(this.pc, this.pc.add(this.value, ((PConstant)c).value));
        }
        return super.add(c);
    }

    public PNodeI sub(PNodeI c) throws ParseException {
        if (this.isZero()) {
            return c.negate();
        }
        if (c instanceof PConstant) {
            return new PConstant(this.pc, this.pc.sub(this.value, ((PConstant)c).value));
        }
        return super.sub(c);
    }

    public PNodeI mul(PNodeI c) throws ParseException {
        if (this.isZero()) {
            return this.pc.zeroConstant;
        }
        if (this.isOne()) {
            return c;
        }
        if (c.isZero()) {
            return this.pc.zeroConstant;
        }
        if (c.isOne()) {
            return this;
        }
        if (c instanceof PConstant) {
            return new PConstant(this.pc, this.pc.mul(this.value, ((PConstant)c).value));
        }
        return super.mul(c);
    }

    public PNodeI div(PNodeI c) throws ParseException {
        if (this.isZero()) {
            if (c.isZero()) {
                return this.pc.nanConstant;
            }
            return this.pc.zeroConstant;
        }
        if (c.isZero()) {
            return this.pc.infConstant;
        }
        if (c.isOne()) {
            return this;
        }
        if (c instanceof PConstant) {
            return new PConstant(this.pc, this.pc.div(this.value, ((PConstant)c).value));
        }
        return super.div(c);
    }

    public PNodeI invert() throws ParseException {
        return new PConstant(this.pc, this.pc.div(this.pc.one, this.value));
    }

    public PNodeI pow(PNodeI c) throws ParseException {
        if (this.isZero()) {
            if (c.isZero()) {
                return this.pc.nanConstant;
            }
            return this.pc.zeroConstant;
        }
        if (this.isOne()) {
            return this.pc.oneConstant;
        }
        if (c.isZero()) {
            return this.pc.oneConstant;
        }
        if (c instanceof PConstant) {
            return new PConstant(this.pc, this.pc.raise(this.value, ((PConstant)c).value));
        }
        return super.pow(c);
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isOne()) {
            return "1";
        }
        if (this.isInfinity()) {
            return "inf";
        }
        if (this.isNan()) {
            return "NaN";
        }
        if (this.isInteger()) {
            return String.valueOf(this.intValue());
        }
        return this.value.toString();
    }

    public boolean isZero() {
        return this.value.equals(this.pc.zero);
    }

    public boolean isOne() {
        return this.value.equals(this.pc.one);
    }

    public boolean isMinusOne() {
        return this.value.equals(this.pc.minusOne);
    }

    public boolean isInfinity() {
        if (this.value.equals(this.pc.infinity)) {
            return true;
        }
        if (this.value instanceof Double) {
            return ((Double)this.value).isInfinite();
        }
        if (this.value instanceof Complex) {
            return ((Complex)this.value).isInfinite();
        }
        return false;
    }

    public boolean isNan() {
        if (this.value.equals(this.pc.nan)) {
            return true;
        }
        if (this.value instanceof Double) {
            return ((Double)this.value).isNaN();
        }
        if (this.value instanceof Complex) {
            return ((Complex)this.value).isNaN();
        }
        return false;
    }

    public boolean isPositive() {
        try {
            return ((Double)this.value).compareTo((Double)this.pc.zero) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isNegative() {
        try {
            return ((Double)this.value).compareTo((Double)this.pc.zero) < 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isInteger() {
        try {
            double val = (Double)this.value;
            return val == Math.floor(val);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int intValue() {
        return ((Number)this.value).intValue();
    }

    public Node toNode() throws ParseException {
        return this.pc.nf.buildConstantNode(this.value);
    }

    public int compareTo(PConstant c) {
        return ((Comparable)this.value).compareTo(c.value);
    }

    public boolean equals(PNodeI node) {
        if (node instanceof PConstant) {
            return this.value.equals(((PConstant)node).value);
        }
        return false;
    }

    public PNodeI expand() {
        return this;
    }

    public Object getValue() {
        return this.value;
    }
}

