/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.MutiableMonomial;
import org.lsmp.djep.sjep.MutiablePolynomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PFunction;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PVariable;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Monomial
extends AbstractPNode {
    PConstant coeff;
    PNodeI[] vars;
    PNodeI[] powers;

    Monomial(PolynomialCreator pc, PConstant coeff, PNodeI[] vars, PNodeI[] powers) {
        super(pc);
        if (vars.length != powers.length) {
            throw new IllegalArgumentException("Monomial.valueOf length of variables and powers must be equal. they are " + vars.length + " " + powers.length);
        }
        this.coeff = coeff;
        this.vars = vars;
        this.powers = powers;
    }

    Monomial(PolynomialCreator pc, PConstant coeff, PNodeI var) {
        super(pc);
        this.coeff = coeff;
        this.vars = new PNodeI[]{var};
        this.powers = new PNodeI[]{pc.oneConstant};
    }

    Monomial(PolynomialCreator pc, PConstant coeff, PNodeI var, PNodeI power) {
        super(pc);
        this.coeff = coeff;
        this.vars = new PNodeI[]{var};
        this.powers = new PNodeI[]{power};
    }

    PNodeI valueOf(PConstant coefficient, PNodeI[] terms, PNodeI[] pows) {
        if (coefficient.isZero()) {
            return this.pc.zeroConstant;
        }
        if (terms.length == 0) {
            return coefficient;
        }
        return new Monomial(this.pc, coefficient, terms, pows);
    }

    MutiableMonomial toMutiableMonomial() {
        PNodeI[] newTerms = new PNodeI[this.vars.length];
        PNodeI[] newPows = new PNodeI[this.vars.length];
        int i = 0;
        while (i < this.vars.length) {
            newTerms[i] = this.vars[i];
            newPows[i] = this.powers[i];
            ++i;
        }
        return new MutiableMonomial(this.pc, this.coeff, newTerms, newPows);
    }

    public PNodeI mul(PNodeI node) throws ParseException {
        if (node instanceof PConstant) {
            return this.valueOf((PConstant)this.coeff.mul(node), this.vars, this.powers);
        }
        if (node instanceof Monomial) {
            return this.mul((Monomial)node);
        }
        MutiableMonomial mm = this.toMutiableMonomial();
        mm.mul(node, (PNodeI)this.pc.oneConstant);
        return mm.toPNode();
    }

    public PNodeI div(PNodeI node) throws ParseException {
        if (node instanceof PConstant) {
            return this.valueOf((PConstant)this.coeff.div(node), this.vars, this.powers);
        }
        if (node instanceof Monomial) {
            return this.div((Monomial)node);
        }
        MutiableMonomial mm = this.toMutiableMonomial();
        mm.mul(node, (PNodeI)this.pc.minusOneConstant);
        return mm.toPNode();
    }

    PNodeI mul(Monomial m) throws ParseException {
        MutiableMonomial mm = this.toMutiableMonomial();
        mm.mul(m.coeff);
        int i = 0;
        while (i < m.vars.length) {
            mm.mul(m.vars[i], m.powers[i]);
            ++i;
        }
        return mm.toPNode();
    }

    PNodeI div(Monomial m) throws ParseException {
        MutiableMonomial mm = this.toMutiableMonomial();
        mm.div(m.coeff);
        int i = 0;
        while (i < this.vars.length) {
            mm.mul(m.vars[i], m.powers[i].negate());
            ++i;
        }
        return mm.toPNode();
    }

    public PNodeI pow(PNodeI pow) throws ParseException {
        if (pow instanceof PConstant) {
            MutiableMonomial mm = this.toMutiableMonomial();
            mm.power((PConstant)pow);
            return mm.toPNode();
        }
        return super.pow(pow);
    }

    public PNodeI negate() throws ParseException {
        return new Monomial(this.pc, (PConstant)this.coeff.negate(), this.vars, this.powers);
    }

    public PNodeI invert() throws ParseException {
        PNodeI[] newPows = new PNodeI[this.vars.length];
        int i = 0;
        while (i < this.vars.length) {
            newPows[i] = this.powers[i].negate();
            ++i;
        }
        return new Monomial(this.pc, (PConstant)this.coeff.invert(), this.vars, newPows);
    }

    public PNodeI add(PNodeI node) throws ParseException {
        Monomial mon;
        if (node instanceof PVariable && this.equalsIgnoreConstant(node)) {
            return this.valueOf((PConstant)this.coeff.add((PNodeI)this.pc.oneConstant), this.vars, this.powers);
        }
        if (node instanceof Monomial && this.equalsIgnoreConstant(mon = (Monomial)node)) {
            return this.valueOf((PConstant)this.coeff.add((PNodeI)mon.coeff), this.vars, this.powers);
        }
        return super.add(node);
    }

    public PNodeI sub(PNodeI node) throws ParseException {
        Monomial mon;
        if (node instanceof PVariable && this.equalsIgnoreConstant(node)) {
            return this.valueOf((PConstant)this.coeff.sub((PNodeI)this.pc.oneConstant), this.vars, this.powers);
        }
        if (node instanceof Monomial && this.equalsIgnoreConstant(mon = (Monomial)node)) {
            return this.valueOf((PConstant)this.coeff.sub((PNodeI)mon.coeff), this.vars, this.powers);
        }
        return super.sub(node);
    }

    PNodeI addConstant(PConstant c) throws ParseException {
        return this.valueOf((PConstant)this.coeff.add((PNodeI)c), this.vars, this.powers);
    }

    public boolean equals(PNodeI node) {
        if (!(node instanceof Monomial)) {
            return false;
        }
        if (!this.coeff.equals((PNodeI)((Monomial)node).coeff)) {
            return false;
        }
        return this.equalsIgnoreConstant((Monomial)node);
    }

    boolean equalsIgnoreConstant(Monomial mon) {
        if (this.vars.length != mon.vars.length) {
            return false;
        }
        int i = 0;
        while (i < this.vars.length) {
            if (!this.vars[i].equals(mon.vars[i])) {
                return false;
            }
            if (!this.powers[i].equals(mon.powers[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean equalsIgnoreConstant(PNodeI node) {
        if (node instanceof Monomial) {
            return this.equalsIgnoreConstant((Monomial)node);
        }
        if (this.vars.length != 1) {
            return false;
        }
        if (!this.vars[0].equals(node)) {
            return false;
        }
        return this.powers[0].isOne();
    }

    public int compareTo(PNodeI node) {
        if (node instanceof PConstant) {
            return 1;
        }
        if (node instanceof Monomial) {
            Monomial mon = (Monomial)node;
            int i = 0;
            while (i < this.vars.length) {
                if (i >= mon.vars.length) {
                    return 1;
                }
                int res = this.vars[i].compareTo(mon.vars[i]);
                if (res != 0) {
                    return res;
                }
                res = this.powers[i].compareTo(mon.powers[i]);
                if (res != 0) {
                    return res;
                }
                ++i;
            }
            if (this.vars.length > mon.vars.length) {
                return 1;
            }
            if (this.vars.length < mon.vars.length) {
                return -1;
            }
            return this.coeff.compareTo(mon.coeff);
        }
        int res = this.vars[0].compareTo(node);
        if (res == 0) {
            res = this.powers[0].compareTo((PNodeI)this.pc.oneConstant);
        }
        return res;
    }

    private boolean negativePower(PNodeI pow) {
        return pow instanceof PConstant && ((PConstant)pow).isNegative();
    }

    private void printPower(StringBuffer sb, PNodeI pow) {
        if (pow.isOne()) {
            return;
        }
        if (pow instanceof PConstant || pow instanceof PVariable || pow instanceof PFunction) {
            sb.append('^');
            sb.append(pow.toString());
        } else {
            sb.append("^(");
            sb.append(pow.toString());
            sb.append(")");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean flag = false;
        if (this.coeff.isMinusOne()) {
            sb.append('-');
        } else if (!this.coeff.isOne()) {
            sb.append(this.coeff.toString());
            flag = true;
        }
        int numNeg = 0;
        int i = 0;
        while (i < this.vars.length) {
            if (this.negativePower(this.powers[i])) {
                ++numNeg;
            } else {
                if (flag) {
                    sb.append('*');
                }
                if (this.vars[i] instanceof Polynomial) {
                    sb.append('(');
                    sb.append(this.vars[i].toString());
                    sb.append(')');
                } else {
                    sb.append(this.vars[i].toString());
                }
                this.printPower(sb, this.powers[i]);
                flag = true;
            }
            ++i;
        }
        if (numNeg > 0) {
            if (!flag) {
                sb.append('1');
            }
            if (numNeg > 1) {
                sb.append("/(");
            } else {
                sb.append("/");
            }
            flag = false;
            i = 0;
            while (i < this.vars.length) {
                if (this.negativePower(this.powers[i])) {
                    if (flag) {
                        sb.append('*');
                    }
                    if (this.vars[i] instanceof Polynomial) {
                        sb.append('(');
                        sb.append(this.vars[i].toString());
                        sb.append(')');
                    } else {
                        sb.append(this.vars[i].toString());
                    }
                    try {
                        this.printPower(sb, this.powers[i].negate());
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    flag = true;
                }
                ++i;
            }
            if (numNeg > 1) {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public Node toNode() throws ParseException {
        int nCoeff = this.coeff.isOne() ? 0 : 1;
        int numDivisors = 0;
        int i = 0;
        while (i < this.vars.length) {
            if (this.negativePower(this.powers[i])) {
                ++numDivisors;
            }
            ++i;
        }
        Node[] args = new Node[nCoeff + this.vars.length - numDivisors];
        int pos = 0;
        if (nCoeff > 0) {
            args[pos++] = this.coeff.toNode();
        }
        int i2 = 0;
        while (i2 < this.vars.length) {
            if (!this.negativePower(this.powers[i2])) {
                args[pos++] = this.powers[i2].isOne() ? this.vars[i2].toNode() : this.pc.nf.buildOperatorNode(this.pc.os.getPower(), this.vars[i2].toNode(), this.powers[i2].toNode());
            }
            ++i2;
        }
        Object top = args.length == 0 ? this.coeff.toNode() : (args.length == 1 ? args[0] : this.pc.nf.buildOperatorNode(this.pc.os.getMultiply(), args));
        if (numDivisors == 0) {
            return top;
        }
        Node[] divisors = new Node[numDivisors];
        pos = 0;
        int i3 = 0;
        while (i3 < this.vars.length) {
            if (this.negativePower(this.powers[i3])) {
                PNodeI pow = this.powers[i3].negate();
                divisors[pos++] = this.powers[i3] instanceof PConstant && ((PConstant)this.powers[i3]).isMinusOne() ? this.vars[i3].toNode() : this.pc.nf.buildOperatorNode(this.pc.os.getPower(), this.vars[i3].toNode(), pow.toNode());
            }
            ++i3;
        }
        Object bottom = divisors.length == 1 ? divisors[0] : this.pc.nf.buildOperatorNode(this.pc.os.getMultiply(), divisors);
        return this.pc.nf.buildOperatorNode(this.pc.os.getDivide(), top, bottom);
    }

    boolean negativeCoefficient() {
        return this.coeff.isNegative();
    }

    public PNodeI expand() throws ParseException {
        MutiablePolynomial mp = new MutiablePolynomial(this.pc, new PNodeI[]{this.coeff});
        int i = 0;
        while (i < this.vars.length) {
            if (this.powers[i] instanceof PConstant) {
                PConstant pow = (PConstant)this.powers[i];
                if (!pow.isZero()) {
                    if (pow.isOne()) {
                        mp.expandMul(this.vars[i].expand());
                    } else if (pow.isInteger()) {
                        int intpow = pow.intValue();
                        if (intpow > 0) {
                            PNodeI res = this.vars[i].expand();
                            int j = 1;
                            while (j <= intpow) {
                                mp.expandMul(res);
                                ++j;
                            }
                        } else {
                            mp.expandMul((PNodeI)new Monomial(this.pc, this.pc.oneConstant, this.vars[i].expand(), this.powers[i]));
                        }
                    }
                }
            } else {
                mp.expandMul((PNodeI)new Monomial(this.pc, this.pc.oneConstant, this.vars[i].expand(), this.powers[i]));
            }
            ++i;
        }
        return mp.toPNode();
    }

    public PConstant getCoeff() {
        return this.coeff;
    }

    public int getNVars() {
        return this.vars.length;
    }

    public PNodeI getVar(int i) {
        return this.vars[i];
    }

    public PNodeI getPower(int i) {
        return this.powers[i];
    }
}

