/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.matrixJep;

import java.util.Stack;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixSpecialEvaluationI;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMConstant;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.Comparative;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.SpecialEvaluationI;

public class MatrixEvaluator
implements ParserVisitor,
EvaluatorI {
    private Stack stack = new Stack();
    private MatrixJep mjep;

    public MatrixValueI evaluate(MatrixNodeI node, MatrixJep mj) throws ParseException {
        this.mjep = mj;
        return (MatrixValueI)node.jjtAccept((ParserVisitor)this, null);
    }

    public Object eval(Node node) throws ParseException {
        MatrixValueI val = (MatrixValueI)node.jjtAccept((ParserVisitor)this, null);
        return val.copy();
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public Object visit(ASTStart node, Object data) {
        return null;
    }

    public Object visit(ASTConstant node, Object data) {
        return ((ASTMConstant)node).getMValue();
    }

    public Object visit(ASTVarNode node, Object data) throws ParseException {
        MatrixVariableI var = (MatrixVariableI)node.getVar();
        if (var.hasValidValue()) {
            return var.getMValue();
        }
        if (!var.hasEquation()) {
            throw new ParseException("Tried to evaluate a variable with an invalid value but no equation");
        }
        MatrixValueI res = (MatrixValueI)var.getEquation().jjtAccept((ParserVisitor)this, data);
        var.setMValue(res);
        return res;
    }

    public Object visit(ASTFunNode node, Object data) throws ParseException {
        MatrixNodeI mnode = (MatrixNodeI)node;
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc instanceof MatrixSpecialEvaluationI) {
            MatrixSpecialEvaluationI se = (MatrixSpecialEvaluationI)pfmc;
            return se.evaluate(mnode, this, this.mjep);
        }
        if (pfmc instanceof CallbackEvaluationI) {
            Object val = ((CallbackEvaluationI)pfmc).evaluate((Node)node, (EvaluatorI)this);
            if (val instanceof MatrixValueI) {
                mnode.getMValue().setEles((MatrixValueI)val);
            } else {
                mnode.getMValue().setEle(0, val);
            }
            return mnode.getMValue();
        }
        if (pfmc instanceof SpecialEvaluationI) {
            throw new ParseException("Encountered an instance of SpecialEvaluationI");
        }
        if (pfmc instanceof BinaryOperatorI) {
            BinaryOperatorI bin = (BinaryOperatorI)pfmc;
            MatrixValueI lhsval = (MatrixValueI)node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
            MatrixValueI rhsval = (MatrixValueI)node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
            return bin.calcValue(mnode.getMValue(), lhsval, rhsval);
        }
        if (pfmc instanceof UnaryOperatorI) {
            UnaryOperatorI uni = (UnaryOperatorI)pfmc;
            MatrixValueI val = (MatrixValueI)node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
            return uni.calcValue(mnode.getMValue(), val);
        }
        if (pfmc instanceof NaryOperatorI) {
            NaryOperatorI uni = (NaryOperatorI)pfmc;
            MatrixValueI[] results = new MatrixValueI[node.jjtGetNumChildren()];
            int i = 0;
            while (i < results.length) {
                results[i] = (MatrixValueI)node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
                ++i;
            }
            return uni.calcValue(mnode.getMValue(), results);
        }
        if (pfmc instanceof Comparative) {
            MatrixValueI lhsval = (MatrixValueI)node.jjtGetChild(0).jjtAccept((ParserVisitor)this, data);
            MatrixValueI rhsval = (MatrixValueI)node.jjtGetChild(1).jjtAccept((ParserVisitor)this, data);
            this.stack.push(lhsval);
            this.stack.push(rhsval);
            pfmc.setCurNumberOfParameters(2);
            pfmc.run(this.stack);
            mnode.getMValue().setEle(0, this.stack.pop());
            return mnode.getMValue();
        }
        int num = node.jjtGetNumChildren();
        int i = 0;
        while (i < num) {
            MatrixValueI vec = (MatrixValueI)node.jjtGetChild(i).jjtAccept((ParserVisitor)this, data);
            if (!vec.getDim().equals(Dimensions.ONE)) {
                throw new ParseException("Arguments of " + node.getName() + " must be scalers");
            }
            this.stack.push(vec.getEle(0));
            ++i;
        }
        pfmc.setCurNumberOfParameters(num);
        pfmc.run(this.stack);
        mnode.getMValue().setEle(0, this.stack.pop());
        return mnode.getMValue();
    }
}

