/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.values;

import org.lsmp.djep.groupJep.GroupJep;
import org.lsmp.djep.groupJep.interfaces.HasDivI;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.nfunk.jep.type.Complex;

public class Polynomial
extends Number {
    private RingI baseRing;
    private String symbol;
    private Number[] coeffs;
    private int degree;

    public Polynomial(RingI baseRing, String symbol, Number[] coeffs) {
        this.baseRing = baseRing;
        this.symbol = symbol;
        int deg = 0;
        int i = coeffs.length - 1;
        while (i > 0) {
            if (!baseRing.equals(coeffs[i], baseRing.getZERO())) {
                deg = i;
                break;
            }
            --i;
        }
        if (deg == coeffs.length - 1) {
            this.coeffs = coeffs;
        } else {
            this.coeffs = new Number[deg + 1];
            System.arraycopy(coeffs, 0, this.coeffs, 0, deg + 1);
        }
        this.degree = deg;
    }

    protected void setCoeffs(Number[] coeffs) {
        this.coeffs = coeffs;
        this.degree = coeffs.length - 1;
    }

    protected Polynomial valueOf(Number[] lcoeffs) {
        Polynomial p = new Polynomial(this.baseRing, this.symbol, lcoeffs);
        return p;
    }

    public Polynomial add(Polynomial poly) {
        int deg = this.degree > poly.degree ? this.degree : poly.degree;
        Number[] lcoeffs = new Number[deg + 1];
        int i = 0;
        while (i <= deg) {
            lcoeffs[i] = i <= this.degree && i <= poly.degree ? (Number)this.baseRing.add(this.coeffs[i], poly.coeffs[i]) : (Number)(i <= this.degree ? (Number)this.coeffs[i] : (Number)poly.coeffs[i]);
            ++i;
        }
        return this.valueOf(lcoeffs);
    }

    public Polynomial sub(Polynomial poly) {
        int deg = this.degree > poly.degree ? this.degree : poly.degree;
        Number[] lcoeffs = new Number[deg + 1];
        int i = 0;
        while (i <= deg) {
            lcoeffs[i] = i <= this.degree && i <= poly.degree ? (Number)this.baseRing.sub(this.coeffs[i], poly.coeffs[i]) : (Number)(i <= this.degree ? (Number)this.coeffs[i] : (Number)this.baseRing.getInverse(poly.coeffs[i]));
            ++i;
        }
        return this.valueOf(lcoeffs);
    }

    public Polynomial mul(Polynomial poly) {
        int deg = this.degree + poly.degree;
        Number[] lcoeffs = new Number[deg + 1];
        int i = 0;
        while (i <= deg) {
            lcoeffs[i] = this.baseRing.getZERO();
            ++i;
        }
        i = 0;
        while (i <= this.degree) {
            int j = 0;
            while (j <= poly.degree) {
                lcoeffs[i + j] = this.baseRing.add(lcoeffs[i + j], this.baseRing.mul(this.coeffs[i], poly.coeffs[j]));
                ++j;
            }
            ++i;
        }
        return this.valueOf(lcoeffs);
    }

    public Polynomial div(Polynomial poly) {
        if (!poly.isConstantPoly()) {
            throw new IllegalArgumentException("Can currently only divide by numbers and not polynomials");
        }
        int deg = this.coeffs.length - 1;
        Number[] lcoeffs = new Number[deg + 1];
        int i = 0;
        while (i < deg + 1) {
            lcoeffs[i] = ((HasDivI)this.baseRing).div(this.coeffs[i], poly.getCoeff(0));
            ++i;
        }
        return this.valueOf(lcoeffs);
    }

    public Polynomial pow(int exp) {
        if (exp == 0) {
            return this.valueOf(new Number[]{this.baseRing.getONE()});
        }
        if (exp == 1) {
            return this.valueOf(this.getCoeffs());
        }
        if (exp < 0) {
            throw new IllegalArgumentException("Tried to raise a Polynomial to a negative power");
        }
        Polynomial res = this.valueOf(new Number[]{this.baseRing.getONE()});
        Polynomial currentPower = this;
        while (exp != 0) {
            if ((exp & 1) == 1) {
                res = res.mul(currentPower);
            }
            if ((exp >>= 1) == 0) break;
            currentPower = currentPower.mul(currentPower);
        }
        return res;
    }

    private boolean needsBrackets(String s) {
        int i1 = s.indexOf(43);
        int i2 = s.lastIndexOf(45);
        return i1 != -1 || i2 > 0;
    }

    public String toString() {
        if (this.degree == 0) {
            return this.coeffs[0].toString();
        }
        StringBuffer sb = new StringBuffer("");
        int i = this.degree;
        while (i >= 0) {
            String s = this.coeffs[i].toString();
            if (!s.equals("0") && !this.baseRing.equals(this.coeffs[i], this.baseRing.getZERO())) {
                if (i != this.degree && !s.startsWith("-")) {
                    sb.append("+");
                }
                if (i == 0) {
                    String s1 = this.coeffs[i].toString();
                    sb.append(s1);
                    break;
                }
                if (s.equals("-1")) {
                    sb.append("-");
                } else if (!s.equals("1") && !this.baseRing.equals(this.coeffs[i], this.baseRing.getONE())) {
                    if (this.needsBrackets(this.coeffs[i].toString())) {
                        sb.append("(");
                        sb.append(this.coeffs[i].toString());
                        sb.append(")");
                    } else {
                        sb.append(this.coeffs[i].toString());
                    }
                    sb.append(" ");
                }
                if (i >= 2) {
                    sb.append(String.valueOf(this.symbol) + "^" + i);
                } else if (i == 1) {
                    sb.append(this.symbol);
                }
            }
            --i;
        }
        sb.append("");
        return sb.toString();
    }

    public int getDegree() {
        return this.degree;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Number[] getCoeffs() {
        return this.coeffs;
    }

    public Number getCoeff(int i) {
        return this.coeffs[i];
    }

    public RingI getBaseRing() {
        return this.baseRing;
    }

    public int intValue() {
        return this.coeffs[0].intValue();
    }

    public long longValue() {
        return this.coeffs[0].longValue();
    }

    public float floatValue() {
        return this.coeffs[0].floatValue();
    }

    public double doubleValue() {
        return this.coeffs[0].doubleValue();
    }

    public boolean isConstantPoly() {
        if (this.coeffs.length > 1) {
            return false;
        }
        return this.baseRing.isConstantPoly(this.coeffs[0]);
    }

    public boolean equals(Polynomial n) {
        if (this.getDegree() != n.getDegree()) {
            return false;
        }
        int i = 0;
        while (i <= this.getDegree()) {
            if (!this.baseRing.equals(this.getCoeff(i), n.getCoeff(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Complex calculateComplexValue(Complex rootVal) {
        Number val = this.coeffs[this.getDegree()];
        Complex cval = GroupJep.complexValueOf((Object)val);
        int i = this.getDegree() - 1;
        while (i >= 0) {
            Number val2 = this.coeffs[i];
            Complex cval2 = GroupJep.complexValueOf((Object)val2);
            Complex prod = cval.mul(rootVal);
            cval = prod.add(cval2);
            --i;
        }
        return cval;
    }

    public Number calculateValue(Number rootVal) {
        Number val = this.coeffs[this.getDegree()];
        int i = this.getDegree() - 1;
        while (i >= 0) {
            Number val2 = this.coeffs[i];
            Number prod = this.baseRing.mul(val, rootVal);
            val = this.baseRing.add(prod, val2);
            --i;
        }
        return val;
    }
}

