/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import java.io.Serializable;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.transform.FastFourierTransformer;

/*
 * Exception performing whole class analysis ignored.
 */
public class FastFourierTransformer
implements Serializable {
    static final long serialVersionUID = 5138259215438106000L;
    private static final String NOT_POWER_OF_TWO_MESSAGE = "{0} is not a power of 2, consider padding for fix";
    private static final String DIMENSION_MISMATCH_MESSAGE = "some dimensions don't match: {0} != {1}";
    private static final String MISSING_ROOTS_OF_UNITY_MESSAGE = "roots of unity have not been computed yet";
    private static final String OUT_OF_RANGE_ROOT_INDEX_MESSAGE = "out of range root of unity index {0} (must be in [{1};{2}])";
    private RootsOfUnity roots = new RootsOfUnity();

    public Complex[] transform(double[] f) throws IllegalArgumentException {
        return this.fft(f, false);
    }

    public Complex[] transform(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample((UnivariateRealFunction)f, (double)min, (double)max, (int)n);
        return this.fft(data, false);
    }

    public Complex[] transform(Complex[] f) throws IllegalArgumentException {
        this.roots.computeOmega(f.length);
        return this.fft(f);
    }

    public Complex[] transform2(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = 1.0 / Math.sqrt(f.length);
        return FastFourierTransformer.scaleArray((Complex[])this.fft(f, false), (double)scaling_coefficient);
    }

    public Complex[] transform2(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample((UnivariateRealFunction)f, (double)min, (double)max, (int)n);
        double scaling_coefficient = 1.0 / Math.sqrt(n);
        return FastFourierTransformer.scaleArray((Complex[])this.fft(data, false), (double)scaling_coefficient);
    }

    public Complex[] transform2(Complex[] f) throws IllegalArgumentException {
        this.roots.computeOmega(f.length);
        double scaling_coefficient = 1.0 / Math.sqrt(f.length);
        return FastFourierTransformer.scaleArray((Complex[])this.fft(f), (double)scaling_coefficient);
    }

    public Complex[] inversetransform(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = 1.0 / (double)f.length;
        return FastFourierTransformer.scaleArray((Complex[])this.fft(f, true), (double)scaling_coefficient);
    }

    public Complex[] inversetransform(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample((UnivariateRealFunction)f, (double)min, (double)max, (int)n);
        double scaling_coefficient = 1.0 / (double)n;
        return FastFourierTransformer.scaleArray((Complex[])this.fft(data, true), (double)scaling_coefficient);
    }

    public Complex[] inversetransform(Complex[] f) throws IllegalArgumentException {
        this.roots.computeOmega(-f.length);
        double scaling_coefficient = 1.0 / (double)f.length;
        return FastFourierTransformer.scaleArray((Complex[])this.fft(f), (double)scaling_coefficient);
    }

    public Complex[] inversetransform2(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = 1.0 / Math.sqrt(f.length);
        return FastFourierTransformer.scaleArray((Complex[])this.fft(f, true), (double)scaling_coefficient);
    }

    public Complex[] inversetransform2(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample((UnivariateRealFunction)f, (double)min, (double)max, (int)n);
        double scaling_coefficient = 1.0 / Math.sqrt(n);
        return FastFourierTransformer.scaleArray((Complex[])this.fft(data, true), (double)scaling_coefficient);
    }

    public Complex[] inversetransform2(Complex[] f) throws IllegalArgumentException {
        this.roots.computeOmega(-f.length);
        double scaling_coefficient = 1.0 / Math.sqrt(f.length);
        return FastFourierTransformer.scaleArray((Complex[])this.fft(f), (double)scaling_coefficient);
    }

    protected Complex[] fft(double[] f, boolean isInverse) throws IllegalArgumentException {
        FastFourierTransformer.verifyDataSet((double[])f);
        Complex[] F = new Complex[f.length];
        if (f.length == 1) {
            F[0] = new Complex(f[0], 0.0);
            return F;
        }
        int N = f.length >> 1;
        Complex[] c = new Complex[N];
        for (int i = 0; i < N; ++i) {
            c[i] = new Complex(f[2 * i], f[2 * i + 1]);
        }
        this.roots.computeOmega(isInverse ? -N : N);
        Complex[] z = this.fft(c);
        this.roots.computeOmega(isInverse ? -2 * N : 2 * N);
        F[0] = new Complex(2.0 * (z[0].getReal() + z[0].getImaginary()), 0.0);
        F[N] = new Complex(2.0 * (z[0].getReal() - z[0].getImaginary()), 0.0);
        for (int i = 1; i < N; ++i) {
            Complex A = z[N - i].conjugate();
            Complex B = z[i].add(A);
            Complex C = z[i].subtract(A);
            Complex D = new Complex(-this.roots.getOmegaImaginary(i), this.roots.getOmegaReal(i));
            F[i] = B.subtract(C.multiply(D));
            F[2 * N - i] = F[i].conjugate();
        }
        return FastFourierTransformer.scaleArray((Complex[])F, (double)0.5);
    }

    protected Complex[] fft(Complex[] data) throws IllegalArgumentException {
        int i;
        int n = data.length;
        Complex[] f = new Complex[n];
        FastFourierTransformer.verifyDataSet((Object[])data);
        if (n == 1) {
            f[0] = data[0];
            return f;
        }
        if (n == 2) {
            f[0] = data[0].add(data[1]);
            f[1] = data[0].subtract(data[1]);
            return f;
        }
        int ii = 0;
        for (i = 0; i < n; ++i) {
            int k;
            f[i] = data[ii];
            for (k = n >> 1; ii >= k && k > 0; ii -= k, k >>= 1) {
            }
            ii += k;
        }
        for (i = 0; i < n; i += 4) {
            Complex a = f[i].add(f[i + 1]);
            Complex b = f[i + 2].add(f[i + 3]);
            Complex c = f[i].subtract(f[i + 1]);
            Complex d = f[i + 2].subtract(f[i + 3]);
            Complex e1 = c.add(d.multiply(Complex.I));
            Complex e2 = c.subtract(d.multiply(Complex.I));
            f[i] = a.add(b);
            f[i + 2] = a.subtract(b);
            f[i + 1] = this.roots.isForward() ? e2 : e1;
            f[i + 3] = this.roots.isForward() ? e1 : e2;
        }
        for (i = 4; i < n; i <<= 1) {
            int m = n / (i << 1);
            for (int j = 0; j < n; j += i << 1) {
                for (int k = 0; k < i; ++k) {
                    int k_times_m = k * m;
                    double omega_k_times_m_real = this.roots.getOmegaReal(k_times_m);
                    double omega_k_times_m_imaginary = this.roots.getOmegaImaginary(k_times_m);
                    Complex z = new Complex(f[i + j + k].getReal() * omega_k_times_m_real - f[i + j + k].getImaginary() * omega_k_times_m_imaginary, f[i + j + k].getReal() * omega_k_times_m_imaginary + f[i + j + k].getImaginary() * omega_k_times_m_real);
                    f[i + j + k] = f[j + k].subtract(z);
                    f[j + k] = f[j + k].add(z);
                }
            }
        }
        return f;
    }

    public static double[] sample(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        if (n <= 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"number of sample is not positive: {0}", (Object[])new Object[]{n});
        }
        FastFourierTransformer.verifyInterval((double)min, (double)max);
        double[] s = new double[n];
        double h = (max - min) / (double)n;
        for (int i = 0; i < n; ++i) {
            s[i] = f.value(min + (double)i * h);
        }
        return s;
    }

    public static double[] scaleArray(double[] f, double d) {
        int i = 0;
        while (i < f.length) {
            int n = i++;
            f[n] = f[n] * d;
        }
        return f;
    }

    public static Complex[] scaleArray(Complex[] f, double d) {
        for (int i = 0; i < f.length; ++i) {
            f[i] = new Complex(d * f[i].getReal(), d * f[i].getImaginary());
        }
        return f;
    }

    public static boolean isPowerOf2(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static void verifyDataSet(double[] d) throws IllegalArgumentException {
        if (!FastFourierTransformer.isPowerOf2((long)d.length)) {
            throw MathRuntimeException.createIllegalArgumentException((String)"{0} is not a power of 2, consider padding for fix", (Object[])new Object[]{d.length});
        }
    }

    public static void verifyDataSet(Object[] o) throws IllegalArgumentException {
        if (!FastFourierTransformer.isPowerOf2((long)o.length)) {
            throw MathRuntimeException.createIllegalArgumentException((String)"{0} is not a power of 2, consider padding for fix", (Object[])new Object[]{o.length});
        }
    }

    public static void verifyInterval(double lower, double upper) throws IllegalArgumentException {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException((String)"endpoints do not specify an interval: [{0}, {1}]", (Object[])new Object[]{lower, upper});
        }
    }

    public Object mdfft(Object mdca, boolean forward) throws IllegalArgumentException {
        MultiDimensionalComplexMatrix mdcm = (MultiDimensionalComplexMatrix)new MultiDimensionalComplexMatrix(mdca).clone();
        int[] dimensionSize = mdcm.getDimensionSizes();
        for (int i = 0; i < dimensionSize.length; ++i) {
            this.mdfft(mdcm, forward, i, new int[0]);
        }
        return mdcm.getArray();
    }

    private void mdfft(MultiDimensionalComplexMatrix mdcm, boolean forward, int d, int[] subVector) throws IllegalArgumentException {
        int[] dimensionSize = mdcm.getDimensionSizes();
        if (subVector.length == dimensionSize.length) {
            int i;
            Complex[] temp = new Complex[dimensionSize[d]];
            for (i = 0; i < dimensionSize[d]; ++i) {
                subVector[d] = i;
                temp[i] = mdcm.get(subVector);
            }
            temp = forward ? this.transform2(temp) : this.inversetransform2(temp);
            for (i = 0; i < dimensionSize[d]; ++i) {
                subVector[d] = i;
                mdcm.set(temp[i], subVector);
            }
        } else {
            int[] vector = new int[subVector.length + 1];
            System.arraycopy(subVector, 0, vector, 0, subVector.length);
            if (subVector.length == d) {
                vector[d] = 0;
                this.mdfft(mdcm, forward, d, vector);
            } else {
                int i = 0;
                while (i < dimensionSize[subVector.length]) {
                    vector[subVector.length] = i++;
                    this.mdfft(mdcm, forward, d, vector);
                }
            }
        }
    }
}

