/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.inference;

import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.TDistribution;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.inference.TTest;

public class TTestImpl
implements TTest {
    private static final String INSUFFICIENT_DATA_MESSAGE = "insufficient data for t statistic, needs at least 2, got {0}";
    private TDistribution distribution;

    public TTestImpl() {
        this((TDistribution)new TDistributionImpl(1.0));
    }

    public TTestImpl(TDistribution t) {
        this.setDistribution(t);
    }

    public double pairedT(double[] sample1, double[] sample2) throws IllegalArgumentException, MathException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        double meanDifference = StatUtils.meanDifference((double[])sample1, (double[])sample2);
        return this.t(meanDifference, 0.0, StatUtils.varianceDifference((double[])sample1, (double[])sample2, (double)meanDifference), (double)sample1.length);
    }

    public double pairedTTest(double[] sample1, double[] sample2) throws IllegalArgumentException, MathException {
        double meanDifference = StatUtils.meanDifference((double[])sample1, (double[])sample2);
        return this.tTest(meanDifference, 0.0, StatUtils.varianceDifference((double[])sample1, (double[])sample2, (double)meanDifference), (double)sample1.length);
    }

    public boolean pairedTTest(double[] sample1, double[] sample2, double alpha) throws IllegalArgumentException, MathException {
        this.checkSignificanceLevel(alpha);
        return this.pairedTTest(sample1, sample2) < alpha;
    }

    public double t(double mu, double[] observed) throws IllegalArgumentException {
        this.checkSampleData(observed);
        return this.t(StatUtils.mean((double[])observed), mu, StatUtils.variance((double[])observed), (double)observed.length);
    }

    public double t(double mu, StatisticalSummary sampleStats) throws IllegalArgumentException {
        this.checkSampleData(sampleStats);
        return this.t(sampleStats.getMean(), mu, sampleStats.getVariance(), (double)sampleStats.getN());
    }

    public double homoscedasticT(double[] sample1, double[] sample2) throws IllegalArgumentException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        return this.homoscedasticT(StatUtils.mean((double[])sample1), StatUtils.mean((double[])sample2), StatUtils.variance((double[])sample1), StatUtils.variance((double[])sample2), (double)sample1.length, (double)sample2.length);
    }

    public double t(double[] sample1, double[] sample2) throws IllegalArgumentException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        return this.t(StatUtils.mean((double[])sample1), StatUtils.mean((double[])sample2), StatUtils.variance((double[])sample1), StatUtils.variance((double[])sample2), (double)sample1.length, (double)sample2.length);
    }

    public double t(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws IllegalArgumentException {
        this.checkSampleData(sampleStats1);
        this.checkSampleData(sampleStats2);
        return this.t(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), (double)sampleStats1.getN(), (double)sampleStats2.getN());
    }

    public double homoscedasticT(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws IllegalArgumentException {
        this.checkSampleData(sampleStats1);
        this.checkSampleData(sampleStats2);
        return this.homoscedasticT(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), (double)sampleStats1.getN(), (double)sampleStats2.getN());
    }

    public double tTest(double mu, double[] sample) throws IllegalArgumentException, MathException {
        this.checkSampleData(sample);
        return this.tTest(StatUtils.mean((double[])sample), mu, StatUtils.variance((double[])sample), (double)sample.length);
    }

    public boolean tTest(double mu, double[] sample, double alpha) throws IllegalArgumentException, MathException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(mu, sample) < alpha;
    }

    public double tTest(double mu, StatisticalSummary sampleStats) throws IllegalArgumentException, MathException {
        this.checkSampleData(sampleStats);
        return this.tTest(sampleStats.getMean(), mu, sampleStats.getVariance(), (double)sampleStats.getN());
    }

    public boolean tTest(double mu, StatisticalSummary sampleStats, double alpha) throws IllegalArgumentException, MathException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(mu, sampleStats) < alpha;
    }

    public double tTest(double[] sample1, double[] sample2) throws IllegalArgumentException, MathException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        return this.tTest(StatUtils.mean((double[])sample1), StatUtils.mean((double[])sample2), StatUtils.variance((double[])sample1), StatUtils.variance((double[])sample2), (double)sample1.length, (double)sample2.length);
    }

    public double homoscedasticTTest(double[] sample1, double[] sample2) throws IllegalArgumentException, MathException {
        this.checkSampleData(sample1);
        this.checkSampleData(sample2);
        return this.homoscedasticTTest(StatUtils.mean((double[])sample1), StatUtils.mean((double[])sample2), StatUtils.variance((double[])sample1), StatUtils.variance((double[])sample2), (double)sample1.length, (double)sample2.length);
    }

    public boolean tTest(double[] sample1, double[] sample2, double alpha) throws IllegalArgumentException, MathException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(sample1, sample2) < alpha;
    }

    public boolean homoscedasticTTest(double[] sample1, double[] sample2, double alpha) throws IllegalArgumentException, MathException {
        this.checkSignificanceLevel(alpha);
        return this.homoscedasticTTest(sample1, sample2) < alpha;
    }

    public double tTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws IllegalArgumentException, MathException {
        this.checkSampleData(sampleStats1);
        this.checkSampleData(sampleStats2);
        return this.tTest(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), (double)sampleStats1.getN(), (double)sampleStats2.getN());
    }

    public double homoscedasticTTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws IllegalArgumentException, MathException {
        this.checkSampleData(sampleStats1);
        this.checkSampleData(sampleStats2);
        return this.homoscedasticTTest(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), (double)sampleStats1.getN(), (double)sampleStats2.getN());
    }

    public boolean tTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2, double alpha) throws IllegalArgumentException, MathException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(sampleStats1, sampleStats2) < alpha;
    }

    protected double df(double v1, double v2, double n1, double n2) {
        return (v1 / n1 + v2 / n2) * (v1 / n1 + v2 / n2) / (v1 * v1 / (n1 * n1 * (n1 - 1.0)) + v2 * v2 / (n2 * n2 * (n2 - 1.0)));
    }

    protected double t(double m, double mu, double v, double n) {
        return (m - mu) / Math.sqrt(v / n);
    }

    protected double t(double m1, double m2, double v1, double v2, double n1, double n2) {
        return (m1 - m2) / Math.sqrt(v1 / n1 + v2 / n2);
    }

    protected double homoscedasticT(double m1, double m2, double v1, double v2, double n1, double n2) {
        double pooledVariance = ((n1 - 1.0) * v1 + (n2 - 1.0) * v2) / (n1 + n2 - 2.0);
        return (m1 - m2) / Math.sqrt(pooledVariance * (1.0 / n1 + 1.0 / n2));
    }

    protected double tTest(double m, double mu, double v, double n) throws MathException {
        double t = Math.abs(this.t(m, mu, v, n));
        this.distribution.setDegreesOfFreedom(n - 1.0);
        return 2.0 * this.distribution.cumulativeProbability(-t);
    }

    protected double tTest(double m1, double m2, double v1, double v2, double n1, double n2) throws MathException {
        double t = Math.abs(this.t(m1, m2, v1, v2, n1, n2));
        double degreesOfFreedom = 0.0;
        degreesOfFreedom = this.df(v1, v2, n1, n2);
        this.distribution.setDegreesOfFreedom(degreesOfFreedom);
        return 2.0 * this.distribution.cumulativeProbability(-t);
    }

    protected double homoscedasticTTest(double m1, double m2, double v1, double v2, double n1, double n2) throws MathException {
        double t = Math.abs(this.homoscedasticT(m1, m2, v1, v2, n1, n2));
        double degreesOfFreedom = n1 + n2 - 2.0;
        this.distribution.setDegreesOfFreedom(degreesOfFreedom);
        return 2.0 * this.distribution.cumulativeProbability(-t);
    }

    public void setDistribution(TDistribution value) {
        this.distribution = value;
    }

    private void checkSignificanceLevel(double alpha) throws IllegalArgumentException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw MathRuntimeException.createIllegalArgumentException((String)"out of bounds significance level {0}, must be between {1} and {2}", (Object[])new Object[]{alpha, 0.0, 0.5});
        }
    }

    private void checkSampleData(double[] data) throws IllegalArgumentException {
        if (data == null || data.length < 2) {
            throw MathRuntimeException.createIllegalArgumentException((String)INSUFFICIENT_DATA_MESSAGE, (Object[])new Object[]{data == null ? 0 : data.length});
        }
    }

    private void checkSampleData(StatisticalSummary stat) throws IllegalArgumentException {
        if (stat == null || stat.getN() < 2L) {
            throw MathRuntimeException.createIllegalArgumentException((String)INSUFFICIENT_DATA_MESSAGE, (Object[])new Object[]{stat == null ? 0L : stat.getN()});
        }
    }
}

