/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.sampling;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.sampling.StepInterpolator;

public abstract class AbstractStepInterpolator
implements StepInterpolator {
    protected double previousTime;
    protected double currentTime;
    protected double h;
    protected double[] currentState;
    protected double interpolatedTime;
    protected double[] interpolatedState;
    protected double[] interpolatedDerivatives;
    private boolean finalized;
    private boolean forward;
    private boolean dirtyState;

    protected AbstractStepInterpolator() {
        this.previousTime = Double.NaN;
        this.currentTime = Double.NaN;
        this.h = Double.NaN;
        this.interpolatedTime = Double.NaN;
        this.currentState = null;
        this.interpolatedState = null;
        this.interpolatedDerivatives = null;
        this.finalized = false;
        this.forward = true;
        this.dirtyState = true;
    }

    protected AbstractStepInterpolator(double[] y, boolean forward) {
        this.previousTime = Double.NaN;
        this.currentTime = Double.NaN;
        this.h = Double.NaN;
        this.interpolatedTime = Double.NaN;
        this.currentState = y;
        this.interpolatedState = new double[y.length];
        this.interpolatedDerivatives = new double[y.length];
        this.finalized = false;
        this.forward = forward;
        this.dirtyState = true;
    }

    protected AbstractStepInterpolator(AbstractStepInterpolator interpolator) {
        this.previousTime = interpolator.previousTime;
        this.currentTime = interpolator.currentTime;
        this.h = interpolator.h;
        this.interpolatedTime = interpolator.interpolatedTime;
        if (interpolator.currentState != null) {
            this.currentState = (double[])interpolator.currentState.clone();
            this.interpolatedState = (double[])interpolator.interpolatedState.clone();
            this.interpolatedDerivatives = (double[])interpolator.interpolatedDerivatives.clone();
        } else {
            this.currentState = null;
            this.interpolatedState = null;
            this.interpolatedDerivatives = null;
        }
        this.finalized = interpolator.finalized;
        this.forward = interpolator.forward;
        this.dirtyState = interpolator.dirtyState;
    }

    protected void reinitialize(double[] y, boolean isForward) {
        this.previousTime = Double.NaN;
        this.currentTime = Double.NaN;
        this.h = Double.NaN;
        this.interpolatedTime = Double.NaN;
        this.currentState = y;
        this.interpolatedState = new double[y.length];
        this.interpolatedDerivatives = new double[y.length];
        this.finalized = false;
        this.forward = isForward;
        this.dirtyState = true;
    }

    public StepInterpolator copy() throws DerivativeException {
        this.finalizeStep();
        return this.doCopy();
    }

    protected abstract StepInterpolator doCopy();

    public void shift() {
        this.previousTime = this.currentTime;
    }

    public void storeTime(double t) {
        this.currentTime = t;
        this.h = this.currentTime - this.previousTime;
        this.setInterpolatedTime(t);
        this.finalized = false;
    }

    public double getPreviousTime() {
        return this.previousTime;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public double getInterpolatedTime() {
        return this.interpolatedTime;
    }

    public void setInterpolatedTime(double time) {
        this.interpolatedTime = time;
        this.dirtyState = true;
    }

    public boolean isForward() {
        return this.forward;
    }

    protected abstract void computeInterpolatedStateAndDerivatives(double var1, double var3) throws DerivativeException;

    public double[] getInterpolatedState() throws DerivativeException {
        if (this.dirtyState) {
            double oneMinusThetaH = this.currentTime - this.interpolatedTime;
            double theta = this.h == 0.0 ? 0.0 : (this.h - oneMinusThetaH) / this.h;
            this.computeInterpolatedStateAndDerivatives(theta, oneMinusThetaH);
            this.dirtyState = false;
        }
        return this.interpolatedState;
    }

    public double[] getInterpolatedDerivatives() throws DerivativeException {
        if (this.dirtyState) {
            double oneMinusThetaH = this.currentTime - this.interpolatedTime;
            double theta = this.h == 0.0 ? 0.0 : (this.h - oneMinusThetaH) / this.h;
            this.computeInterpolatedStateAndDerivatives(theta, oneMinusThetaH);
            this.dirtyState = false;
        }
        return this.interpolatedDerivatives;
    }

    public final void finalizeStep() throws DerivativeException {
        if (!this.finalized) {
            this.doFinalize();
            this.finalized = true;
        }
    }

    protected void doFinalize() throws DerivativeException {
    }

    public abstract void writeExternal(ObjectOutput var1) throws IOException;

    public abstract void readExternal(ObjectInput var1) throws IOException, ClassNotFoundException;

    protected void writeBaseExternal(ObjectOutput out) throws IOException {
        if (this.currentState == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.currentState.length);
        }
        out.writeDouble(this.previousTime);
        out.writeDouble(this.currentTime);
        out.writeDouble(this.h);
        out.writeBoolean(this.forward);
        if (this.currentState != null) {
            for (int i = 0; i < this.currentState.length; ++i) {
                out.writeDouble(this.currentState[i]);
            }
        }
        out.writeDouble(this.interpolatedTime);
        try {
            this.finalizeStep();
        }
        catch (DerivativeException e) {
            throw MathRuntimeException.createIOException((Throwable)e);
        }
    }

    protected double readBaseExternal(ObjectInput in) throws IOException {
        int dimension = in.readInt();
        this.previousTime = in.readDouble();
        this.currentTime = in.readDouble();
        this.h = in.readDouble();
        this.forward = in.readBoolean();
        this.dirtyState = true;
        if (dimension < 0) {
            this.currentState = null;
        } else {
            this.currentState = new double[dimension];
            for (int i = 0; i < this.currentState.length; ++i) {
                this.currentState[i] = in.readDouble();
            }
        }
        this.interpolatedTime = Double.NaN;
        this.interpolatedState = dimension < 0 ? null : new double[dimension];
        this.interpolatedDerivatives = dimension < 0 ? null : new double[dimension];
        this.finalized = true;
        return in.readDouble();
    }
}

