/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.QRDecomposition;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;

public class QRDecompositionImpl
implements QRDecomposition {
    private double[][] qrt;
    private double[] rDiag;
    private RealMatrix cachedQ;
    private RealMatrix cachedQT;
    private RealMatrix cachedR;
    private RealMatrix cachedH;

    public QRDecompositionImpl(RealMatrix matrix) {
        int m = matrix.getRowDimension();
        int n = matrix.getColumnDimension();
        this.qrt = matrix.transpose().getData();
        this.rDiag = new double[Math.min(m, n)];
        this.cachedQ = null;
        this.cachedQT = null;
        this.cachedR = null;
        this.cachedH = null;
        for (int minor = 0; minor < Math.min(m, n); ++minor) {
            double a;
            double[] qrtMinor = this.qrt[minor];
            double xNormSqr = 0.0;
            for (int row = minor; row < m; ++row) {
                double c = qrtMinor[row];
                xNormSqr += c * c;
            }
            this.rDiag[minor] = a = qrtMinor[minor] > 0.0 ? -Math.sqrt(xNormSqr) : Math.sqrt(xNormSqr);
            if (a == 0.0) continue;
            int n2 = minor;
            qrtMinor[n2] = qrtMinor[n2] - a;
            for (int col = minor + 1; col < n; ++col) {
                int row;
                double[] qrtCol = this.qrt[col];
                double alpha = 0.0;
                for (row = minor; row < m; ++row) {
                    alpha -= qrtCol[row] * qrtMinor[row];
                }
                alpha /= a * qrtMinor[minor];
                for (row = minor; row < m; ++row) {
                    int n3 = row;
                    qrtCol[n3] = qrtCol[n3] - alpha * qrtMinor[row];
                }
            }
        }
    }

    public RealMatrix getR() {
        if (this.cachedR == null) {
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            this.cachedR = MatrixUtils.createRealMatrix((int)m, (int)n);
            for (int row = Math.min(m, n) - 1; row >= 0; --row) {
                this.cachedR.setEntry(row, row, this.rDiag[row]);
                for (int col = row + 1; col < n; ++col) {
                    this.cachedR.setEntry(row, col, this.qrt[col][row]);
                }
            }
        }
        return this.cachedR;
    }

    public RealMatrix getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public RealMatrix getQT() {
        if (this.cachedQT == null) {
            int minor;
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            this.cachedQT = MatrixUtils.createRealMatrix((int)m, (int)m);
            for (minor = m - 1; minor >= Math.min(m, n); --minor) {
                this.cachedQT.setEntry(minor, minor, 1.0);
            }
            for (minor = Math.min(m, n) - 1; minor >= 0; --minor) {
                double[] qrtMinor = this.qrt[minor];
                this.cachedQT.setEntry(minor, minor, 1.0);
                if (qrtMinor[minor] == 0.0) continue;
                for (int col = minor; col < m; ++col) {
                    int row;
                    double alpha = 0.0;
                    for (row = minor; row < m; ++row) {
                        alpha -= this.cachedQT.getEntry(col, row) * qrtMinor[row];
                    }
                    alpha /= this.rDiag[minor] * qrtMinor[minor];
                    for (row = minor; row < m; ++row) {
                        this.cachedQT.addToEntry(col, row, -alpha * qrtMinor[row]);
                    }
                }
            }
        }
        return this.cachedQT;
    }

    public RealMatrix getH() {
        if (this.cachedH == null) {
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            this.cachedH = MatrixUtils.createRealMatrix((int)m, (int)n);
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < Math.min(i + 1, n); ++j) {
                    this.cachedH.setEntry(i, j, this.qrt[j][i] / -this.rDiag[j]);
                }
            }
        }
        return this.cachedH;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.qrt, this.rDiag, null);
    }
}

