/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.linear.Array2DRowFieldMatrix;
import org.apache.commons.math.linear.FieldDecompositionSolver;
import org.apache.commons.math.linear.FieldLUDecomposition;
import org.apache.commons.math.linear.FieldLUDecompositionImpl;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.NonSquareMatrixException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldLUDecompositionImpl<T extends FieldElement<T>>
implements FieldLUDecomposition<T> {
    private final Field<T> field;
    private T[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private FieldMatrix<T> cachedL;
    private FieldMatrix<T> cachedU;
    private FieldMatrix<T> cachedP;

    public FieldLUDecompositionImpl(FieldMatrix<T> matrix) throws NonSquareMatrixException {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getColumnDimension();
        this.field = matrix.getField();
        this.lu = matrix.getData();
        this.pivot = new int[m];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        for (int row = 0; row < m; ++row) {
            this.pivot[row] = row;
        }
        this.even = true;
        this.singular = false;
        for (int col = 0; col < m; ++col) {
            FieldElement sum = (FieldElement)this.field.getZero();
            for (int row = 0; row < col; ++row) {
                FieldElement[] luRow = this.lu[row];
                sum = luRow[col];
                for (int i = 0; i < row; ++i) {
                    sum = (FieldElement)sum.subtract(luRow[i].multiply((Object)this.lu[i][col]));
                }
                luRow[col] = sum;
            }
            int nonZero = col;
            for (int row = col; row < m; ++row) {
                FieldElement[] luRow = this.lu[row];
                sum = luRow[col];
                for (int i = 0; i < col; ++i) {
                    sum = (FieldElement)sum.subtract(luRow[i].multiply((Object)this.lu[i][col]));
                }
                luRow[col] = sum;
                if (!this.lu[nonZero][col].equals(this.field.getZero())) continue;
                ++nonZero;
            }
            if (nonZero >= m) {
                this.singular = true;
                return;
            }
            if (nonZero != col) {
                FieldElement tmp = (FieldElement)this.field.getZero();
                for (int i = 0; i < m; ++i) {
                    tmp = this.lu[nonZero][i];
                    this.lu[nonZero][i] = this.lu[col][i];
                    this.lu[col][i] = tmp;
                }
                int temp = this.pivot[nonZero];
                this.pivot[nonZero] = this.pivot[col];
                this.pivot[col] = temp;
                this.even = !this.even;
            }
            FieldElement luDiag = this.lu[col][col];
            for (int row = col + 1; row < m; ++row) {
                FieldElement[] luRow = this.lu[row];
                luRow[col] = (FieldElement)luRow[col].divide((Object)luDiag);
            }
        }
    }

    public FieldMatrix<T> getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedL = new Array2DRowFieldMatrix(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                FieldElement[] luI = this.lu[i];
                for (int j = 0; j < i; ++j) {
                    this.cachedL.setEntry(i, j, luI[j]);
                }
                this.cachedL.setEntry(i, i, (FieldElement)this.field.getOne());
            }
        }
        return this.cachedL;
    }

    public FieldMatrix<T> getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedU = new Array2DRowFieldMatrix(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                FieldElement[] luI = this.lu[i];
                for (int j = i; j < m; ++j) {
                    this.cachedU.setEntry(i, j, luI[j]);
                }
            }
        }
        return this.cachedU;
    }

    public FieldMatrix<T> getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedP = new Array2DRowFieldMatrix(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                this.cachedP.setEntry(i, this.pivot[i], (FieldElement)this.field.getOne());
            }
        }
        return this.cachedP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public T getDeterminant() {
        if (this.singular) {
            return (T)((FieldElement)this.field.getZero());
        }
        int m = this.pivot.length;
        FieldElement determinant = this.even ? (FieldElement)this.field.getOne() : (FieldElement)((FieldElement)this.field.getZero()).subtract(this.field.getOne());
        for (int i = 0; i < m; ++i) {
            determinant = (FieldElement)determinant.multiply((Object)this.lu[i][i]);
        }
        return (T)determinant;
    }

    public FieldDecompositionSolver<T> getSolver() {
        return new Solver(this.field, this.lu, this.pivot, this.singular, null);
    }
}

