/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.linear.AbstractFieldMatrix;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixVisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Array2DRowFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    private static final long serialVersionUID = 7260756672015356458L;
    private static final String AT_LEAST_ONE_ROW_MESSAGE = "matrix must have at least one row";
    private static final String AT_LEAST_ONE_COLUMN_MESSAGE = "matrix must have at least one column";
    private static final String DIFFERENT_ROWS_LENGTHS_MESSAGE = "some rows have length {0} while others have length {1}";
    private static final String NO_ENTRY_MESSAGE = "no entry at indices ({0}, {1}) in a {2}x{3} matrix";
    private static final String VECTOR_LENGTHS_MISMATCH = "vector length mismatch: got {0} but expected {1}";
    protected T[][] data;

    public Array2DRowFieldMatrix(Field<T> field) {
        super(field);
    }

    public Array2DRowFieldMatrix(Field<T> field, int rowDimension, int columnDimension) throws IllegalArgumentException {
        super(field, rowDimension, columnDimension);
        this.data = Array2DRowFieldMatrix.buildArray(field, (int)rowDimension, (int)columnDimension);
    }

    public Array2DRowFieldMatrix(T[][] d) throws IllegalArgumentException, NullPointerException {
        super(Array2DRowFieldMatrix.extractField(d));
        this.copyIn(d);
    }

    public Array2DRowFieldMatrix(T[][] d, boolean copyArray) throws IllegalArgumentException, NullPointerException {
        super(Array2DRowFieldMatrix.extractField(d));
        if (copyArray) {
            this.copyIn(d);
        } else {
            if (d == null) {
                throw new NullPointerException();
            }
            int nRows = d.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException((String)"matrix must have at least one row", (Object[])new Object[0]);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException((String)"matrix must have at least one column", (Object[])new Object[0]);
            }
            for (int r = 1; r < nRows; ++r) {
                if (d[r].length == nCols) continue;
                throw MathRuntimeException.createIllegalArgumentException((String)"some rows have length {0} while others have length {1}", (Object[])new Object[]{nCols, d[r].length});
            }
            this.data = d;
        }
    }

    public Array2DRowFieldMatrix(T[] v) {
        super(Array2DRowFieldMatrix.extractField(v));
        int nRows = v.length;
        this.data = Array2DRowFieldMatrix.buildArray((Field)this.getField(), (int)nRows, (int)1);
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v[row];
        }
    }

    public FieldMatrix<T> createMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        return new Array2DRowFieldMatrix(this.getField(), rowDimension, columnDimension);
    }

    public FieldMatrix<T> copy() {
        return new Array2DRowFieldMatrix(this.copyOut(), false);
    }

    public FieldMatrix<T> add(FieldMatrix<T> m) throws IllegalArgumentException {
        try {
            return this.add((Array2DRowFieldMatrix)m);
        }
        catch (ClassCastException cce) {
            return super.add(m);
        }
    }

    public Array2DRowFieldMatrix<T> add(Array2DRowFieldMatrix<T> m) throws IllegalArgumentException {
        this.checkAdditionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = Array2DRowFieldMatrix.buildArray((Field)this.getField(), (int)rowCount, (int)columnCount);
        for (int row = 0; row < rowCount; ++row) {
            FieldElement[] dataRow = this.data[row];
            FieldElement[] mRow = m.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = (FieldElement)dataRow[col].add((Object)mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(outData, false);
    }

    public FieldMatrix<T> subtract(FieldMatrix<T> m) throws IllegalArgumentException {
        try {
            return this.subtract((Array2DRowFieldMatrix)m);
        }
        catch (ClassCastException cce) {
            return super.subtract(m);
        }
    }

    public Array2DRowFieldMatrix<T> subtract(Array2DRowFieldMatrix<T> m) throws IllegalArgumentException {
        this.checkSubtractionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = Array2DRowFieldMatrix.buildArray((Field)this.getField(), (int)rowCount, (int)columnCount);
        for (int row = 0; row < rowCount; ++row) {
            FieldElement[] dataRow = this.data[row];
            FieldElement[] mRow = m.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = (FieldElement)dataRow[col].subtract((Object)mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(outData, false);
    }

    public FieldMatrix<T> multiply(FieldMatrix<T> m) throws IllegalArgumentException {
        try {
            return this.multiply((Array2DRowFieldMatrix)m);
        }
        catch (ClassCastException cce) {
            return super.multiply(m);
        }
    }

    public Array2DRowFieldMatrix<T> multiply(Array2DRowFieldMatrix<T> m) throws IllegalArgumentException {
        this.checkMultiplicationCompatible(m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldElement[][] outData = Array2DRowFieldMatrix.buildArray((Field)this.getField(), (int)nRows, (int)nCols);
        for (int row = 0; row < nRows; ++row) {
            FieldElement[] dataRow = this.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < nCols; ++col) {
                FieldElement sum = (FieldElement)this.getField().getZero();
                for (int i = 0; i < nSum; ++i) {
                    sum = (FieldElement)sum.add(dataRow[i].multiply((Object)m.data[i][col]));
                }
                outDataRow[col] = sum;
            }
        }
        return new Array2DRowFieldMatrix(outData, false);
    }

    public T[][] getData() {
        return this.copyOut();
    }

    public T[][] getDataRef() {
        return this.data;
    }

    public void setSubMatrix(T[][] subMatrix, int row, int column) throws MatrixIndexException {
        if (this.data == null) {
            if (row > 0) {
                throw MathRuntimeException.createIllegalStateException((String)"first {0} rows are not initialized yet", (Object[])new Object[]{row});
            }
            if (column > 0) {
                throw MathRuntimeException.createIllegalStateException((String)"first {0} columns are not initialized yet", (Object[])new Object[]{column});
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException((String)"matrix must have at least one row", (Object[])new Object[0]);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException((String)"matrix must have at least one column", (Object[])new Object[0]);
            }
            this.data = Array2DRowFieldMatrix.buildArray((Field)this.getField(), (int)subMatrix.length, (int)nCols);
            for (int i = 0; i < this.data.length; ++i) {
                if (subMatrix[i].length != nCols) {
                    throw MathRuntimeException.createIllegalArgumentException((String)"some rows have length {0} while others have length {1}", (Object[])new Object[]{nCols, subMatrix[i].length});
                }
                System.arraycopy(subMatrix[i], 0, this.data[i + row], column, nCols);
            }
        } else {
            super.setSubMatrix(subMatrix, row, column);
        }
    }

    public T getEntry(int row, int column) throws MatrixIndexException {
        try {
            return (T)this.data[row][column];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException("no entry at indices ({0}, {1}) in a {2}x{3} matrix", new Object[]{row, column, this.getRowDimension(), this.getColumnDimension()});
        }
    }

    public void setEntry(int row, int column, T value) throws MatrixIndexException {
        try {
            this.data[row][column] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException("no entry at indices ({0}, {1}) in a {2}x{3} matrix", new Object[]{row, column, this.getRowDimension(), this.getColumnDimension()});
        }
    }

    public void addToEntry(int row, int column, T increment) throws MatrixIndexException {
        try {
            this.data[row][column] = (FieldElement)this.data[row][column].add(increment);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException("no entry at indices ({0}, {1}) in a {2}x{3} matrix", new Object[]{row, column, this.getRowDimension(), this.getColumnDimension()});
        }
    }

    public void multiplyEntry(int row, int column, T factor) throws MatrixIndexException {
        try {
            this.data[row][column] = (FieldElement)this.data[row][column].multiply(factor);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException("no entry at indices ({0}, {1}) in a {2}x{3} matrix", new Object[]{row, column, this.getRowDimension(), this.getColumnDimension()});
        }
    }

    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    public T[] operate(T[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException((String)"vector length mismatch: got {0} but expected {1}", (Object[])new Object[]{v.length, nCols});
        }
        FieldElement[] out = Array2DRowFieldMatrix.buildArray((Field)this.getField(), (int)nRows);
        for (int row = 0; row < nRows; ++row) {
            FieldElement[] dataRow = this.data[row];
            FieldElement sum = (FieldElement)this.getField().getZero();
            for (int i = 0; i < nCols; ++i) {
                sum = (FieldElement)sum.add(dataRow[i].multiply(v[i]));
            }
            out[row] = sum;
        }
        return out;
    }

    public T[] preMultiply(T[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException((String)"vector length mismatch: got {0} but expected {1}", (Object[])new Object[]{v.length, nRows});
        }
        FieldElement[] out = Array2DRowFieldMatrix.buildArray((Field)this.getField(), (int)nCols);
        for (int col = 0; col < nCols; ++col) {
            FieldElement sum = (FieldElement)this.getField().getZero();
            for (int i = 0; i < nRows; ++i) {
                sum = (FieldElement)sum.add(this.data[i][col].multiply(v[i]));
            }
            out[col] = sum;
        }
        return out;
    }

    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            FieldElement[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return (T)visitor.end();
    }

    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            FieldElement[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return (T)visitor.end();
    }

    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            FieldElement[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return (T)visitor.end();
    }

    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            FieldElement[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return (T)visitor.end();
    }

    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                FieldElement[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return (T)visitor.end();
    }

    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return (T)visitor.end();
    }

    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                FieldElement[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return (T)visitor.end();
    }

    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return (T)visitor.end();
    }

    private T[][] copyOut() {
        int nRows = this.getRowDimension();
        FieldElement[][] out = Array2DRowFieldMatrix.buildArray((Field)this.getField(), (int)nRows, (int)this.getColumnDimension());
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
        }
        return out;
    }

    private void copyIn(T[][] in) {
        this.setSubMatrix(in, 0, 0);
    }
}

