/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.util.Iterator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.BinaryFunction;
import org.apache.commons.math.analysis.ComposableFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.linear.AbstractRealVector;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.OpenMapRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SparseRealVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRealVector
implements RealVector {
    protected void checkVectorDimensions(RealVector v) {
        this.checkVectorDimensions(v.getDimension());
    }

    protected void checkVectorDimensions(int n) throws IllegalArgumentException {
        double d = this.getDimension();
        if (d != (double)n) {
            throw MathRuntimeException.createIllegalArgumentException((String)"vector length mismatch: got {0} but expected {1}", (Object[])new Object[]{d, n});
        }
    }

    protected void checkIndex(int index) throws MatrixIndexException {
        if (index < 0 || index >= this.getDimension()) {
            throw new MatrixIndexException("index {0} out of allowed range [{1}, {2}]", new Object[]{index, 0, this.getDimension() - 1});
        }
    }

    public void setSubVector(int index, RealVector v) throws MatrixIndexException {
        this.checkIndex(index);
        this.checkIndex(index + v.getDimension() - 1);
        this.setSubVector(index, v.getData());
    }

    public void setSubVector(int index, double[] v) throws MatrixIndexException {
        this.checkIndex(index);
        this.checkIndex(index + v.length - 1);
        for (int i = 0; i < v.length; ++i) {
            this.setEntry(i + index, v[i]);
        }
    }

    public RealVector add(double[] v) throws IllegalArgumentException {
        RealVector.Entry e;
        double[] result = (double[])v.clone();
        Iterator it = this.sparseIterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            int n = e.getIndex();
            result[n] = result[n] + e.getValue();
        }
        return new ArrayRealVector(result, false);
    }

    public RealVector add(RealVector v) throws IllegalArgumentException {
        RealVector.Entry e;
        if (v instanceof ArrayRealVector) {
            double[] values = ((ArrayRealVector)v).getDataRef();
            return this.add(values);
        }
        RealVector result = v.copy();
        Iterator it = this.sparseIterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            int index = e.getIndex();
            result.setEntry(index, e.getValue() + result.getEntry(index));
        }
        return result;
    }

    public RealVector subtract(double[] v) throws IllegalArgumentException {
        RealVector.Entry e;
        double[] result = (double[])v.clone();
        Iterator it = this.sparseIterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            int index = e.getIndex();
            result[index] = e.getValue() - result[index];
        }
        return new ArrayRealVector(result, false);
    }

    public RealVector subtract(RealVector v) throws IllegalArgumentException {
        RealVector.Entry e;
        if (v instanceof ArrayRealVector) {
            double[] values = ((ArrayRealVector)v).getDataRef();
            return this.add(values);
        }
        RealVector result = v.copy();
        Iterator it = this.sparseIterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            int index = e.getIndex();
            v.setEntry(index, e.getValue() - result.getEntry(index));
        }
        return result;
    }

    public RealVector mapAdd(double d) {
        return this.copy().mapAddToSelf(d);
    }

    public RealVector mapAddToSelf(double d) {
        if (d != 0.0) {
            try {
                return this.mapToSelf((UnivariateRealFunction)BinaryFunction.ADD.fix1stArgument(d));
            }
            catch (FunctionEvaluationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    public abstract AbstractRealVector copy();

    public double dotProduct(double[] v) throws IllegalArgumentException {
        return this.dotProduct((RealVector)new ArrayRealVector(v, false));
    }

    public double dotProduct(RealVector v) throws IllegalArgumentException {
        RealVector.Entry e;
        this.checkVectorDimensions(v);
        double d = 0.0;
        Iterator it = this.sparseIterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            d += e.getValue() * v.getEntry(e.getIndex());
        }
        return d;
    }

    public RealVector ebeDivide(double[] v) throws IllegalArgumentException {
        return this.ebeDivide((RealVector)new ArrayRealVector(v, false));
    }

    public RealVector ebeMultiply(double[] v) throws IllegalArgumentException {
        return this.ebeMultiply((RealVector)new ArrayRealVector(v, false));
    }

    public double getDistance(RealVector v) throws IllegalArgumentException {
        RealVector.Entry e;
        this.checkVectorDimensions(v);
        double d = 0.0;
        Iterator it = this.iterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            double diff = e.getValue() - v.getEntry(e.getIndex());
            d += diff * diff;
        }
        return Math.sqrt(d);
    }

    public double getNorm() {
        RealVector.Entry e;
        double sum = 0.0;
        Iterator it = this.sparseIterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            double value = e.getValue();
            sum += value * value;
        }
        return Math.sqrt(sum);
    }

    public double getL1Norm() {
        RealVector.Entry e;
        double norm = 0.0;
        Iterator it = this.sparseIterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            norm += Math.abs(e.getValue());
        }
        return norm;
    }

    public double getLInfNorm() {
        RealVector.Entry e;
        double norm = 0.0;
        Iterator it = this.sparseIterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            norm = Math.max(norm, Math.abs(e.getValue()));
        }
        return norm;
    }

    public double getDistance(double[] v) throws IllegalArgumentException {
        return this.getDistance((RealVector)new ArrayRealVector(v, false));
    }

    public double getL1Distance(RealVector v) throws IllegalArgumentException {
        RealVector.Entry e;
        this.checkVectorDimensions(v);
        double d = 0.0;
        Iterator it = this.iterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            d += Math.abs(e.getValue() - v.getEntry(e.getIndex()));
        }
        return d;
    }

    public double getL1Distance(double[] v) throws IllegalArgumentException {
        RealVector.Entry e;
        this.checkVectorDimensions(v.length);
        double d = 0.0;
        Iterator it = this.iterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            d += Math.abs(e.getValue() - v[e.getIndex()]);
        }
        return d;
    }

    public double getLInfDistance(RealVector v) throws IllegalArgumentException {
        RealVector.Entry e;
        this.checkVectorDimensions(v);
        double d = 0.0;
        Iterator it = this.iterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            d = Math.max(Math.abs(e.getValue() - v.getEntry(e.getIndex())), d);
        }
        return d;
    }

    public double getLInfDistance(double[] v) throws IllegalArgumentException {
        RealVector.Entry e;
        this.checkVectorDimensions(v.length);
        double d = 0.0;
        Iterator it = this.iterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            d = Math.max(Math.abs(e.getValue() - v[e.getIndex()]), d);
        }
        return d;
    }

    public int getMinIndex() {
        int minIndex = -1;
        double minValue = Double.POSITIVE_INFINITY;
        for (RealVector.Entry entry : this) {
            if (!(entry.getValue() <= minValue)) continue;
            minIndex = entry.getIndex();
            minValue = entry.getValue();
        }
        return minIndex;
    }

    public double getMinValue() {
        int minIndex = this.getMinIndex();
        return minIndex < 0 ? Double.NaN : this.getEntry(minIndex);
    }

    public int getMaxIndex() {
        int maxIndex = -1;
        double maxValue = Double.NEGATIVE_INFINITY;
        for (RealVector.Entry entry : this) {
            if (!(entry.getValue() >= maxValue)) continue;
            maxIndex = entry.getIndex();
            maxValue = entry.getValue();
        }
        return maxIndex;
    }

    public double getMaxValue() {
        int maxIndex = this.getMaxIndex();
        return maxIndex < 0 ? Double.NaN : this.getEntry(maxIndex);
    }

    public RealVector mapAbs() {
        return this.copy().mapAbsToSelf();
    }

    public RealVector mapAbsToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.ABS);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapAcos() {
        return this.copy().mapAcosToSelf();
    }

    public RealVector mapAcosToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.ACOS);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapAsin() {
        return this.copy().mapAsinToSelf();
    }

    public RealVector mapAsinToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.ASIN);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapAtan() {
        return this.copy().mapAtanToSelf();
    }

    public RealVector mapAtanToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.ATAN);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapCbrt() {
        return this.copy().mapCbrtToSelf();
    }

    public RealVector mapCbrtToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.CBRT);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapCeil() {
        return this.copy().mapCeilToSelf();
    }

    public RealVector mapCeilToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.CEIL);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapCos() {
        return this.copy().mapCosToSelf();
    }

    public RealVector mapCosToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.COS);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapCosh() {
        return this.copy().mapCoshToSelf();
    }

    public RealVector mapCoshToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.COSH);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapDivide(double d) {
        return this.copy().mapDivideToSelf(d);
    }

    public RealVector mapDivideToSelf(double d) {
        try {
            return this.mapToSelf((UnivariateRealFunction)BinaryFunction.DIVIDE.fix2ndArgument(d));
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapExp() {
        return this.copy().mapExpToSelf();
    }

    public RealVector mapExpToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.EXP);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapExpm1() {
        return this.copy().mapExpm1ToSelf();
    }

    public RealVector mapExpm1ToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.EXPM1);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapFloor() {
        return this.copy().mapFloorToSelf();
    }

    public RealVector mapFloorToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.FLOOR);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapInv() {
        return this.copy().mapInvToSelf();
    }

    public RealVector mapInvToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.INVERT);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapLog() {
        return this.copy().mapLogToSelf();
    }

    public RealVector mapLogToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.LOG);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapLog10() {
        return this.copy().mapLog10ToSelf();
    }

    public RealVector mapLog10ToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.LOG10);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapLog1p() {
        return this.copy().mapLog1pToSelf();
    }

    public RealVector mapLog1pToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.LOG1P);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapMultiply(double d) {
        return this.copy().mapMultiplyToSelf(d);
    }

    public RealVector mapMultiplyToSelf(double d) {
        try {
            return this.mapToSelf((UnivariateRealFunction)BinaryFunction.MULTIPLY.fix1stArgument(d));
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapPow(double d) {
        return this.copy().mapPowToSelf(d);
    }

    public RealVector mapPowToSelf(double d) {
        try {
            return this.mapToSelf((UnivariateRealFunction)BinaryFunction.POW.fix2ndArgument(d));
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapRint() {
        return this.copy().mapRintToSelf();
    }

    public RealVector mapRintToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.RINT);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapSignum() {
        return this.copy().mapSignumToSelf();
    }

    public RealVector mapSignumToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.SIGNUM);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapSin() {
        return this.copy().mapSinToSelf();
    }

    public RealVector mapSinToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.SIN);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapSinh() {
        return this.copy().mapSinhToSelf();
    }

    public RealVector mapSinhToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.SINH);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapSqrt() {
        return this.copy().mapSqrtToSelf();
    }

    public RealVector mapSqrtToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.SQRT);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapSubtract(double d) {
        return this.copy().mapSubtractToSelf(d);
    }

    public RealVector mapSubtractToSelf(double d) {
        return this.mapAddToSelf(-d);
    }

    public RealVector mapTan() {
        return this.copy().mapTanToSelf();
    }

    public RealVector mapTanToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.TAN);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapTanh() {
        return this.copy().mapTanhToSelf();
    }

    public RealVector mapTanhToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.TANH);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealVector mapUlp() {
        return this.copy().mapUlpToSelf();
    }

    public RealVector mapUlpToSelf() {
        try {
            return this.mapToSelf((UnivariateRealFunction)ComposableFunction.ULP);
        }
        catch (FunctionEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealMatrix outerProduct(RealVector v) throws IllegalArgumentException {
        Object product = v instanceof SparseRealVector || this instanceof SparseRealVector ? new OpenMapRealMatrix(this.getDimension(), v.getDimension()) : new Array2DRowRealMatrix(this.getDimension(), v.getDimension());
        Iterator thisIt = this.sparseIterator();
        RealVector.Entry thisE = null;
        while (thisIt.hasNext() && (thisE = (RealVector.Entry)thisIt.next()) != null) {
            Iterator otherIt = v.sparseIterator();
            RealVector.Entry otherE = null;
            while (otherIt.hasNext() && (otherE = (RealVector.Entry)otherIt.next()) != null) {
                product.setEntry(thisE.getIndex(), otherE.getIndex(), thisE.getValue() * otherE.getValue());
            }
        }
        return product;
    }

    public RealMatrix outerProduct(double[] v) throws IllegalArgumentException {
        return this.outerProduct((RealVector)new ArrayRealVector(v, false));
    }

    public RealVector projection(double[] v) throws IllegalArgumentException {
        return this.projection((RealVector)new ArrayRealVector(v, false));
    }

    public void set(double value) {
        Iterator it = this.iterator();
        RealVector.Entry e = null;
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            e.setValue(value);
        }
    }

    public double[] toArray() {
        int dim = this.getDimension();
        double[] values = new double[dim];
        for (int i = 0; i < dim; ++i) {
            values[i] = this.getEntry(i);
        }
        return values;
    }

    public double[] getData() {
        return this.toArray();
    }

    public RealVector unitVector() {
        AbstractRealVector copy = this.copy();
        copy.unitize();
        return copy;
    }

    public void unitize() {
        this.mapDivideToSelf(this.getNorm());
    }

    public Iterator<RealVector.Entry> sparseIterator() {
        return new SparseEntryIterator(this);
    }

    public Iterator<RealVector.Entry> iterator() {
        int dim = this.getDimension();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public RealVector map(UnivariateRealFunction function) throws FunctionEvaluationException {
        return this.copy().mapToSelf(function);
    }

    public RealVector mapToSelf(UnivariateRealFunction function) throws FunctionEvaluationException {
        RealVector.Entry e;
        Iterator it;
        Iterator iterator = it = function.value(0.0) == 0.0 ? this.sparseIterator() : this.iterator();
        while (it.hasNext() && (e = (RealVector.Entry)it.next()) != null) {
            e.setValue(function.value(e.getValue()));
        }
        return this;
    }
}

