/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.HypergeometricDistribution;
import org.apache.commons.math.distribution.SaddlePointExpansion;
import org.apache.commons.math.util.MathUtils;

public class HypergeometricDistributionImpl
extends AbstractIntegerDistribution
implements HypergeometricDistribution,
Serializable {
    private static final long serialVersionUID = -436928820673516179L;
    private int numberOfSuccesses;
    private int populationSize;
    private int sampleSize;

    public HypergeometricDistributionImpl(int populationSize, int numberOfSuccesses, int sampleSize) {
        if (numberOfSuccesses > populationSize) {
            throw MathRuntimeException.createIllegalArgumentException((String)"number of successes ({0}) must be less than or equal to population size ({1})", (Object[])new Object[]{numberOfSuccesses, populationSize});
        }
        if (sampleSize > populationSize) {
            throw MathRuntimeException.createIllegalArgumentException((String)"sample size ({0}) must be less than or equal to population size ({1})", (Object[])new Object[]{sampleSize, populationSize});
        }
        this.setPopulationSizeInternal(populationSize);
        this.setSampleSizeInternal(sampleSize);
        this.setNumberOfSuccessesInternal(numberOfSuccesses);
    }

    public double cumulativeProbability(int x) {
        int[] domain = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double ret = x < domain[0] ? 0.0 : (x >= domain[1] ? 1.0 : this.innerCumulativeProbability(domain[0], x, 1, this.populationSize, this.numberOfSuccesses, this.sampleSize));
        return ret;
    }

    private int[] getDomain(int n, int m, int k) {
        return new int[]{this.getLowerDomain(n, m, k), this.getUpperDomain(m, k)};
    }

    protected int getDomainLowerBound(double p) {
        return this.getLowerDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
    }

    protected int getDomainUpperBound(double p) {
        return this.getUpperDomain(this.sampleSize, this.numberOfSuccesses);
    }

    private int getLowerDomain(int n, int m, int k) {
        return Math.max(0, m - (n - k));
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    private int getUpperDomain(int m, int k) {
        return Math.min(k, m);
    }

    public double probability(int x) {
        double ret;
        int[] domain = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        if (x < domain[0] || x > domain[1]) {
            ret = 0.0;
        } else {
            double p = (double)this.sampleSize / (double)this.populationSize;
            double q = (double)(this.populationSize - this.sampleSize) / (double)this.populationSize;
            double p1 = SaddlePointExpansion.logBinomialProbability((int)x, (int)this.numberOfSuccesses, (double)p, (double)q);
            double p2 = SaddlePointExpansion.logBinomialProbability((int)(this.sampleSize - x), (int)(this.populationSize - this.numberOfSuccesses), (double)p, (double)q);
            double p3 = SaddlePointExpansion.logBinomialProbability((int)this.sampleSize, (int)this.populationSize, (double)p, (double)q);
            ret = Math.exp(p1 + p2 - p3);
        }
        return ret;
    }

    private double probability(int n, int m, int k, int x) {
        return Math.exp(MathUtils.binomialCoefficientLog((int)m, (int)x) + MathUtils.binomialCoefficientLog((int)(n - m), (int)(k - x)) - MathUtils.binomialCoefficientLog((int)n, (int)k));
    }

    @Deprecated
    public void setNumberOfSuccesses(int num) {
        this.setNumberOfSuccessesInternal(num);
    }

    private void setNumberOfSuccessesInternal(int num) {
        if (num < 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"number of successes must be non-negative ({0})", (Object[])new Object[]{num});
        }
        this.numberOfSuccesses = num;
    }

    @Deprecated
    public void setPopulationSize(int size) {
        this.setPopulationSizeInternal(size);
    }

    private void setPopulationSizeInternal(int size) {
        if (size <= 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"population size must be positive ({0})", (Object[])new Object[]{size});
        }
        this.populationSize = size;
    }

    @Deprecated
    public void setSampleSize(int size) {
        this.setSampleSizeInternal(size);
    }

    private void setSampleSizeInternal(int size) {
        if (size < 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"sample size must be positive ({0})", (Object[])new Object[]{size});
        }
        this.sampleSize = size;
    }

    public double upperCumulativeProbability(int x) {
        int[] domain = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double ret = x < domain[0] ? 1.0 : (x > domain[1] ? 0.0 : this.innerCumulativeProbability(domain[1], x, -1, this.populationSize, this.numberOfSuccesses, this.sampleSize));
        return ret;
    }

    private double innerCumulativeProbability(int x0, int x1, int dx, int n, int m, int k) {
        double ret = this.probability(n, m, k, x0);
        while (x0 != x1) {
            ret += this.probability(n, m, k, x0 += dx);
        }
        return ret;
    }
}

