/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.BinomialDistribution;
import org.apache.commons.math.distribution.SaddlePointExpansion;
import org.apache.commons.math.special.Beta;

public class BinomialDistributionImpl
extends AbstractIntegerDistribution
implements BinomialDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfTrials;
    private double probabilityOfSuccess;

    public BinomialDistributionImpl(int trials, double p) {
        this.setNumberOfTrialsInternal(trials);
        this.setProbabilityOfSuccessInternal(p);
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Deprecated
    public void setNumberOfTrials(int trials) {
        this.setNumberOfTrialsInternal(trials);
    }

    private void setNumberOfTrialsInternal(int trials) {
        if (trials < 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"number of trials must be non-negative ({0})", (Object[])new Object[]{trials});
        }
        this.numberOfTrials = trials;
    }

    @Deprecated
    public void setProbabilityOfSuccess(double p) {
        this.setProbabilityOfSuccessInternal(p);
    }

    private void setProbabilityOfSuccessInternal(double p) {
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"{0} out of [{1}, {2}] range", (Object[])new Object[]{p, 0.0, 1.0});
        }
        this.probabilityOfSuccess = p;
    }

    protected int getDomainLowerBound(double p) {
        return -1;
    }

    protected int getDomainUpperBound(double p) {
        return this.numberOfTrials;
    }

    public double cumulativeProbability(int x) throws MathException {
        double ret = x < 0 ? 0.0 : (x >= this.numberOfTrials ? 1.0 : 1.0 - Beta.regularizedBeta((double)this.getProbabilityOfSuccess(), (double)((double)x + 1.0), (double)(this.numberOfTrials - x)));
        return ret;
    }

    public double probability(int x) {
        double ret = x < 0 || x > this.numberOfTrials ? 0.0 : Math.exp(SaddlePointExpansion.logBinomialProbability((int)x, (int)this.numberOfTrials, (double)this.probabilityOfSuccess, (double)(1.0 - this.probabilityOfSuccess)));
        return ret;
    }

    public int inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return -1;
        }
        if (p == 1.0) {
            return Integer.MAX_VALUE;
        }
        return super.inverseCumulativeProbability(p);
    }
}

