/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.polynomials;

import java.util.ArrayList;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.analysis.polynomials.PolynomialsUtils;
import org.apache.commons.math.fraction.BigFraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class PolynomialsUtils {
    private static final ArrayList<BigFraction> CHEBYSHEV_COEFFICIENTS = new ArrayList();
    private static final ArrayList<BigFraction> HERMITE_COEFFICIENTS;
    private static final ArrayList<BigFraction> LAGUERRE_COEFFICIENTS;
    private static final ArrayList<BigFraction> LEGENDRE_COEFFICIENTS;

    private PolynomialsUtils() {
    }

    public static PolynomialFunction createChebyshevPolynomial(int degree) {
        return PolynomialsUtils.buildPolynomial((int)degree, (ArrayList)CHEBYSHEV_COEFFICIENTS, (RecurrenceCoefficientsGenerator)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static PolynomialFunction createHermitePolynomial(int degree) {
        return PolynomialsUtils.buildPolynomial((int)degree, (ArrayList)HERMITE_COEFFICIENTS, (RecurrenceCoefficientsGenerator)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static PolynomialFunction createLaguerrePolynomial(int degree) {
        return PolynomialsUtils.buildPolynomial((int)degree, (ArrayList)LAGUERRE_COEFFICIENTS, (RecurrenceCoefficientsGenerator)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static PolynomialFunction createLegendrePolynomial(int degree) {
        return PolynomialsUtils.buildPolynomial((int)degree, (ArrayList)LEGENDRE_COEFFICIENTS, (RecurrenceCoefficientsGenerator)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolynomialFunction buildPolynomial(int degree, ArrayList<BigFraction> coefficients, RecurrenceCoefficientsGenerator generator) {
        int maxDegree = (int)Math.floor(Math.sqrt(2 * coefficients.size())) - 1;
        Class<PolynomialsUtils> clazz = PolynomialsUtils.class;
        synchronized (PolynomialsUtils.class) {
            if (degree > maxDegree) {
                PolynomialsUtils.computeUpToDegree((int)degree, (int)maxDegree, (RecurrenceCoefficientsGenerator)generator, coefficients);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            int start = degree * (degree + 1) / 2;
            double[] a = new double[degree + 1];
            for (int i = 0; i <= degree; ++i) {
                a[i] = coefficients.get(start + i).doubleValue();
            }
            return new PolynomialFunction(a);
        }
    }

    private static void computeUpToDegree(int degree, int maxDegree, RecurrenceCoefficientsGenerator generator, ArrayList<BigFraction> coefficients) {
        int startK = (maxDegree - 1) * maxDegree / 2;
        for (int k = maxDegree; k < degree; ++k) {
            int startKm1 = startK;
            BigFraction[] ai = generator.generate(k);
            BigFraction ck = coefficients.get(startK += k);
            BigFraction ckm1 = coefficients.get(startKm1);
            coefficients.add(ck.multiply(ai[0]).subtract(ckm1.multiply(ai[2])));
            for (int i = 1; i < k; ++i) {
                BigFraction ckPrev = ck;
                ck = coefficients.get(startK + i);
                ckm1 = coefficients.get(startKm1 + i);
                coefficients.add(ck.multiply(ai[0]).add(ckPrev.multiply(ai[1])).subtract(ckm1.multiply(ai[2])));
            }
            BigFraction ckPrev = ck;
            ck = coefficients.get(startK + k);
            coefficients.add(ck.multiply(ai[0]).add(ckPrev.multiply(ai[1])));
            coefficients.add(ck.multiply(ai[1]));
        }
    }

    static {
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ZERO);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS = new ArrayList();
        HERMITE_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS.add(BigFraction.ZERO);
        HERMITE_COEFFICIENTS.add(BigFraction.TWO);
        LAGUERRE_COEFFICIENTS = new ArrayList();
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.MINUS_ONE);
        LEGENDRE_COEFFICIENTS = new ArrayList();
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ZERO);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
    }
}

