/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.core;

import eu.qimpress.ide.analysis.reliability.rmc.core.Module;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeNotFoundException;
import java.util.Set;
import java.util.TreeSet;

public class RMC {
    public String name;
    private Set<Module> modules;
    private Module initial;
    private Set<String> equations;

    public RMC(String name) {
        this.name = name;
        this.modules = new TreeSet<Module>();
        this.equations = new TreeSet<String>();
    }

    public boolean validate() {
        for (Module m : this.modules) {
            if (m.validate()) continue;
            return false;
        }
        return true;
    }

    public Module getInitialModule() {
        return this.initial;
    }

    public Set<Module> getModules() {
        return this.modules;
    }

    public void addModule(Module m, boolean initial) {
        this.modules.add(m);
        if (initial) {
            this.initial = m;
        }
    }

    public Set<String> getEquations() {
        return this.equations;
    }

    public void computeEquations() throws NodeNotFoundException {
        for (Module m : this.modules) {
            m.computeEquations();
            boolean op = this.equations.addAll(m.getEquations());
            if (op) continue;
            System.err.println("Something went wrong with module " + m.getName() + " .");
        }
    }
}

