/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.core;

import eu.qimpress.ide.analysis.reliability.rmc.core.ModuleInstantiationException;
import eu.qimpress.ide.analysis.reliability.rmc.core.Node;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeInstantiationException;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeNotFoundException;
import eu.qimpress.ide.analysis.reliability.rmc.core.NodeType;
import eu.qimpress.ide.analysis.reliability.rmc.core.ProbabilityException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class Module
implements Comparable {
    public static final int EXPECTED_NUM_NODES = 10;
    private Set<Node> nodes;
    private Node start;
    private Node end;
    private String name;
    private Set<String> equations;

    public Module(String name) {
        this.name = name;
        this.nodes = new TreeSet<Node>();
        this.equations = new TreeSet<String>();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public void addNode(Node n) throws ModuleInstantiationException {
        if (n.getType() == NodeType.START) {
            if (this.start == null) {
                this.start = n;
            } else {
                throw new ModuleInstantiationException("Duplicated START node.");
            }
        }
        if (n.getType() == NodeType.END) {
            if (this.end == null) {
                this.end = n;
            } else {
                throw new ModuleInstantiationException("Duplicated END node.");
            }
        }
        this.nodes.add(n);
    }

    public void addTransition(Node n1, Node n2, double prob) throws NodeNotFoundException, ProbabilityException, NodeInstantiationException {
        if (prob < 0.0 || prob > 1.0) {
            throw new ProbabilityException("Incorrect probability value.");
        }
        if (prob == 0.0) {
            throw new ProbabilityException("Do not add 0 probability transitions.");
        }
        n1.addSuccessor(n2, prob);
    }

    public Node getStart() {
        return this.start;
    }

    public Node getEnd() {
        return this.end;
    }

    public Set<String> getEquations() {
        return this.equations;
    }

    public void computeEquations() throws NodeNotFoundException {
        for (Node tmp : this.nodes) {
            Node tmp2;
            Iterator<Node> it;
            String tmps = "";
            if (tmp == this.end) {
                tmps = String.valueOf(this.name) + tmp.getName() + "=1";
            } else if (tmp.getType() == NodeType.FAILURE) {
                tmps = String.valueOf(this.name) + tmp.getName() + "=0";
            } else if (tmp.getType() == NodeType.CALL) {
                tmps = String.valueOf(this.name) + tmp.getName() + "=" + tmp.getModule().getName() + tmp.getModule().getStart().getName() + "*(";
                it = tmp.getSuccessors();
                while (it.hasNext()) {
                    tmp2 = it.next();
                    tmps = String.valueOf(tmps) + tmp.getProbSuccessor(tmp2) + "*" + this.name + tmp2.getName() + "+";
                }
                if (tmps.endsWith("+")) {
                    tmps = tmps.substring(0, tmps.length() - 1);
                }
                tmps = String.valueOf(tmps) + ")";
            } else {
                tmps = String.valueOf(this.name) + tmp.getName() + "=";
                it = tmp.getSuccessors();
                while (it.hasNext()) {
                    tmp2 = it.next();
                    tmps = String.valueOf(tmps) + tmp.getProbSuccessor(tmp2) + "*" + this.name + tmp2.getName() + "+";
                }
                if (tmps.endsWith("+")) {
                    tmps = tmps.substring(0, tmps.length() - 1);
                }
            }
            this.equations.add(tmps);
            String string = "";
        }
    }

    public boolean validate() {
        for (Node n : this.nodes) {
            if (n.validate()) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o.getClass() != Module.class) {
            return -10;
        }
        if (o == this) {
            return 0;
        }
        return -1;
    }
}

