/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.launch;

import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import eu.qimpress.ide.analysis.reliability.jobs.ReliabilityAnalysis;
import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.usagemodel.UsageModel;
import eu.qimpress.samm.usagemodel.UsageRepository;
import eu.qimpress.transformations.common.jobs.LoadSAMMAlternativeJob;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;

public class ReliabilityLaunchConfiguration
extends AbstractWorkflowBasedRunConfiguration {
    public static final String RESULT_PRECISION = "RESULT_PRECISION";
    public static String NO_VALUE = "";
    private static Map<String, String> modelFriendlyNames = new HashMap<String, String>();
    private IQModel usageProfileModel;
    private String alternativeId;
    private String usageModelId;
    private String qProjectName;
    private String alternativeEvaluationId;
    private String resultPrecision;

    static {
        modelFriendlyNames.put("samm_repository", "Repository");
        modelFriendlyNames.put("samm_servicearchitecturemodel", "Service Architecture");
        modelFriendlyNames.put("samm_usagemodel", "Usage Profile");
        modelFriendlyNames.put("samm_seff", "SEFF Behavioral");
        modelFriendlyNames.put("samm_qosannotation", "Annotation");
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        this.initializeFrom(configuration.getAttribute("eu.qimpress.ide.backbone.core.ui.AlternativeEvaluationSelection.project", NO_VALUE), configuration.getAttribute("eu.qimpress.reverseengineering.alternativeselection", NO_VALUE), configuration.getAttribute("eu.qimpress.ide.backbone.core.ui.UsageModelSelection.id", NO_VALUE), configuration.getAttribute("eu.qimpress.ide.backbone.core.ui.AlternativeEvaluationSelection.id", NO_VALUE), configuration.getAttribute(RESULT_PRECISION, new Integer(ReliabilityAnalysis.DEFAULT_RESULT_PRECISION).toString()));
    }

    public void initializeFrom(String qProjectname, IQAlternative alternative, String usageModelId, String alternativeEvaluationId, String resultPrecision) throws CoreException {
        this.initializeFrom(qProjectname, alternative == null ? null : alternative.getInfo().getId(), usageModelId, alternativeEvaluationId, resultPrecision);
    }

    public void initializeFrom(String qProjectname, String alternativeId, String usageModelId, String alternativeEvaluationId, String resultPrecision) throws CoreException {
        this.qProjectName = qProjectname;
        this.alternativeId = alternativeId;
        this.alternativeEvaluationId = alternativeEvaluationId;
        this.usageProfileModel = ReliabilityLaunchConfiguration.getUsageProfilesModelContainingUsageModelId(qProjectname, alternativeId, usageModelId);
        this.usageModelId = usageModelId;
        this.resultPrecision = resultPrecision;
    }

    public String getProjectName() {
        return this.qProjectName;
    }

    public IQAlternative getAlternative() {
        if (this.alternativeId == null) {
            return null;
        }
        return QImpressCore.getAlternativeById((String)this.alternativeId);
    }

    public AlternativeEvaluation getAlternativeEvaluation() {
        try {
            for (AlternativeEvaluation ae : QImpressCore.getQProject((String)this.qProjectName).getRepository().getAllAlternativeEvaluations()) {
                if (!this.alternativeEvaluationId.equals(ae.getId())) continue;
                return ae;
            }
            return this.createAlternativeEvaluation();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public AlternativeEvaluation createAlternativeEvaluation() throws RepositoryException {
        return QImpressCore.getQProject((String)this.qProjectName).getRepository().createAlternativeEvaluation(this.alternativeEvaluationId);
    }

    public String getAlternativeId() {
        return this.alternativeId;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        if (this.getAlternative() == null) {
            return "No alternative specified.";
        }
        if (this.getUsageModelId() == null || this.getUsageModelId() == "") {
            return "No usage model selected";
        }
        if (this.checkModelAvailability(this.getRepositoryModel())) {
            return this.buildModelErrorMessage("samm_repository");
        }
        if (this.checkModelAvailability(this.getAnnotationsModel())) {
            return this.buildModelErrorMessage("samm_qosannotation");
        }
        if (this.checkModelAvailability(this.getUsageProfilesModel())) {
            return this.buildModelErrorMessage("samm_usagemodel");
        }
        if (this.checkModelAvailability(this.getSeffBehavioralModel())) {
            return this.buildModelErrorMessage("samm_seff");
        }
        if (this.checkModelAvailability(this.getSammModel())) {
            return this.buildModelErrorMessage("samm_servicearchitecturemodel");
        }
        IFolder outputFolder = this.getOutputFolder();
        if (outputFolder == null) {
            return "Invalid output folder specified.";
        }
        try {
            if (this.resultPrecision() < 1) {
                return "Result precision value must be greater than 0";
            }
        }
        catch (Exception exception) {
            return "Invalid result precision value";
        }
        return null;
    }

    public String getUsageModelId() {
        return this.usageModelId;
    }

    public int resultPrecision() {
        return new Integer(this.resultPrecision);
    }

    private boolean checkModelAvailability(IQModel model) {
        IResource modelRes;
        IResource iResource = modelRes = model == null ? null : model.getCorrespondingResource();
        return modelRes == null || !(modelRes instanceof IFile) || !modelRes.isAccessible();
    }

    private String buildModelErrorMessage(String modelType) {
        return "Invalid alternative selected : " + modelFriendlyNames.get(modelType) + " model not available.";
    }

    public IQModel getRepositoryModel() {
        return this.getModelByType("samm_repository");
    }

    public IQModel getAnnotationsModel() {
        return this.getModelByType("samm_qosannotation");
    }

    public IQModel getUsageProfilesModel() {
        return this.usageProfileModel;
    }

    public IQModel getSeffBehavioralModel() {
        return this.getModelByType("samm_seff");
    }

    public IQModel getSammModel() {
        return this.getModelByType("samm_servicearchitecturemodel");
    }

    public IQModel getResultsModel() {
        try {
            return this.getAlternative().getRepository().getResultModel();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public URI getModelURI(IQModel model) {
        return LoadSAMMAlternativeJob.getURIForQIElement((IQElement)model);
    }

    public IQModel getModelByType(String modelExtension) {
        IQAlternative alternative = this.getAlternative();
        if (alternative != null) {
            IQModel[] iQModelArray = alternative.getModels();
            int n = iQModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                IQModel model = iQModelArray[n2];
                if (model.getType().equals(modelExtension)) {
                    return model;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setDefaults() {
        this.alternativeId = NO_VALUE;
        this.usageModelId = NO_VALUE;
        this.qProjectName = NO_VALUE;
        this.resultPrecision = new Integer(ReliabilityAnalysis.DEFAULT_RESULT_PRECISION).toString();
    }

    public IFolder getOutputFolder() {
        IQAlternative alternative = this.getAlternative();
        return ReliabilityLaunchConfiguration.getOutputFolder(alternative);
    }

    public static IFolder getOutputFolder(IQAlternative alternative) {
        if (alternative == null) {
            return null;
        }
        return alternative.getAlternativeFolder().getFolder("reliability-analysis");
    }

    private static IQModel getUsageProfilesModelContainingUsageModelId(String qProjectName, String alternativeId, String usageModelId) {
        IQAlternative[] alternatives;
        if (usageModelId == null) {
            return null;
        }
        IQAlternative[] iQAlternativeArray = alternatives = new IQAlternative[]{QImpressCore.getAlternativeById((String)alternativeId)};
        int n = alternatives.length;
        int n2 = 0;
        while (n2 < n) {
            IQAlternative alternative = iQAlternativeArray[n2];
            IQModel model = ReliabilityLaunchConfiguration.getUsageProfilesModelOfAlternative(alternative);
            if (model != null && model.getTopLevelEObject() != null) {
                for (UsageModel um : ((UsageRepository)model.getTopLevelEObject()).getUsageModels()) {
                    if (!usageModelId.equals(um.getId())) continue;
                    return model;
                }
            }
            ++n2;
        }
        return null;
    }

    private static IQModel getUsageProfilesModelOfAlternative(IQAlternative alternative) {
        if (alternative == null) {
            return null;
        }
        try {
            return alternative.getModel("samm_usagemodel");
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IQAlternative getGlobalAlternative(String qProjectName) {
        if (qProjectName == null || qProjectName.isEmpty()) {
            return null;
        }
        IQProject project = QImpressCore.getQProject((String)qProjectName);
        if (project == null) {
            return null;
        }
        try {
            return project.getRepository().getGlobalAlternative();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ModelLocation getSammModelLocation() {
        return new ModelLocation("eu.qimpress.samm.partition", this.getModelURI(this.getSammModel()));
    }

    public ModelLocation getUsageModelLocation() {
        return new ModelLocation("eu.qimpress.samm.partition", this.getModelURI(this.getResultsModel()));
    }

    public ServiceArchitectureModel getServiceArchitecturalModel() {
        return (ServiceArchitectureModel)this.getSammModel().getTopLevelEObject();
    }

    public UsageModel getUsageModel() {
        for (UsageModel um : ((UsageRepository)ReliabilityLaunchConfiguration.getUsageProfilesModelContainingUsageModelId(this.qProjectName, this.alternativeId, this.usageModelId).getTopLevelEObject()).getUsageModels()) {
            if (!this.usageModelId.equals(um.getId())) continue;
            return um;
        }
        return null;
    }
}

