/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.jobs.prism;

import de.uka.ipd.sdq.workflow.IJobWithResult;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.ide.analysis.reliability.jobs.prism.PrismAnalysisJobConf;
import eu.qimpress.ide.analysis.reliability.jobs.prism.StreamRedirector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrismAnalysisJob
implements IJobWithResult<Map<String, String>> {
    private static final Logger logger = Logger.getLogger(PrismAnalysisJob.class);
    private static final String JOB_NAME = "Prism Analysis";
    private PrismAnalysisJobConf conf;
    private Map<String, String> propsValues = new HashMap<String, String>();

    public PrismAnalysisJob(PrismAnalysisJobConf conf) {
        this.conf = conf;
    }

    private void check() throws JobFailedException {
        if (!this.conf.isValid()) {
            throw new JobFailedException(this.conf.getErrorMessage());
        }
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.check();
        logger.debug((Object)"Preparing prism process builder");
        ArrayList<String> args = new ArrayList<String>();
        this.configPrismExecutableByOs(args);
        try {
            logger.debug((Object)"Starting prism...");
            File execDir = this.getPrismDir();
            if (execDir != null) {
                logger.info((Object)("Using exec directory : " + execDir.toString()));
            }
            Process proc = Runtime.getRuntime().exec(args.toArray(new String[args.size()]), null, execDir);
            StreamRedirector outRed = new StreamRedirector(proc.getInputStream(), logger, StreamRedirector.Type.NORMAL);
            StreamRedirector errRed = new StreamRedirector(proc.getErrorStream(), logger, StreamRedirector.Type.ERROR);
            outRed.start();
            errRed.start();
            try {
                int exitVal = proc.waitFor();
                logger.debug((Object)("Prism terminated (exit value =" + exitVal + "), importing results..."));
                this.analyzeResults();
            }
            catch (InterruptedException e) {
                throw new JobFailedException("Unable to launch Prism analysis", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new JobFailedException("Unable to launch Prism analysis", (Throwable)e);
        }
    }

    private void configPrismExecutableByOs(List<String> args) throws JobFailedException {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            logger.debug((Object)"Detected Windows OS");
            logger.debug((Object)"Creating .bat file to run prism");
            String batFileName = this.createBatFile();
            args.add("cmd.exe");
            args.add("/C");
            args.add(batFileName);
        } else {
            logger.debug((Object)"Linux Based OS");
            args.add(this.conf.getPrismExecutable().toString());
            args.add(this.conf.getModelFile().toString());
            args.add(this.conf.getPropsFile().toString());
            args.add("-fixdl");
            args.add("-exportresults");
            args.add(this.conf.getPropsFile().toString());
        }
    }

    private String createBatFile() throws JobFailedException {
        String batFileName = String.valueOf(this.conf.getTempDir().toString()) + File.separatorChar + "analyze.bat";
        try {
            PrintWriter pw = new PrintWriter(new File(batFileName));
            try {
                pw.println("@echo off");
                pw.println("set PRISM_DIR=.");
                pw.println("path=%PRISM_DIR%\\lib;%path%");
                pw.println("set CP=%PRISM_DIR%\\lib\\prism.jar;%PRISM_DIR%\\classes;%PRISM_DIR%;%PRISM_DIR%\\lib\\pepa.zip;%PRISM_DIR%\\lib\\jcommon.jar;%PRISM_DIR%\\lib\\jfreechart.jar;%PRISM_DIR%\\lib\\epsgraphics.jar");
                pw.println("java -Djava.library.path=\"%PRISM_DIR%\\lib\" -classpath \"%CP%\" prism.PrismCL \"" + this.conf.getModelFile().toString() + "\"" + " \"" + this.conf.getPropsFile().toString() + "\"" + " -fixdl" + " -exportresults" + " \"" + this.conf.getPropsFile().toString() + "\"");
            }
            finally {
                pw.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new JobFailedException("Unable to create .bat file to run prism : " + e.getMessage());
        }
        return batFileName;
    }

    private File getPrismDir() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            String prismDir = this.conf.getPrismExecutable().toString();
            prismDir = prismDir.substring(0, prismDir.lastIndexOf(92));
            prismDir = prismDir.substring(0, prismDir.lastIndexOf(92));
            return new File(prismDir);
        }
        return null;
    }

    private void analyzeResults() throws JobFailedException {
        try {
            FileReader fr = new FileReader(this.conf.getPropsFile());
            try {
                BufferedReader br = new BufferedReader(fr);
                try {
                    try {
                        String prop = br.readLine();
                        while (prop != null) {
                            br.readLine();
                            String value = br.readLine();
                            this.propsValues.put(prop, value);
                            prop = br.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            throw new JobFailedException("Unable to close property values file", (Throwable)e);
                        }
                    }
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new JobFailedException("Unable to close property values file", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    throw new JobFailedException("Unable to close property values file", (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new JobFailedException("Unable to parse property values file", (Throwable)e);
        }
    }

    public String getName() {
        return JOB_NAME;
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public Map<String, String> getResult() {
        return this.propsValues;
    }
}

